/**************************************************************************** 
** File: igmp.h
**
** Author: Mike Borella
**
** Comments: Generic IGMP header format
**
** $Id: igmp.h,v 1.1.1.1 2004/06/21 16:57:07 dlehman Exp $
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU Library General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
**
*****************************************************************************/

#ifndef IGMP_H
#define IGMP_H

#include "global.h"
#include "local.h"

typedef struct igmp_header
{
  u_int8_t  type;
  u_int8_t  max_resp_time;
  u_int16_t checksum;
  u_int32_t address;
} igmp_header_t;

/*
 * IGMP types
 */

#define IGMP_TYPE_MEMBERQUERY      0x11
#define IGMP_TYPE_MEMBERREPORTV1   0x12
#define IGMP_TYPE_DVMRP            0x13
#define IGMP_TYPE_MEMBERREPORTV2   0x16
#define IGMP_TYPE_LEAVEGROUP       0x17

void dump_igmp(packet_t *);

#endif
