#############################################################
#
# xinetd
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
XINETD_SOURCE:=xinetd.tar.gz
XINETD_CAT:=zcat
endif

XINETD_DIR:=$(BUILD_DIR)/xinetd
XINETD_BINARY:=xinetd/xinetd
XINETD_TARGET_BINARY:=usr/sbin/xinetd

ifneq ($(USE_CVS),true)
xinetd-fetch:
	 $(WGET) -P $(DL_DIR) $(XINETD_SITE)/$(XINETD_SOURCE)

xinetd-source: $(DL_DIR)/$(XINETD_SOURCE)
else
xinetd-source:
endif

XINETD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d xinetd $(CVS_TAG) $(CVS_PREFIX)xinetd

xinetd-checkout:
	@$(XINETD_CVSCO)

$(XINETD_DIR)/.unpacked: $(DL_DIR)/$(XINETD_SOURCE)
ifneq ($(USE_CVS),true)
	$(XINETD_CAT) $(DL_DIR)/$(XINETD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(XINETD_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(XINETD_DIR)/
	cp $(SOURCE_DIR)/xinetd.conf $(XINETD_DIR)/contrib/xinetd.conf
	touch $(XINETD_DIR)/.unpacked

$(XINETD_DIR)/.configured: $(XINETD_DIR)/.unpacked
	(cd $(XINETD_DIR); rm -rf config.cache; \
		$(TARGET_CONFIGURE_OPTS) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix=$(TARGET_DIR)/usr \
		--with-libwrap \
		$(DISABLE_NLS) \
	);
	touch  $(XINETD_DIR)/.configured

$(XINETD_DIR)/$(XINETD_BINARY): $(XINETD_DIR)/.configured
	$(MAKE) -C $(XINETD_DIR)

$(TARGET_DIR)/$(XINETD_TARGET_BINARY): $(XINETD_DIR)/$(XINETD_BINARY)
	$(MAKE) -C $(XINETD_DIR) install
	$(STRIP) $(TARGET_DIR)/$(XINETD_TARGET_BINARY)
	install -m0755 $(XINETD_DIR)/contrib/xinetd $(TARGET_DIR)/etc/rc.d/init.d
	install -m0644 $(XINETD_DIR)/contrib/xinetd.conf $(TARGET_DIR)/etc
	cp -Rd $(XINETD_DIR)/contrib/xinetd.d $(TARGET_DIR)/etc/
	chmod -R g-w $(TARGET_DIR)/etc/xinetd.d
#	$(XINETD_DIR)/xinetd/xconv.pl < $(TARGET_DIR)/etc/inetd.conf > $(TARGET_DIR)/etc/xinetd.conf
	rm -rf $(TARGET_DIR)/etc/xinetd.d/CVS $(TARGET_DIR)/usr/sbin/xconv.pl
	$(SOURCE_DIR)/addservice $(TARGET_DIR) xinetd
	install -d $(DOC_DIR)/doc/xinetd
	@echo 
	@echo "TODO: make sure we clobber inetd completely or not at all"
	@echo
	for f in AUDIT COPYRIGHT README ; do \
		install -m0644 $(XINETD_DIR)/$$f $(DOC_DIR)/doc/xinetd/`basename $$f` ;\
	done

xinetd: uclibc tcp_wrappers initscripts $(TARGET_DIR)/$(XINETD_TARGET_BINARY)

xinetd-clean:
	-$(MAKE) -C $(XINETD_DIR) uninstall || -rm -f $(TARGET_DIR)/$(XINETD_TARGET_BINARY)
	-rm -rf $(TARGET_DIR)/etc/xinetd.conf \
		$(TARGET_DIR)/etc/xinetd.d \
		$(TARGET_DIR)/etc/rc.d/init.d/xinetd
	-rm -rf $(DOC_DIR)/doc/xinetd
	-$(MAKE) -C $(XINETD_DIR) clean

xinetd-dirclean:
	rm -rf $(XINETD_DIR)
endif

