#############################################################
#
# openssl
#
#############################################################

# TARGETS
ifneq ($(USE_CVS),true)
OPENSSL_SITE:=http://www.openssl.org/source
OPENSSL_SOURCE:=openssl.tar.gz
OPENSSL_DIR:=$(BUILD_DIR)/${shell basename $(OPENSSL_SOURCE) .tar.gz}

else
# using CVS
OPENSSL_DIR:=$(BUILD_DIR)/openssl
endif

OPENSSL_PATCH=$(SOURCE_DIR)/openssl.patch

ifneq ($(USE_CVS),true)
openssl-fetch:
	$(WGET) -P $(DL_DIR) $(OPENSSL_SITE)/$(OPENSSL_SOURCE)
endif

OPENSSL_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d openssl $(CVS_TAG) $(CVS_PREFIX)openssl

openssl-checkout:
	@$(OPENSSL_CVSCO)

$(OPENSSL_DIR)/.unpacked: $(DL_DIR)/$(OPENSSL_SOURCE) $(OPENSSL_PATCH)
ifneq ($(USE_CVS),true)
	gunzip -c $(DL_DIR)/$(OPENSSL_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(OPENSSL_CVSCO)
endif
	# sigh... we have to resort to this just to set a gcc flag.
	sed -i -e 's,/CFLAG=,/CFLAG= $(TARGET_SOFT_FLOAT) $(TARGET_CFLAGS),g' \
		$(OPENSSL_DIR)/Configure
	touch  $(OPENSSL_DIR)/.unpacked

$(OPENSSL_DIR)/Makefile: $(OPENSSL_DIR)/.unpacked
	(cd $(OPENSSL_DIR); \
	CFLAGS="-DOPENSSL_NO_KRB5 -DOPENSSL_NO_IDEA -DOPENSSL_NO_MDC2 -DOPENSSL_NO_RC5" \
	PATH=$(TARGET_PATH) ./Configure linux-$(ARCH) --prefix=/ \
		--openssldir=/usr/lib/ssl -L$(STAGING_DIR)/lib -ldl \
		-I$(STAGING_DIR)/usr/include $(OPENSSL_OPTS) no-threads \
		shared no-idea no-mdc2 no-rc5)
	# RH openssl RPM also uses no-ec and zlib

$(OPENSSL_DIR)/apps/openssl: $(OPENSSL_DIR)/Makefile
	$(MAKE) CC=$(TARGET_CC) -C $(OPENSSL_DIR) all build-shared
	# Work around openssl build bug to link libssl.so with libcrypto.so.
	-rm $(OPENSSL_DIR)/libssl.so.*.*.*
	$(MAKE) CC=$(TARGET_CC) -C $(OPENSSL_DIR) do_linux-shared

$(STAGING_DIR)/lib/libcrypto.a: $(OPENSSL_DIR)/apps/openssl
	$(MAKE) CC=$(TARGET_CC) INSTALL_PREFIX=$(STAGING_DIR) -C $(OPENSSL_DIR) install
	chmod +x $(STAGING_DIR)/lib/pkgconfig
	cp -fa $(OPENSSL_DIR)/libcrypto.so* $(STAGING_DIR)/lib/
	chmod a-x $(STAGING_DIR)/lib/libcrypto.so.0.9.7
	(cd $(STAGING_DIR)/lib; ln -fs libcrypto.so.0.9.7 libcrypto.so)
	(cd $(STAGING_DIR)/lib; ln -fs libcrypto.so.0.9.7 libcrypto.so.0)
	cp -fa $(OPENSSL_DIR)/libssl.so* $(STAGING_DIR)/lib/
	chmod a-x $(STAGING_DIR)/lib/libssl.so.0.9.7
	(cd $(STAGING_DIR)/lib; ln -fs libssl.so.0.9.7 libssl.so)
	(cd $(STAGING_DIR)/lib; ln -fs libssl.so.0.9.7 libssl.so.0)

$(TARGET_DIR)/usr/lib/libcrypto.so.0.9.7: $(STAGING_DIR)/lib/libcrypto.a
	touch $(TARGET_DIR)/touchme
	$(MAKE) CC=$(TARGET_CC) INSTALL_PREFIX=$(TARGET_DIR) -C $(OPENSSL_DIR) install
	chmod +x $(TARGET_DIR)/lib/pkgconfig
	cp -fa $(STAGING_DIR)/lib/libcrypto.so* $(TARGET_DIR)/usr/lib/
	cp -fa $(STAGING_DIR)/lib/libssl.so* $(TARGET_DIR)/usr/lib/
	@echo "Stripping OpenSSL binaries..."
	for f in `find $(TARGET_DIR) -type f -newer $(TARGET_DIR)/touchme \
	      -exec file {} \; | grep 'ELF.*not stripped' | cut -d: -f 1` ; do \
	    $(STRIP) $$f ; \
	done
	rm -f $(TARGET_DIR)/touchme
	-$(STRIP) --strip-unneeded $(TARGET_DIR)/usr/lib/libssl.so.0.9.7
	-$(STRIP) --strip-unneeded $(TARGET_DIR)/usr/lib/libcrypto.so.0.9.7
	mkdir -p $(DOC_DIR)/doc/openssl
	for f in FAQ LICENSE README NEWS PROBLEMS ; do \
	    install -m0644 $(OPENSSL_DIR)/$$f $(DOC_DIR)/doc/openssl/$$f ; \
	done
	for mandir in $(TARGET_DIR)/usr/lib/ssl/man/* ; do \
	    mv $$mandir/* $(TARGET_DIR)/usr/man/`basename $$mandir`/ ; \
	done
	rm -rf $(TARGET_DIR)/usr/lib/ssl/man

$(TARGET_DIR)/usr/lib/libssl.a: $(STAGING_DIR)/lib/libcrypto.a
	mkdir -p $(TARGET_DIR)/usr/include 
	cp -a $(STAGING_DIR)/usr/include/openssl $(TARGET_DIR)/usr/include/
	cp -dpf $(STAGING_DIR)/lib/libssl.a $(TARGET_DIR)/usr/lib/
	cp -dpf $(STAGING_DIR)/lib/libcrypto.a $(TARGET_DIR)/usr/lib/
	touch -c $(TARGET_DIR)/usr/lib/libssl.a

openssl-headers: $(TARGET_DIR)/usr/lib/libssl.a

openssl: uclibc $(TARGET_DIR)/usr/lib/libcrypto.so.0.9.7

openssl-source: $(DL_DIR)/$(OPENSSL_SOURCE)

openssl-clean: 
	rm -f $(STAGING_DIR)/bin/openssl  $(TARGET_DIR)/bin/openssl
	rm -f $(STAGING_DIR)/lib/libcrypto.so* $(TARGET_DIR)/lib/libcrypto.so*
	rm -f $(STAGING_DIR)/lib/libssl.so* $(TARGET_DIR)/lib/libssl.so*
	$(MAKE) -C $(OPENSSL_DIR) clean
	-rm -rf $(DOC_DIR)/doc/openssl

openssl-dirclean: 
	rm -rf $(OPENSSL_DIR) 

