#############################################################
#
# netsnmp
#
#############################################################
ifneq ($(USE_CVS),true)
NETSNMP_URL:=http://aleron.dl.sourceforge.net/sourceforge/net-snmp/

NETSNMP_SOURCE:=net-snmp.tar.gz
#NETSNMP_PATCH1:=net-snmp_5.0.7-1.1.diff.gz
NETSNMP_PATCH1_URL:=http://ftp.debian.org/debian/pool/main/n/net-snmp/
NETSNMP_DIR:=$(BUILD_DIR)/${shell basename $(NETSNMP_SOURCE) .tar.gz}
else
# using CVS
NETSNMP_DIR:=$(BUILD_DIR)/net-snmp
endif

NETSNMP_PATCH2:=$(SOURCE_DIR)/netsnmp.patch

TARGET_LOGROTATE_DIR := $(TARGET_DIR)/etc/logrotate.d

ifneq ($(USE_CVS),true)
netsnmp-fetch:
	$(WGET) -P $(DL_DIR) $(NETSNMP_URL)/$(NETSNMP_SOURCE)
	$(WGET) -P $(DL_DIR) $(NETSNMP_PATCH1_URL)/$(NETSNMP_PATCH1)
endif

NETSNMP_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d net-snmp $(CVS_TAG) $(CVS_PREFIX)net-snmp

netsnmp-checkout:
	@$(NETSNMP_CVSCO)

$(NETSNMP_DIR)/.unpacked: $(DL_DIR)/$(NETSNMP_SOURCE) $(DL_DIR)/$(NETSNMP_PATCH1)
ifneq ($(USE_CVS),true)
	zcat $(DL_DIR)/$(NETSNMP_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(NETSNMP_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(NETSNMP_DIR)/
	touch  $(NETSNMP_DIR)/.unpacked

# We set CAN_USE_SYSCTL to no and use /proc since the
# sysctl code in this thing is apparently intended for
# freebsd or some such thing...
$(NETSNMP_DIR)/.configured: $(NETSNMP_DIR)/.unpacked
	(cd $(NETSNMP_DIR);  \
		CFLAGS="$(TARGET_CFLAGS)" \
		ac_cv_CAN_USE_SYSCTL=no \
		PATH=$(TARGET_PATH) \
		./configure \
		--with-cc=$(TARGET_CROSS)gcc \
		--with-ar=$(TARGET_CROSS)ar \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--with-endianness=big \
		--with-persistent-directory=/var/lib/snmp \
		--enable-ucd-snmp-compatibility \
		--enable-shared \
		--with-logfile=none \
		--without-rpm \
		--with-openssl \
		--without-dmalloc \
		--without-efence \
		--without-rsaref \
		--with-sys-contact="root" \
		--with-sys-location="Unknown" \
		--with-mib-modules="host smux ucd-snmp/dlmod" \
		--with-defaults \
		--prefix=/usr \
		--sysconfdir=/etc \
		--mandir=/usr/man \
		--infodir=/usr/info \
		--enable-ipv6 \
	);
	touch  $(NETSNMP_DIR)/.configured

$(NETSNMP_DIR)/agent/snmpd: $(NETSNMP_DIR)/.configured
	$(MAKE) -C $(NETSNMP_DIR)

$(STAGING_DIR)/usr/lib/libsnmp.so: $(NETSNMP_DIR)/agent/snmpd
	touch $(NETSNMP_DIR)/touchme
	$(MAKE) PREFIX=$(STAGING__DIR)/usr \
	    prefix=$(STAGING_DIR)/usr \
	    exec_prefix=$(STAGING_DIR)/usr \
	    persistentdir=$(STAGING_DIR)/var/lib/snmp \
	    infodir=$(STAGING_DIR)/usr/info \
	    mandir=$(STAGING_DIR)/usr/man \
	    includedir=$(STAGING_DIR)/usr/include/net-snmp \
	    ucdincludedir=$(STAGING_DIR)/usr/include/ucd-snmp \
	    -C $(NETSNMP_DIR) installlibs installheaders;
	rm -rf $(TARGET_DIR)/share/locale
		# Install the "broken" headers
	cp $(NETSNMP_DIR)/agent/mibgroup/struct.h $(STAGING_DIR)/usr/include/net-snmp/agent
	cp $(NETSNMP_DIR)/agent/mibgroup/util_funcs.h $(STAGING_DIR)/usr/include/net-snmp
	cp $(NETSNMP_DIR)/agent/mibgroup/mibincl.h $(STAGING_DIR)/usr/include/net-snmp/library
	cp $(NETSNMP_DIR)/agent/mibgroup/header_complex.h $(STAGING_DIR)/usr/include/net-snmp/agent


$(TARGET_DIR)/usr/sbin/snmpd: $(STAGING_DIR)/usr/lib/libsnmp.so
	touch $(NETSNMP_DIR)/touchme
	$(MAKE) PREFIX=$(TARGET_DIR)/usr \
	    prefix=$(TARGET_DIR)/usr \
	    exec_prefix=$(TARGET_DIR)/usr \
	    persistentdir=$(TARGET_DIR)/var/lib/snmp \
	    infodir=$(TARGET_DIR)/usr/info \
	    mandir=$(TARGET_DIR)/usr/man \
	    includedir=$(STAGING_DIR)/usr/include/net-snmp \
	    ucdincludedir=$(STAGING_DIR)/usr/include/ucd-snmp \
	    -C $(NETSNMP_DIR) install;
	rm -rf $(TARGET_DIR)/share/locale
	rm -f $(TARGET_DIR)/usr/lib/lib*snmp*.la
	# Copy the .conf files.
	mkdir -p $(TARGET_DIR)/etc/snmp
	cp $(NETSNMP_DIR)/EXAMPLE.conf $(TARGET_DIR)/etc/snmp/snmpd.conf
	cp $(NETSNMP_DIR)/EXAMPLE-trap.conf $(TARGET_DIR)/etc/snmp/snmptrapd.conf
	-mv $(TARGET_DIR)/usr/share/snmp/mib2c*.conf $(TARGET_DIR)/etc/snmp
	# Remove the unsupported snmpcheck program
	rm $(TARGET_DIR)/usr/bin/snmpcheck
	# remove snmpconf if we have no perl
	test -e $(TARGET_DIR)/usr/bin/perl || rm $(TARGET_DIR)/usr/bin/snmpconf
	# Install the "broken" headers
	for f in `find $(TARGET_DIR) -type f -newer $(NETSNMP_DIR)/touchme -exec file {} \; | \
	  grep "ELF.*not stripped" | cut -d : -f 1 ` ; do \
	    $(STRIP) $$f ; \
	done;
	if [ -d $(TARGET_DIR)/etc/rc.d/init.d ]; then \
		sed -i -e 's,usr/local/,usr/,g' \
			-e 's,/usr/share/snmp,/etc/snmp,' \
			$(NETSNMP_DIR)/dist/snmpd-init.d ; \
		install -m0755 $(NETSNMP_DIR)/dist/snmpd-init.d \
			$(TARGET_DIR)/etc/rc.d/init.d/snmpd ; \
	fi
	rm -f $(NETSNMP_DIR)/touchme
	mkdir -p $(DOC_DIR)/doc/net-snmp
	for f in COPYING EXAMPLE.conf EXAMPLE-trap.conf FAQ NEWS README README.snmpv3 README.agentx AGENT.txt ; do \
	    install -m0644 $(NETSNMP_DIR)/$$f $(DOC_DIR)/doc/net-snmp/$$f ; \
	done
	if [ ! -d $(TARGET_LOGROTATE_DIR) ]; then \
		mkdir --mode=0755 -p $(TARGET_LOGROTATE_DIR); \
	fi
	install -m0644 $(SOURCE_DIR)/ucd-snmpd.logrotate $(TARGET_LOGROTATE_DIR)/snmpd

netsnmp: uclibc openssl $(TARGET_DIR)/usr/sbin/snmpd

netsnmp-headers: $(TARGET_DIR)/usr/include/net-snmp/net-snmp-config.h
	cp -a $(STAGING_DIR)/usr/include/net-snmp $(TARGET_DIR)/usr/include/net-snmp
	cp -a $(STAGING_DIR)/usr/include/ucd-snmp $(TARGET_DIR)/usr/include/net-snmp

netsnmp-source: $(DL_DIR)/$(NETSNMP_SOURCE)

netsnmp-clean:
	$(MAKE) -C $(NETSNMP_DIR) clean
	# I think this is pretty much all of it
	-rm -rf $(TARGET_DIR)/etc/snmp \
		$(TARGET_DIR)/usr/bin/snmp* \
		$(TARGET_DIR)/usr/sbin/snmp* \
		$(TARGET_DIR)/usr/lib/lib*snmp* \
		$(TARGET_DIR)/etc/rc.d/init.d/snmpd
	-rm -rf $(DOC_DIR)/doc/net-snmp

netsnmp-dirclean: 
	rm -rf $(NETSNMP_DIR)

