#############################################################
#
# linuxftpd
#
#############################################################
ifneq ($(USE_CVS),true)
LINUXFTPD_SOURCE:=linux-ftpd.tar.gz
LINUXFTPD_SITE:=ftp://ftp.uk.linux.org/pub/linux/Networking/netkit/
LINUXFTPD_DIR:=$(BUILD_DIR)/${shell basename $(LINUXFTPD_SOURCE) .tar.gz}

LINUXFTPD_CAT:=zcat
else
# using CVS
LINUXFTPD_DIR:=$(BUILD_DIR)/linux-ftpd
endif

LINUXFTPD_BINARY:=ftpd/ftpd
LINUXFTPD_TARGET_BINARY:=usr/sbin/in.ftpd
LINUXFTPD_PATCH:=$(SOURCE_DIR)/linuxftpd.patch

ifneq ($(USE_CVS),true)
linuxftpd-fetch:
	 $(WGET) -P $(DL_DIR) $(LINUXFTPD_SITE)/$(LINUXFTPD_SOURCE)

linuxftpd-source: $(DL_DIR)/$(LINUXFTPD_SOURCE)
else
linuxftpd-source:
endif

LINUXFTPD_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d linux-ftpd $(CVS_TAG) $(CVS_PREFIX)linux-ftpd

linuxftpd-checkout:
	@$(LINUXFTPD_CVSCO)

$(LINUXFTPD_DIR)/.unpacked: $(DL_DIR)/$(LINUXFTPD_SOURCE)
ifneq ($(USE_CVS),true)
	$(LINUXFTPD_CAT) $(DL_DIR)/$(LINUXFTPD_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(LINUXFTPD_CVSCO)
endif
	touch $(LINUXFTPD_DIR)/.unpacked

$(LINUXFTPD_DIR)/.configured: $(LINUXFTPD_DIR)/.unpacked
	(cd $(LINUXFTPD_DIR); PATH=$(TARGET_PATH) CC=$(TARGET_CC) \
		CFLAGS="$(TARGET_CFLAGS)" \
		./configure --installroot=$(TARGET_DIR) --with-c-compiler=$(TARGET_CC) \
	)
	touch  $(LINUXFTPD_DIR)/.configured

$(LINUXFTPD_DIR)/$(LINUXFTPD_BINARY): $(LINUXFTPD_DIR)/.configured
	$(MAKE) CC=$(TARGET_CC) -C $(LINUXFTPD_DIR)

$(TARGET_DIR)/$(LINUXFTPD_TARGET_BINARY): $(LINUXFTPD_DIR)/$(LINUXFTPD_BINARY)
	$(MAKE) INSTALLROOT=$(TARGET_DIR) -C $(LINUXFTPD_DIR) install
	$(STRIP) $(TARGET_DIR)/usr/sbin/in.ftpd
	# Enable ftp in inetd
	sed -i -e "s~^#ftp.*~ftp\tstream\ttcp\tnowait\troot\t/usr/sbin/in.ftpd\t/usr/sbin/in.ftpd~;" $(TARGET_DIR)/etc/inetd.conf
	mkdir -p $(DOC_DIR)/doc/linux-ftpd
	install -m0644 $(LINUXFTPD_DIR)/README $(DOC_DIR)/doc/linux-ftpd/

linuxftpd: uclibc $(TARGET_DIR)/$(LINUXFTPD_TARGET_BINARY)

linuxftpd-clean:
	-rm -f $(TARGET_DIR)/$(LINUXFTPD_TARGET_BINARY)
	-$(MAKE) -C $(LINUXFTPD_DIR) clean
	-rm -rf $(DOC_DIR)/doc/linux-ftpd

linuxftpd-dirclean:
	rm -rf $(LINUXFTPD_DIR)

