#
# GNUPro
#
#################################################
ifeq ($(USE_GNUPRO_TOOLS),true)
GNUPRO_ORIG_ROOT:=$(shell which $(TARGET_CROSS)gcc 2>/dev/null | sed 's,/[^/]*/[^/]*$$,,;')
# host triplet
GNUPRO_TRIPLET:=$(notdir $(GNUPRO_ORIG_ROOT))
# top dir of original GNUPro toolchain
GNUPRO_ORIG_ROOT:=$(dir $(GNUPRO_ORIG_ROOT))
GNUPRO_ORIG_ROOT:=$(GNUPRO_ORIG_ROOT:/=)
# the toolchain's release name
GNUPRO_RELEASE:=$(notdir $(GNUPRO_ORIG_ROOT))

# various directories in our new copy of the toolchain
GNUPRO_DIR:=$(BUILD_DIR)/$(GNUPRO_RELEASE)
GNUPRO_BINDIR:=$(GNUPRO_DIR)/$(GNUPRO_TRIPLET)/bin
GNUPRO_TARGET_DIR:=$(GNUPRO_DIR)/$(GNUPRO_TRIPLET)/$(TARGET_CROSS:-=)

TARGET_CROSS:=$(GNUPRO_BINDIR)/$(TARGET_CROSS)

# libc files (we get them from the toolchain's sys-root)
LIBC_DEVEL_LIB:=$(STAGING_DIR)/usr/lib/libc.so
ifeq ($(USE_GLIBC),true)
LIBC_SHARED_LIB:=$(TARGET_DIR)/lib/libc.so.6
else
LIBC_SHARED_LIB:=$(TARGET_DIR)/lib/libc.so.0
endif

$(GNUPRO_ORIG_ROOT):
	@echo "Error: you don't have $(TARGET_CROSS)gcc in your PATH"
	exit 1

$(GNUPRO_DIR): $(GNUPRO_ORIG_ROOT)
	@echo "GNUPRO_DIR is $(GNUPRO_DIR)"
	@if [ ! -d $(GNUPRO_DIR) ]; then \
	    cp -a $(GNUPRO_ORIG_ROOT) $(GNUPRO_DIR) ; \
	    mv $(GNUPRO_TARGET_DIR)/sys-root $(GNUPRO_TARGET_DIR)/sys-root-orig ; \
	    ln -sf $(STAGING_DIR) $(GNUPRO_TARGET_DIR)/sys-root 2>/dev/null || : ; \
	fi

$(LIBC_DEVEL_LIB): $(GNUPRO_DIR)
	@if [ ! -f $(LIBC_DEVEL_LIB) ]; then \
	    cp -a $(GNUPRO_TARGET_DIR)/sys-root-orig/* $(STAGING_DIR)/ ; \
	    mv $(STAGING_DIR)/usr/lib/* $(STAGING_DIR)/lib/ ; \
	    rm -rf $(STAGING_DIR)/usr/lib ; \
	    ln -sf ../lib $(STAGING_DIR)/usr/lib 2>/dev/null || : ; \
	    for SL in `find $(STAGING_DIR)/lib/ -maxdepth 1 -type l`; do \
		DEST=`readlink $$SL` ; [ -e "$$DEST" ] && continue ; \
		BASE=`basename $$DEST` ; DIR=`dirname $$SL`; \
		[ -f "$$DIR/$$BASE" ] && ln -sf $$BASE $$SL ; \
	    done ; \
	fi

$(LIBC_SHARED_LIB): $(LIBC_DEVEL_LIB)
	cp -a $(GNUPRO_TARGET_DIR)/sys-root-orig/lib $(TARGET_DIR)/
	if test -d $(GNUPRO_TARGET_DIR)/sys-root-orig/sbin; then \
	  mkdir -p $(TARGET_DIR)/etc $(TARGET_DIR)/sbin; \
	  cp -p $(GNUPRO_TARGET_DIR)/sys-root-orig/sbin/* \
	    $(TARGET_DIR)/sbin/; fi
	if test -d $(GNUPRO_TARGET_DIR)/sys-root-orig/etc; then \
	  cp -p $(GNUPRO_TARGET_DIR)/sys-root-orig/etc/* $(TARGET_DIR)/etc/; \
	fi
	cp -p $(GNUPRO_TARGET_DIR)/lib/libgcc_s.so* \
		$(GNUPRO_TARGET_DIR)/lib/libstdc++.so* \
		$(TARGET_DIR)/lib/

gnupro: $(LIBC_SHARED_LIB) $(TARGET_CROSS)gcc

gnupro-clean:
	-rm -f $(LIBC_SHARED_LIB) $(LIBC_DEVEL_LIB)

gnupro-dirclean:
	-rm -rf $(GNUPRO_DIR)

uclibc: $(LIBC_SHARED_LIB)

gnupro-checkout:

uclibc-checkout:

endif

