/* System-specific settings for dynamic linker code.  FR-V version.
   Copyright (C) 2002, 2003, 2004 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

#ifndef _DL_SYSDEP_H
#define _DL_SYSDEP_H   1

/* This macro must be defined to either 0 or 1.

   If 1, then an errno global variable hidden in ld.so will work right with
   all the errno-using libc code compiled for ld.so, and there is never a
   need to share the errno location with libc.  This is appropriate only if
   all the libc functions that ld.so uses are called without PLT and always
   get the versions linked into ld.so rather than the libc ones.  */

#ifdef IS_IN_rtld
# define RTLD_PRIVATE_ERRNO 1
#else
# define RTLD_PRIVATE_ERRNO 0
#endif

#define DL_LOOKUP_RETURNS_MAP

#define DL_LOADADDR_TYPE struct elf32_fdpic_loadaddr

#define DL_INIT_LOADADDR_MAP(l, mapstart, mapbaseaddr, maplength) \
  ((l)->l_addr.map = malloc (sizeof (*(l)->l_addr.map) + 1 * sizeof (*(l)->l_addr.map->segs)), \
   (l)->l_addr.map->version = 0, \
   (l)->l_addr.map->nsegs = 1, \
   (l)->l_addr.map->segs[0].p_vaddr = (mapstart), \
   (l)->l_map_start = (l)->l_addr.map->segs[0].addr \
     = (l)->l_addr.map->segs[0].p_vaddr + (mapbaseaddr), \
   (l)->l_addr.map->segs[0].p_memsz = (maplength), \
   (l)->l_map_end = (l)->l_addr.map->segs[0].addr \
     + (l)->l_addr.map->segs[0].p_memsz, \
   (l)->l_addr.got_value = 0, \
   (void)0)

/* When ld.so is the main executable, we must not override the address
   information set up by loading the executable passed to it as an
   argument.  */
#define DL_INIT_LOADADDR_EXEC(l, v) \
  (rtld_is_main ? (void)0 \
   : (((l)->l_addr.map = frv_prog_load_map), \
      ((l)->l_addr.got_value = 0)))

#define DL_RELOC_ADDR(addr, base) \
  ((ElfW(Addr)) __RELOC_POINTER ((addr), (base)))

#define DL_RELOC_LOOKUP_ADDR(addr, map) \
    (map ? DL_RELOC_ADDR ((addr), (map)->l_addr) : 0)

#define DL_UNRELOC_ADDR(addr, base) \
  ((ElfW(Addr)) __UNRELOC_POINTER ((addr), (base)))

#define DL_MAIN_PROG_LOADADDR() (GL(dl_loaded)->l_addr)

#define DL_NONZERO_RELOC(l_addr) 1

#define DL_LOADADDR_ID(l_addr) ((ElfW(Addr)) (l_addr).got_value)

#define DL_LOAD_AS_PIE(type) ((void)(type), 1)

/* This is where the kernel maps executables.  We want them at the
   same location, such that ld.so --list works.  It will already be
   taken for shared libs, but it doesn't matter.  */
#define ELF_PREFERRED_ADDRESS(loader, length, start) (0x02200000)

#include <link.h>
#include <dl-fptr.h>

typedef union {
  struct fdesc desc;
  unsigned long long asint;
} frv_fdesc_t __attribute__((__aligned__(8)));

#include <link.h>

/* Map an address to the corresponding VMA according to the
   load map.  */
inline static void *
__unreloc_pointer (void *p,
		   const struct elf32_fdpic_loadmap *map)
{
  int c;

#if 0
  if (map->version != 0)
    /* Crash.  */
    ((void(*)())0)();
#endif

  /* No special provision is made for NULL.  We don't want NULL
     addresses to go through relocation, so they shouldn't be in
     .rofixup sections, and, if they're present in dynamic
     relocations, they shall be mapped to the NULL address without
     undergoing relocations.  */

  for (c = 0;
       /* Take advantage of the fact that the loadmap is ordered by
	  virtual addresses.  In general there will only be 2 entries,
	  so it's not profitable to do a binary search.  */
       c < map->nsegs && p >= (void*)map->segs[c].addr;
       c++)
    {
      /* This should be computed as part of the pointer comparison
	 above, but we want to use the carry in the comparison, so we
	 can't convert it to an integer type beforehand.  */
      unsigned long offset = p - (void*)map->segs[c].addr;
      /* We explicitly refrain from checking for one-past-the-end.
	 Zero-sized objects aren't legal, and it's expected that array
	 addresses will be relocated before the addend that would make
	 it one-past-the-end is added.  This gives us a reasonable speed
	 up, and we couldn't possibly disambiguate all cases anyway.  */
      if (offset < map->segs[c].p_memsz)
	return (char*)map->segs[c].p_vaddr + offset;
    }
	     
  /* We might want to crash instead.  */
  return (void*)-1;
}

# define __UNRELOC_POINTER(ptr, loadaddr) \
  (__unreloc_pointer ((void*)(ptr), (loadaddr).map))

#endif /* dl-sysdep.h */
