Summary: The NIS daemon which binds NIS clients to an NIS domain.
Name: ypbind
Version: 1.17.2
Release: 3.gnupro.1
License: GPL
Group: System Environment/Daemons
Source0: ftp://ftp.us.kernel.org/pub/linux/utils/net/NIS/ypbind-mt-%{PACKAGE_VERSION}.tar.bz2
Url: http://www.linux-nis.org/nis/ypbind-mt/index.html
Source1: ypbind.init
Patch1: ypbind-1.11-broadcast.patch
Patch2: ypbind-1.11-gettextdomain.patch
Patch3: ypbind-mt-1.16-bindingrace.patch
Patch4: ypbind-mt-1.16-nullhandle.patch
Patch10000: ypbind-1.17.2-cross.patch
Prereq: /sbin/chkconfig
Requires: portmap, yp-tools, bash >= 2.0
Epoch: 3
Buildroot: %{_tmppath}/%{name}-%{version}-root

%description
The Network Information Service (NIS) is a system that provides
network information (login names, passwords, home directories, group
information) to all of the machines on a network. NIS can allow users
to log in on any machine on the network, as long as the machine has
the NIS client programs running and the user's password is recorded in
the NIS passwd database. NIS was formerly known as Sun Yellow Pages
(YP).

This package provides the ypbind daemon. The ypbind daemon binds NIS
clients to an NIS domain. Ypbind must be running on any machines
running NIS client programs.

Install the ypbind package on any machines running NIS client programs
(included in the yp-tools package). If you need an NIS server, you
also need to install the ypserv package to a machine on your network.

%prep
%setup -q -n ypbind-mt-%{version}
%patch1 -p1 -b .broadcast
%patch2 -p1 -b .fixit
%patch3 -p1 -b .race
%patch4 -p1 -b .nullhandle

%if "%{_arch}" != %{_build_arch}
%patch10000 -p1 -b .cross
aclocal -I m4
automake --gnits
autoconf
%endif

%build
%configure --sbindir=/sbin
make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall sbindir=$RPM_BUILD_ROOT/sbin

mkdir -p $RPM_BUILD_ROOT/etc/rc.d/init.d $RPM_BUILD_ROOT/var/yp/binding
install -m 644 etc/yp.conf $RPM_BUILD_ROOT/etc/yp.conf
install -m 755 %{SOURCE1} $RPM_BUILD_ROOT/etc/rc.d/init.d/ypbind

%{find_lang} %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%post
/sbin/chkconfig --add ypbind

%preun
if [ "$1" = 0 ] ; then
    /sbin/service ypbind stop > /dev/null 2>&1
    /sbin/chkconfig --del ypbind
fi
exit 0

%postun
if [ "$1" -ge 1 ]; then
    /sbin/service ypbind condrestart > /dev/null 2>&1
fi
exit 0

%files -f %{name}.lang
%defattr(-,root,root)
/sbin/ypbind
%{_mandir}/*/*
%config /etc/rc.d/init.d/*
%config(noreplace) /etc/yp.conf
%dir /var/yp
%dir /var/yp/binding
%doc README NEWS

%changelog
* Fri Oct 15 2004 Steve Dickson <SteveD@RedHat.com>
- Sped up the ypbind initscript by using fgrep
  instead of grep (bz# 81247)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Feb 24 2004 Phil Knirsch <pknirsch@redhat.com> 1.17.2-1
- Another updated to latest upstream version.

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Jan 19 2004 Phil Knirsch <pknirsch@redhat.com> 1.16-1
- Updated to latest upstream version.

* Thu Nov 20 2003 Steve Dickson <SteveD@RedHat.com>
- Added a NULL check to test_bindings() to make sure
  clnt_call() is not called with a NULL pointer.

* Sat Oct  4 2003 Steve Dickson <SteveD@RedHat.com>
- Updated Release number for RHEL3 QU1

* Tue Sep  9 2003 Steve Dickson <SteveD@RedHat.com>
- Fixed a binding race where the wrong results were being returned.

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed May 21 2003 Bill Nottingham <notting@redhat.com> 1.12-1.10
- make yp.conf %config(noreplace)

* Thu Apr 24 2003 Steve Dickson <SteveD@RedHat.com>
- Updated to 1.12 from upstream.
- Removed ypbind-1.8-dos.patch since it
  was already commented out
- Updated broadcast patch

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Mon Nov 18 2002 Tim Powers <timp@redhat.com>
- build on all arches

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Tue Jun 11 2002 Alex Larsson <alexl@redhat.com> 1.11-1
- Updated to 1.11 from upstream.
- Removed patche that went in upstream.
- Updated broadcast patch

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Mar 25 2002 Alex Larsson <alexl@redhat.com> 1.10-7
- Get failure message right in init script (#37463 again)

* Mon Mar 25 2002 Alex Larsson <alexl@redhat.com> 1.10-6
- Fix bugs in initscript. Should fix #37463 and #61857

* Mon Mar 25 2002 Alex Larsson <alexl@redhat.com> 1.10-5
- New config patch that handles failing gethostbynames even better

* Thu Mar 21 2002 Alex Larsson <alexl@redhat.com> 1.10-4
- Added patch to avoid hanging if gethostbyname fails. (#56322)

* Sun Mar 10 2002 Florian La Roche <Florian.LaRoche@redhat.de>
- fixed #57393

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Sat Nov 17 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- update to version 1.10

* Mon Aug 13 2001 Preston Brown <pbrown@redhat.com>
- eliminate potential DOS attack via ypwhich (#38637)
- install PO files

* Tue Jul 17 2001 Karsten Hopp <karsten@redhat.de>
- own /var/yp

* Fri Jun 29 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.8

* Sun Jun 24 2001 Elliot Lee <sopwith@redhat.com>
- Bump release + rebuild.

* Fri Jun  4 2001 Preston Brown <pbrown@redhat.com>
- small fixes for initscript. Sometimes had trouble on slower systems (#37463)

* Sat Mar  3 2001 Preston Brown <pbrown@redhat.com>
- much more sane ypbind init script for when networking is down.

* Wed Feb  7 2001 Trond Eivind Glomsrd <teg@redhat.com>
- fix "usage" string (use $0)

* Wed Jan 24 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- prepare for initscript translation
- do not prereq /etc/init.d

* Thu Jan 11 2001 Bernhard Rosenkraenzer <bero@redhat.com>
- Start after netfs (#23526)

* Wed Nov 29 2000 Bill Nottingham <notting@redhat.com>
- set NIS domain name if it's not already set

* Mon Oct 02 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- update to 1.7

* Thu Aug 31 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- add again automatic fallback to broadcast

* Sun Aug 20 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- fix condrestart #16615
- security fix for syslog() call

* Sun Aug  6 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- do not include broadcast fallback until it is more tested

* Sun Aug  6 2000 Florian La Roche <Florian.LaRoche@redhat.de>
- add automatic fallback to broadcast
- add "exit 0" to the scripts

* Wed Aug  2 2000 Bill Nottingham <notting@redhat.com>
- turn off broadcast; authconfig will enable this...
- put the pid that's actually listening to signals in the pidfile

* Thu Jul 20 2000 Bill Nottingham <notting@redhat.com>
- move initscript back

* Thu Jul 13 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Fri Jul  7 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- prereq init.d

* Wed Jul  5 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- re-enable broadcasts

* Tue Jul  4 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- fix scripts

* Mon Jul  3 2000 Nalin Dahyabhai <nalin@redhat.com>
- bump epoch

* Mon Jul  3 2000 Florian La Roche <Florian.LaRoche@redhat.com>
- switch from ypbind to ypbind-mt
