; $Id: t362.scm,v 1.1.1.1 2003/02/18 20:59:36 green Exp $ 

; { dg-output "foofoo#t#f#t#f" }

; Sample from the old Guile docs

(define fred (make-array #f 8 8))

(define freds-diagonal
  (make-shared-array fred (lambda (i) (list i i)) 8))

(array-set! freds-diagonal 'foo 3)

(display (array-ref fred 3 3))

(define freds-center
  (make-shared-array fred (lambda (i j) (list (+ 3 i) (+ 3 j))) 2 2))

(display (array-ref freds-center 0 0))

;; Array in bounds tests
;;
(display (array-in-bounds? fred 3 3))
(display (array-in-bounds? fred 33 33))
(let ((ua (make-uniform-array () 5)))
  (display (array-in-bounds? ua 3))
  (display (array-in-bounds? ua 33)))


;; Array set tests
;;
(define (append-test-list size list value)
  (if (> size 0)
      (append-test-list (- size 1) (cons value list) value)
      list))

(defmacro test-uniform-array (proto size value sproto . junk)
  `(let ((a1 (make-uniform-array ,proto ,size))
	 (a2 (list->uniform-vector ,proto (append-test-list ,size (list) ,value))))

     (if (not (equal? (array-prototype a1) ,sproto))
	 (display 'Proto-Fail))

; This is not yet supported for many array types
;     (if (not (equal? (make-uniform-array ,proto (* ,size 2))
;		      (concatenate a1 a1)))
;	 (display 'Concat-Fail))

     (if (not (array-equal? a1 (array-contents a1)))
	 (display 'SharedEqual-Fail))

     (if (not (array? a1))
	 (display 'Array?-Fail))

     (uniform-vector-fill! a1 ,value)
     (if (not (equal? a1 a2))
	 (display 'Fill-Fail))

     (if (not (equal? (array->list a1) (append-test-list ,size (list) ,value)))
	 (display 'Array->List-Fail))

     (array-set! a1 ,value 0)
     (serial-array-copy! a1 a2)

     (if (not (eq? ,size (uniform-vector-length a2)))
	 (display 'Length-Fail))

     ; The next test doesn't work for byte vectors
     (if (not (equal? ,proto #\000))

	 (if (not (equal? ,value (array-ref a1 0)))
	     (display 'Set/Ref-Fail)))

     (if (not (equal? a1 a2))
	 (display 'Copy-Fail))
     
     (let* ((ta1 (make-uniform-array ,proto ,size ,size))
	    (ta2 (transpose-array ta1 1 0)))

       (if (not (array-equal? ta1 ta2))
	   (display 'Trans-Fail))

       (let ((ea1 (enclose-array ta1 1)))

	 (if (not (equal? (list (list 0 (- ,size 1)))
			  (array-shape ea1)))
	     (display 'EncArrShape-Fail)))
       )

     (let ((m (make-uniform-array ,proto ,size)))
       (array-map! a1 (lambda (v) v) m)
       (if (not (array-equal? a1 m))
	   (display 'ArrayMap-Fail)))

     ; Not really tested. Just excercised.
     (if (number? ,proto)
	 (let ((result (make-uniform-array ,proto ,size)))
	   (serial-array-map! result + a1 a1)
	   (serial-array-map! result - a1 a1)
	   (serial-array-map! result * a1 a1)
	   (serial-array-map! result / a1 a1)))

     ; Test reading and writing uniform arrays.
     ; This is only implemented for certain types of arrays.
     (if (member ,proto '(1 1/3 555.555 -1 10+4i #\000 #\a))

	 (let ((xxx1 (make-uniform-array ,proto ,size))
	       (xxx2 (make-uniform-array ,proto ,size)))
       
	   (display "#")

	   (let ((f (tmpnam))
		 (p #f))
	     (set! p (open-file f "w"))
	     (uniform-array-write xxx1 p)
	     (close-port p)
	     (set! p (open-file f "r"))
	     (uniform-array-read! xxx2 p)
	     (close-port p)
	     (if (not (array-equal? xxx1 xxx2))
		 (display 'Array-I/O-Fail)))))

     ; Force more coverage in mark-sweep
     (gc)))

(test-uniform-array () 5 #t #f)
(test-uniform-array "a" 5 "b" #f)
(test-uniform-array 1 5 0 1)
(test-uniform-array 1/3 5 3/1 (/ 1 3))
(test-uniform-array 555.555 5 666.666 (/ 1 3))
; This one is buggy!
; (test-uniform-array 's 5 678) 
(test-uniform-array -1 5 0 -1)
(test-uniform-array #\a 5 #\x #\a)
(test-uniform-array 10+4i 5 3+3i 0.0+1.0i)
(test-uniform-array #\000 5 #\003 #\nul)

