Summary: A tool for determining compilation options.
Name: pkgconfig
Version: 0.15.0
Release: 3.gnupro.1
Epoch: 1
License: GPL
Group: Development/Tools
Source:  http://www.freedesktop.org/software/pkgconfig/releases/%{name}-%{version}.tar.gz
%if "%{_arch}" == %{_build_arch}
BuildPrereq: autoconf213 automake14
%endif
# http://x2.freedesktop.org/cgi-bin/bugzilla/show_bug.cgi?id=125
Patch1:  pkgconfig-0.14.0-lib64.patch
# http://x2.freedesktop.org/cgi-bin/bugzilla/show_bug.cgi?id=119
Patch2:  pkgconfig-0.14.0-datadir.patch
Patch3:  pkgconfig-0.15.0-quote.patch
Patch10000: glib-1.2.8-cross.patch
BuildRoot: %{_tmppath}/%{name}-root

%description
The pkgconfig tool determines compilation options. For each required
library, it reads the configuration file and outputs the necessary
compiler and linker flags.

%prep
%setup -q
%patch1 -p1 -b .lib64
%patch2 -p1 -b .datadir
%patch3 -p1 -b .quote
%if "%{_arch}" != %{_build_arch}
pushd glib-1.2.8
%patch10000 -p1 -b .cross
autoconf-2.13
popd
%endif
autoheader-2.13
autoconf-2.13
automake-1.4

%build
%if "%{_arch}" != %{_build_arch}
glib_cv_prog_cc_ansi_proto=no; export glib_cv_prog_cc_ansi_proto
glib_cv_has__inline=yes; export glib_cv_has__inline
glib_cv_has__inline__=yes; export glib_cv_has__inline__
glib_cv_hasinline=yes; export glib_cv_hasinline
glib_cv_sane_realloc=yes; export glib_cv_sane_realloc
glib_cv_rtldglobal_broken=no; export glib_cv_rtldglobal_broken
glib_cv_uscore=no; export glib_cv_uscore
ac_cv_func_getpwuid_r=yes; export ac_cv_func_getpwuid_r
glib_cv_func_pthread_mutex_trylock_posix=yes; export glib_cv_func_pthread_mutex_trylock_posix
glib_cv_func_pthread_cond_timedwait_posix=yes; export glib_cv_func_pthread_cond_timedwait_posix
%ifarch mips mipsel armv5l armv5b armv4l armv4b %{ix86} am33_2.0
ac_cv_sizeof_char=1; export ac_cv_sizeof_char
ac_cv_sizeof_short=2; export ac_cv_sizeof_short
ac_cv_sizeof_long=4; export ac_cv_sizeof_long 
ac_cv_sizeof_int=4; export ac_cv_sizeof_int 
ac_cv_sizeof_void_p=4; export ac_cv_sizeof_void_p 
ac_cv_sizeof_long_long=8; export ac_cv_sizeof_long_long
glib_cv_va_copy=yes; export glib_cv_va_copy
glib_cv___va_copy=yes; export glib_cv___va_copy
glib_cv_va_val_copy=yes; export glib_cv_va_val_copy
glib_cv_sizeof_gmutex=24; export glib_cv_sizeof_gmutex
glib_cv_byte_contents_gmutex="0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0"; export glib_cv_byte_contents_gmutex
%endif
%endif
%configure
make

%install
rm -rf $RPM_BUILD_ROOT
%makeinstall
mkdir -p $RPM_BUILD_ROOT%{_libdir}/pkgconfig
%{__strip} $RPM_BUILD_ROOT%{_bindir}/*

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%{_mandir}/*/*
%{_bindir}/*
%{_libdir}/pkgconfig
%{_datadir}/aclocal/*

%changelog
* Wed Jun 23 2004 Matthias Clasen <mclasen@redhat.com> 1:0.15.0-3
- fix underquoted definition in pkg.m4  (#116128)

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Tue Feb 24 2004 Mark McLoughlin <markmc@redhat.com>
- Update to 0.15.0
- Fix datadir patch conflict

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Oct 23 2003 Owen Taylor <otaylor@redhat.com> 1:0.14.0-6
- Make pkgconfig look in /usr/share/pkgconfig as well by default (#98595)

* Thu Jun 26 2003 Havoc Pennington <hp@redhat.com> 1:0.14.0-5
- rebuild

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Mon Feb 10 2003 Nalin Dahyabhai <nalin@redhat.com>
- suppress /usr/lib64 (instead of /usr/lib) from LIBS by default on multilib
  arches where the default is to use lib64

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Fri Nov  8 2002 Havoc Pennington <hp@redhat.com>
- 0.14

* Tue Oct  8 2002 Havoc Pennington <hp@redhat.com>
- use libdir, so we do move .pc files to /usr/lib64

* Tue Oct  8 2002 Havoc Pennington <hp@redhat.com>
- use prefix/lib not libdir, so we don't move .pc files to /usr/lib64

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu Mar  7 2002 Havoc Pennington <hp@redhat.com>
- 0.12.0

* Thu Feb  7 2002 Havoc Pennington <hp@redhat.com>
- 0.11.0

* Sun Feb  3 2002 Havoc Pennington <hp@redhat.com>
- backbuild in gnomehide

* Sun Feb  3 2002 Havoc Pennington <hp@redhat.com>
- 0.10.0

* Sun Feb  3 2002 Havoc Pennington <hp@redhat.com>
- 0.9.0

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jun 13 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- call libtoolize to make porting to new archs easier

* Thu Jun 07 2001 Havoc Pennington <hp@redhat.com>
- put pkg.m4 in file list

* Wed Jun 06 2001 Havoc Pennington <hp@redhat.com>
- Upgrade to 0.7
- add man page

* Wed Jan 03 2001 Havoc Pennington <hp@redhat.com>
- Upgrade to 0.5

* Thu Dec 14 2000 Bill Nottingham <notting@redhat.com>
- rebuild because of broken fileutils

* Wed Oct 04 2000 Owen Taylor <otaylor@redhat.com>
- Initial package
