Summary: The basic directory layout for a Linux system.
Name: filesystem
Version: 2.3.0
Release: 1.gnupro.1
License: Public Domain
Group: System Environment/Base
Buildroot: %{_tmppath}/%{name}-%{version}-root
Prereq: setup >= 2.5.4-1

%description
The filesystem package is one of the basic packages that is installed
on a Red Hat Linux system. Filesystem contains the basic directory
layout for a Linux operating system, including the correct permissions
for the directories.

%prep

%install
rm -rf %{buildroot}
mkdir %{buildroot}

cd %{buildroot}

mkdir -p mnt/{floppy,cdrom} \
	bin boot \
	etc/{X11/{applnk,sysconfig,serverconfig,starthere},opt,xinetd.d,skel,sysconfig} \
	home initrd lib/modules %{_lib}/tls media mnt opt proc root sbin selinux srv sys tmp \
	usr/{bin,etc,games,include,%{_lib}/{games,gcc-lib,tls},lib/{games,gcc-lib,locale},libexec,local/{bin,etc,games,lib,%{_lib},sbin,src,share/{man/man{1,2,3,4,5,6,7,8,9,n},info},libexec,include,},sbin,share/{applications,doc,dict,info,man/man{1,2,3,4,5,6,7,8,9,n},doc,misc,empty,pixmaps,xsessions},src,X11R6/{bin,include,lib,%{_lib}/tls,man,share}} \
        var/{empty,lib/{games,misc},local,lock/subsys,log,nis,preserve,run,spool/{mail,lpd},tmp,db,cache,opt,games,yp}

ln -snf  ../X11R6/bin usr/bin/X11
ln -snf  ../X11R6/lib/X11 usr/lib/X11
ln -snf ../X11R6/%{_lib}/X11 usr/%{_lib}/X11
ln -snf ../var/tmp usr/tmp
ln -snf spool/mail var/mail

%clean
rm -rf %{buildroot}

%files
%defattr(0755,root,root)
/bin
/boot
/etc
/home
/initrd
/lib
%ifarch x86_64 ppc ppc64 sparc sparc64 s390 s390x
/%{_lib}
%endif
/media
%dir /mnt
%ghost %config(missingok) %verify(not size md5 mode user link rdev group mtime) /mnt/cdrom
%ghost %config(missingok) %verify(not size md5 mode user link rdev group mtime) /mnt/floppy
%dir /opt
%attr(555,root,root) /proc
%attr(750,root,root) /root
/sbin
/selinux
/srv
/sys
%attr(1777,root,root) /tmp
%dir /usr
/usr/[^s]*
/usr/sbin
%dir /usr/share
/usr/share/applications
/usr/share/doc
/usr/share/dict
%attr(555,root,root) %dir /usr/share/empty
/usr/share/info
/usr/share/man
/usr/share/misc
/usr/share/pixmaps
/usr/share/xsessions
/usr/src
%dir /var
/var/db
/var/lib
/var/local
%dir %attr(0775,root,lock) /var/lock
%attr(755,root,root) /var/lock/subsys
/var/cache
/var/empty
/var/log
/var/mail
/var/nis
/var/opt
/var/preserve
/var/run
%dir /var/spool
%attr(755,root,root) /var/spool/lpd
%attr(775,root,mail) /var/spool/mail
%attr(1777,root,root) /var/tmp
/var/yp

%changelog
* Thu Aug 12 2004 Bill Nottingham <notting@redhat.com> 2.3.0-1
- add /media, /srv

* Tue Jun 15 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Mar 11 2004 Bill Nottingham <notting@redhat.com> 2.2.4-1
- move /selinux here from SysVinit

* Tue Mar 02 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Fri Feb 13 2004 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Thu Jan 15 2004 Bill Nottingham <notting@redhat.com> 2.2.3-1
- move /usr/dict to /usr/share/dict (#113645)
- add /usr/lib/locale, /var/empty (#108686,#113036)
- add */%%{_lib}/tls (#113050)

* Fri Nov 21 2003 Bill Nottingham <notting@redhat.com> 2.2.2-1
- add /sys

* Tue Oct 07 2003 Than Ngo <than@redhat.com> 2.2.1-5
- add /usr/share/xsessions

* Wed Jun 04 2003 Elliot Lee <sopwith@redhat.com>
- rebuilt

* Wed Jan 22 2003 Tim Powers <timp@redhat.com>
- rebuilt

* Sun Dec  1 2002 Tim Waugh <twaugh@redhat.com> 2.2.1-2
- Really fix /var/mail

* Thu Nov 28 2002 Bill Nottingham <notting@redhat.com> 2.2.1-1
- fix /var/mail

* Wed Nov 20 2002 Bill Nottingham <notting@redhat.com>
- make arch specific, handle lib/lib64 stuff
- add /usr/libexec, /usr/share/applications

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Thu May 23 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Wed Jan 09 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Aug 20 2001 Bill Nottingham <notting@redhat.com>
- %%ghost /mnt/cdrom, /mnt/floppy (fixes #52046)

* Wed Aug 15 2001 Bill Nottingham <notting@redhat.com>
- add /usr/X11R6/share (#51830)

* Mon Aug 13 2001 Bill Nottingham <notting@redhat.com>
- prereq a particular version of the setup package

* Thu Aug  9 2001 Bill Nottingham <notting@redhat.com>
- remove /mnt/cdrom, /mnt/floppy (updfstab will create them if needed)
- make it noarch again

* Wed Aug  8 2001 Bill Nottingham <notting@redhat.com>
- /var/lock needs to be root.lock, not lock.lock

* Mon Aug  6 2001 Jeff Johnson <jbj@redhat.com>
- lock.lock ownership, 0775 permissions, for /var/lock.

* Tue Jul 17 2001 Bill Nottingham <notting@redhat.com>
- add /etc/sysconfig, /var/yp, /usr/share/pixmaps

* Tue Jul 10 2001 Bill Nottingham <notting@redhat.com>
- add stuff under /etc/X11
- remove extraneous /usr/X11R6/doc (#47490)

* Mon Jun 25 2001 Bill Nottingham <notting@redhat.com>
- don't conflict with rpm

* Fri Jun 22 2001 Bill Nottingham <notting@redhat.com>
- don't own /var/lib/rpm (#43315)
- add some stuff in /usr/local (#36522)

* Thu Jun 21 2001 Bill Nottingham <notting@redhat.com>
- add /initrd

* Thu Jun 07 2001 Florian La Roche <Florian.LaRoche@redhat.de>
- remove noarch
- do not include /mnt/cdrom and /mnt/floppy for s390/s390x

* Mon Apr 16 2001 Bill Nottingham <notting@redhat.com>
- take the group write off of /var/lock

* Fri Jul 21 2000 Bill Nottingham <notting@redhat.com>
- add /usr/share/empty

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Wed Jun 28 2000 Preston Brown <pbrown@redhat.com>
- remove /usr/doc

* Thu Jun 22 2000 Preston Brown <pbrown@redhat.com>
- remove /usr/info

* Sun Jun 19 2000 Bill Nottingham <notting@redhat.com>
- remove /usr/man

* Sat Jun 17 2000 Bill Nottingham <notting@redhat.com>
- /var/spool/lpd should have normal perms (#12272)

* Tue Jun  6 2000 Bill Nottingham <notting@redhat.com>
- add /etc/skel

* Thu Jun 01 2000 Preston Brown <pbrown@redhat.com>
- add /var/spool/lpd to filesystem, owned by user/group lp, tight permissions

* Tue May 23 2000 Trond Eivind Glomsrd <teg@redhat.com>
- Added /etc/xinetd.d

* Mon May 15 2000 Preston Brown <pbrown@redhat.com>
- /etc/opt, /usr/share/{info,man/man*,misc,doc} (FHS 2.1)
- added /var/games.  Data should move from /var/lib/games to there (FHS 2.1)
- bump version up to 2.0 already!

* Thu Apr 13 2000 Jakub Jelinek <jakub@redhat.com>
- removed /var/state, added /var/opt, /var/mail for FHS 2.1 compliance

* Mon Aug 28 1999 Preston Brown <pbrown@redhat.com>
- added /opt, /var/state, /var/cache for FHS compliance (#3966)

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 4)

* Sun Jan 17 1999 Jeff Johnson <jbj@redhat.com>
- don't carry X11R6.1 as directory on sparc.
- /var/tmp/build root (#811)

* Wed Jan 13 1999 Preston Brown <pbrown@redhat.com>
- font directory didn't belong, which I previously misunderstood.  removed.

* Fri Nov 13 1998 Preston Brown <pbrown@redhat.com>
- /usr/share/fonts/default added.

* Fri Oct  9 1998 Bill Nottingham <notting@redhat.com>
- put /mnt/cdrom back in

* Wed Oct  7 1998 Bill Nottingham <notting@redhat.com>
- Changed /root to 0750

* Wed Aug 05 1998 Erik Troan <ewt@redhat.com>
- added /var/db
- set attributes in the spec file; don't depend on the ones in the cpio
  archive
- use a tarball instead of a cpioball

* Mon Apr 27 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Tue Sep 09 1997 Erik Troan <ewt@redhat.com>
- made a noarch package

* Wed Jul 09 1997 Erik Troan <ewt@redhat.com>
- added /

* Wed Apr 16 1997 Erik Troan <ewt@redhat.com>
- Changed /proc to 555
- Removed /var/spool/mqueue (which is owned by sendmail)
