// AUTOGENERATED FROM index-iso-8859-2.txt, ORIGINAL COMMENT FOLLOWS:
//
// Any copyright is dedicated to the Public Domain.
// https://creativecommons.org/publicdomain/zero/1.0/
//
// For details on index index-iso-8859-2.txt see the Encoding Standard
// https://encoding.spec.whatwg.org/
//
// Identifier: 9569c67f22d0b57790e1c407c6eecf227e4562322dc296de43cdab7a0152ec73
// Date: 2016-01-20

#[allow(dead_code)] const X: u16 = 0xffff;

const FORWARD_TABLE: &'static [u16] = &[
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
    143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157,
    158, 159, 160, 260, 728, 321, 164, 317, 346, 167, 168, 352, 350, 356, 377,
    173, 381, 379, 176, 261, 731, 322, 180, 318, 347, 711, 184, 353, 351, 357,
    378, 733, 382, 380, 340, 193, 194, 258, 196, 313, 262, 199, 268, 201, 280,
    203, 282, 205, 206, 270, 272, 323, 327, 211, 212, 336, 214, 215, 344, 366,
    218, 368, 220, 221, 354, 223, 341, 225, 226, 259, 228, 314, 263, 231, 269,
    233, 281, 235, 283, 237, 238, 271, 273, 324, 328, 243, 244, 337, 246, 247,
    345, 367, 250, 369, 252, 253, 355, 729,
]; // 128 entries

/// Returns the index code point for pointer `code` in this index.
#[inline]
pub fn forward(code: u8) -> u16 {
    FORWARD_TABLE[(code - 0x80) as usize]
}

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_LOWER: &'static [u8] = &[
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 251, 0, 0, 0, 0, 0, 0,
    0, 172, 188, 175, 191, 174, 190, 0, 144, 145, 146, 147, 148, 149, 150, 151,
    152, 153, 154, 155, 156, 157, 158, 159, 176, 0, 0, 0, 180, 0, 0, 0, 184, 0,
    0, 0, 0, 0, 0, 0, 0, 162, 255, 0, 178, 0, 189, 0, 0, 193, 194, 0, 196, 0,
    0, 199, 0, 201, 0, 203, 0, 205, 206, 0, 225, 226, 0, 228, 0, 0, 231, 0,
    233, 0, 235, 0, 237, 238, 0, 163, 179, 209, 241, 0, 0, 210, 242, 0, 0, 0,
    0, 0, 0, 0, 183, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 229, 0, 0, 165, 181, 0,
    128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142,
    143, 160, 0, 0, 0, 164, 0, 0, 167, 168, 0, 0, 0, 0, 173, 0, 0, 0, 243, 244,
    0, 246, 247, 0, 0, 250, 0, 252, 253, 0, 0, 195, 227, 161, 177, 198, 230, 0,
    0, 0, 0, 200, 232, 207, 239, 208, 240, 0, 0, 0, 0, 0, 0, 202, 234, 204,
    236, 0, 0, 0, 0, 211, 212, 0, 214, 215, 0, 0, 218, 0, 220, 221, 0, 223,
    213, 245, 0, 0, 192, 224, 0, 0, 216, 248, 166, 182, 0, 0, 170, 186, 169,
    185, 222, 254, 171, 187, 0, 0, 0, 0, 0, 0, 0, 0, 217, 249,
]; // 256 entries

#[cfg(not(feature = "no-optimized-legacy-encoding"))]
const BACKWARD_TABLE_UPPER: &'static [u16] = &[
    0, 0, 0, 0, 0, 0, 0, 0, 135, 32, 151, 48, 72, 208, 87, 165, 179, 195, 0,
    119, 102, 224, 240, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 111, 57,
]; // 46 entries

/// Returns the index pointer for code point `code` in this index.
#[inline]
#[cfg(not(feature = "no-optimized-legacy-encoding"))]
pub fn backward(code: u32) -> u8 {
    let offset = (code >> 4) as usize;
    let offset = if offset < 46 {BACKWARD_TABLE_UPPER[offset] as usize} else {0};
    BACKWARD_TABLE_LOWER[offset + ((code & 15) as usize)]
}

/// Returns the index pointer for code point `code` in this index.
#[cfg(feature = "no-optimized-legacy-encoding")]
pub fn backward(code: u32) -> u8 {
    if code > 733 || ((0x400ff0u32 >> (code >> 5)) & 1) == 0 { return 0; }
    let code = code as u16;
    for i in 0..0x80 {
        if FORWARD_TABLE[i as usize] == code { return 0x80 + i; }
    }
    0
}

#[cfg(test)]
single_byte_tests! {
}
