# 2022-12-13 Triage Log

Fairly quiet week with the only excitement coming from a nice improvement implemented by @nnethercote which fixed a pesky performance regression in the linting system. This produced a 0.6% performance improvement across a large number of the real world crates we test against. 

Triage done by **@rylev**.
Revision range: [9db224fc..109cccbe](https://perf.rust-lang.org/?start=9db224fc908059986c179fc6ec433944e9cfce50&end=109cccbe4f345c0f0785ce860788580c3e2a29f5&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.2%  | [0.2%, 0.2%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 1.7%  | [0.3%, 3.3%]   | 11    |
| Improvements ✅ <br /> (primary)   | -0.8% | [-2.2%, -0.2%] | 129   |
| Improvements ✅ <br /> (secondary) | -1.2% | [-4.4%, -0.1%] | 97    |
| All ❌✅ (primary)                 | -0.7% | [-2.2%, 0.2%]  | 132   |


2 Regressions, 2 Improvements, 4 Mixed; 3 of them in rollups
41 artifact comparisons made in total

#### Regressions

Rollup of 9 pull requests [#105378](https://github.com/rust-lang/rust/pull/105378) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e60fbaf4ce768d13a6abc048bd34ee12995d18dc&end=b28d30e1e3c2b90fd08b7dd79d8e63884d1e0339&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.2%, 4.4%]   | 12    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.8% | [-0.8%, -0.8%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |
- Suspicion is that [#105250](https://github.com/rust-lang/rust/pull/105250) is the cause. Running a regression test to confirm.
- This is small enough that it's not worth stressing about.


Fast-path some binder relations [#105350](https://github.com/rust-lang/rust/pull/105350) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=71ec1457ee9868a838e4521a3510cdd416c0c295&end=109cccbe4f345c0f0785ce860788580c3e2a29f5&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.1% | [1.0%, 1.2%] | 2     |
| Regressions ❌ <br /> (secondary)  | 2.3% | [2.0%, 2.7%] | 6     |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.1% | [1.0%, 1.2%] | 2     |
- This is noise. The regression cancel out the improvements in the exact same test cases from the previous commit which is a very strong indicator that this is noise.


#### Improvements

Fix lint perf regressions [#105485](https://github.com/rust-lang/rust/pull/105485) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=ee6533d7408f1447c028025c883a34c904d25ba4&end=b397bc0727ad27340466166455c6edd327a589c4&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.6% | [-1.5%, -0.2%] | 138   |
| Improvements ✅ <br /> (secondary) | -0.8% | [-2.5%, -0.2%] | 93    |
| All ❌✅ (primary)                 | -0.6% | [-1.5%, -0.2%] | 138   |


Inline and remove `place_contents_drop_state_cannot_differ`. [#105436](https://github.com/rust-lang/rust/pull/105436) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b96d9e0e20adb7716aa32a56fe96fde15c75d517&end=71ec1457ee9868a838e4521a3510cdd416c0c295&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.2%, -0.4%] | 3     |
| Improvements ✅ <br /> (secondary) | -2.2% | [-2.6%, -2.0%] | 6     |
| All ❌✅ (primary)                 | -0.8% | [-1.2%, -0.4%] | 3     |
- These are noise and went away in the next commit


#### Mixed

Rollup of 10 pull requests [#105486](https://github.com/rust-lang/rust/pull/105486) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=badd6a5a03e87920259e1510e710526b51faadbe&end=14ca83a04b00433a8caf3b805d5ea08cb2691e1b&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -3.9% | [-4.0%, -3.8%] | 2     |
| All ❌✅ (primary)                 | 0.4%  | [0.4%, 0.4%]   | 1     |
- A single tiny regression on a doc profiler, not worth worrying about. ([commented here](https://github.com/rust-lang/rust/pull/105486#issuecomment-1344956405))


Rollup of 9 pull requests [#105512](https://github.com/rust-lang/rust/pull/105512) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=0d5573e6daf99a5b98ace3dfcc4be2eb64867169&end=a000811405e6a3ca9b0b129c1177e78564e09666&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.1%  | [1.1%, 1.1%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.2%, -0.2%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.6%, -0.2%] | 6     |
| All ❌✅ (primary)                 | -0.2% | [-0.2%, -0.2%] | 1     |
- The regressions is small in absolute terms, only in instructions count, it's a short stress test that doesn't seem to be the only one to exercise some codepath changed in this PR. Nothing jumps out in the rolled up PRs nor seems to apply to the other benchmarks. There are also small wins elsewhere, so this seems fine. ([commented here](https://github.com/rust-lang/rust/pull/105512#issuecomment-1345337596))


Group some fields in a common struct so we only pass one reference instead of three [#105357](https://github.com/rust-lang/rust/pull/105357) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=a000811405e6a3ca9b0b129c1177e78564e09666&end=cbc70ff277dda8b7f227208eff789f1f68b6de5a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.7%]   | 23    |
| Regressions ❌ <br /> (secondary)  | 0.4%  | [0.1%, 0.7%]   | 22    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.2%] | 33    |
| Improvements ✅ <br /> (secondary) | -0.9% | [-1.4%, -0.2%] | 18    |
| All ❌✅ (primary)                 | -0.1% | [-0.8%, 0.7%]  | 56    |
- Wins appear to roughly equal or slightly outweigh the losses here. ([commented here](https://github.com/rust-lang/rust/pull/105357#issuecomment-1345499340))


Remove `token::Lit` from `ast::MetaItemLit`. [#105160](https://github.com/rust-lang/rust/pull/105160) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b397bc0727ad27340466166455c6edd327a589c4&end=2cd2070af7643ad88d280a4933bc4fb60451e521&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [1.0%, 1.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.9% | [-1.0%, -0.8%] | 5     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | -0.9% | [-1.0%, -0.8%] | 5     |
- There is a single trivial regression, which may or may not be real. ([commented here](https://github.com/rust-lang/rust/pull/105160#issuecomment-1346170852))


