# Summary

[About this guide](./about-this-guide.md)

---

- [Part 1: Building, debugging, and contributing to Rustc](./part-1-intro.md)
    - [About the compiler team](./compiler-team.md)
    - [How to Build and Run the Compiler](./building/how-to-build-and-run.md)
        - [Suggested Workflows](./building/suggested.md)
        - [Bootstrapping](./building/bootstrapping.md)
        - [Distribution artifacts](./building/build-install-distribution-artifacts.md)
        - [Documenting Compiler](./building/compiler-documenting.md)
        - [ctags](./building/ctags.md)
    - [The compiler testing framework](./tests/intro.md)
        - [Running tests](./tests/running.md)
        - [Adding new tests](./tests/adding.md)
        - [Using `compiletest` + commands to control test execution](./compiletest.md)
    - [Walkthrough: a typical contribution](./walkthrough.md)
    - [Bug Fix Procedure](./bug-fix-procedure.md)
    - [Implementing new features](./implementing_new_features.md)
    - [Stability attributes](./stability.md)
    - [Stabilizing Features](./stabilization_guide.md)
    - [Debugging the Compiler](./compiler-debugging.md)
    - [Profiling the compiler](./profiling.md)
        - [with the linux perf tool](./profiling/with_perf.md)
    - [Coding conventions](./conventions.md)
    - [crates.io Dependencies](./crates-io.md)
    - [Emitting Errors and other Diagnostics](diagnostics.md)
        - [`LintStore`](./diagnostics/lintstore.md)
        - [Diagnostic Codes](./diagnostics/diagnostic-codes.md)
    - [ICE-breaker teams](ice-breaker/about.md)
        - ["Cleanup Crew" ICE-breakers](ice-breaker/cleanup-crew.md)
        - [LLVM ICE-breakers](ice-breaker/llvm.md)
    - [Licenses](./licenses.md)

- [Part 2: High-level Compiler Architecture](./part-2-intro.md)
    - [Overview of the Compiler](./overview.md)
    - [The compiler source code](./compiler-src.md)
    - [Queries: demand-driven compilation](./query.md)
        - [The Query Evaluation Model in Detail](./queries/query-evaluation-model-in-detail.md)
        - [Incremental compilation](./queries/incremental-compilation.md)
        - [Incremental compilation In Detail](./queries/incremental-compilation-in-detail.md)
        - [Debugging and Testing](./incrcomp-debugging.md)
        - [Profiling Queries](./queries/profiling.md)
        - [Salsa](./salsa.md)
    - [Memory Management in Rustc](./memory.md)

- [Part 3: Source Code Representations](./part-3-intro.md)
    - [The Rustc Driver and Interface](./rustc-driver.md)
        - [Rustdoc](./rustdoc.md)
        - [Ex: Type checking through `rustc_interface`](./rustc-driver-interacting-with-the-ast.md)
    - [Syntax and the AST](./syntax-intro.md)
        - [Lexing and Parsing](./the-parser.md)
        - [`#[test]` Implementation](./test-implementation.md)
        - [Panic Implementation](./panic-implementation.md)
        - [Macro expansion](./macro-expansion.md)
        - [Name resolution](./name-resolution.md)
        - [AST Validation](./ast-validation.md)
        - [Feature Gate Checking](./feature-gate-ck.md)
    - [The HIR (High-level IR)](./hir.md)
        - [Lowering AST to HIR](./lowering.md)
        - [Debugging](./hir-debugging.md)
    - [The MIR (Mid-level IR)](./mir/index.md)
        - [HAIR and MIR construction](./mir/construction.md)
        - [MIR visitor and traversal](./mir/visitor.md)
        - [MIR passes: getting the MIR for a function](./mir/passes.md)
    - [Closure expansion](./closure.md)

- [Part 4: Analysis](./part-4-intro.md)
    - [The `ty` module: representing types](./ty.md)
        - [Generics and substitutions](./generics.md)
        - [`TypeFolder` and `TypeFoldable`](./ty-fold.md)
        - [Generic arguments](./generic_arguments.md)
    - [Type inference](./type-inference.md)
    - [Trait solving (old-style)](./traits/resolution.md)
        - [Higher-ranked trait bounds](./traits/hrtb.md)
        - [Caching subtleties](./traits/caching.md)
        - [Specialization](./traits/specialization.md)
    - [Trait solving (new-style)](./traits/index.md)
        - [Lowering to logic](./traits/lowering-to-logic.md)
            - [Goals and clauses](./traits/goals-and-clauses.md)
            - [Equality and associated types](./traits/associated-types.md)
            - [Implied bounds](./traits/implied-bounds.md)
            - [Region constraints](./traits/regions.md)
            - [The lowering module in rustc](./traits/lowering-module.md)
            - [Lowering rules](./traits/lowering-rules.md)
            - [Well-formedness checking](./traits/wf.md)
        - [Canonical queries](./traits/canonical-queries.md)
            - [Canonicalization](./traits/canonicalization.md)
        - [The SLG solver](./traits/slg.md)
        - [An Overview of Chalk](./traits/chalk-overview.md)
        - [Bibliography](./traits/bibliography.md)
    - [Type checking](./type-checking.md)
        - [Method Lookup](./method-lookup.md)
        - [Variance](./variance.md)
        - [Opaque Types](./opaque-types-type-alias-impl-trait.md)
    - [Pattern and Exhaustiveness Checking](./pat-exhaustive-checking.md)
    - [The borrow checker](./borrow_check.md)
        - [Tracking moves and initialization](./borrow_check/moves_and_initialization.md)
            - [Move paths](./borrow_check/moves_and_initialization/move_paths.md)
        - [MIR type checker](./borrow_check/type_check.md)
        - [Region inference](./borrow_check/region_inference.md)
            - [Constraint propagation](./borrow_check/region_inference/constraint_propagation.md)
            - [Lifetime parameters](./borrow_check/region_inference/lifetime_parameters.md)
            - [Member constraints](./borrow_check/region_inference/member_constraints.md)
            - [Placeholders and universes][pau]
            - [Closure constraints](./borrow_check/region_inference/closure_constraints.md)
            - [Error reporting](./borrow_check/region_inference/error_reporting.md)
        - [Two-phase-borrows](./borrow_check/two_phase_borrows.md)
    - [Parameter Environments](./param_env.md)

- [Part 5: From MIR to binaries](./part-5-intro.md)
    - [The MIR (Mid-level IR)](./mir/index.md)
        - [MIR optimizations](./mir/optimizations.md)
        - [Debugging](./mir/debugging.md)
    - [Constant evaluation](./const-eval.md)
        - [miri const evaluator](./miri.md)
    - [Monomorphization](./backend/monomorph.md)
    - [Lowering MIR](./backend/lowering-mir.md)
    - [Code Generation](./backend/codegen.md)
        - [Updating LLVM](./backend/updating-llvm.md)
        - [Debugging LLVM](./backend/debugging.md)
        - [Backend Agnostic Codegen](./backend/backend-agnostic.md)
        - [Implicit Caller Location](./codegen/implicit-caller-location.md)
    - [Profile-guided Optimization](./profile-guided-optimization.md)
    - [Sanitizers Support](./sanitizers.md)
    - [Debugging Support in Rust Compiler](./debugging-support-in-rustc.md)

---

[Appendix A: Background material](./appendix/background.md)
[Appendix B: Glossary](./appendix/glossary.md)
[Appendix C: Code Index](./appendix/code-index.md)
[Appendix D: Compiler Lecture Series](./appendix/compiler-lecture.md)
[Appendix E: Bibliography](./appendix/bibliography.md)

[Appendix Z: HumorRust](./appendix/humorust.md)

---

[pau]: ./borrow_check/region_inference/placeholders_and_universes.md
