% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unwrap.R
\name{unwrap}
\alias{unwrap}
\alias{flatten}
\title{Unwrap Nested Data Frames}
\usage{
unwrap(x, cols = NULL, sep = NULL)

flatten(x, cols = NULL, sep = NULL)
}
\arguments{
\item{x}{[\code{\link{data.frame}} | \code{\link[data.table]{data.table}}]\cr
Data frame to flatten.}

\item{cols}{[\code{character}]\cr
Columns to consider for this operation. If set to \code{NULL} (default),
will operate on all columns of type \dQuote{list}.}

\item{sep}{[\code{character(1)}]\cr
If \code{NULL} (default), the column names of the additional columns will re-use the names
of the nested \code{list}/\code{data.frame}.
This may lead to name clashes.
If you provide \code{sep}, the variable column name will be constructed as
\dQuote{[column name of x][sep][inner name]}.}
}
\value{
[\code{\link{data.table}}].
}
\description{
Some functions (e.g., \code{\link{getJobPars}}, \code{\link{getJobResources}} or \code{\link{reduceResultsDataTable}}
return a \code{data.table} with columns of type \code{list}.
These columns can be unnested/unwrapped with this function.
The contents of these columns  will be transformed to a \code{data.table} and \code{\link[base]{cbind}}-ed
to the input data.frame \code{x}, replacing the original nested column.
}
\note{
There is a name clash with function \code{flatten} in package \pkg{purrr}.
The function \code{flatten} is discouraged to use for this reason in favor of \code{unwrap}.
}
\examples{
x = data.table::data.table(
  id = 1:3,
  values = list(list(a = 1, b = 3), list(a = 2, b = 2), list(a = 3))
)
unwrap(x)
unwrap(x, sep = ".")
}
