import sys
from typing import Optional, List, Any

if sys.version_info < (3, 8):
    from typing_extensions import Literal
else:
    from typing import Literal

from pysam.libchtslib import HTSFile

_ParseResult = Any

class Parser:
    def __init__(self, encoding: str = ...) -> None: ...
    def get_encoding(self) -> str: ...
    def set_encoding(self, encoding: str) -> None: ...
    def __call__(self, buffer: str, length: int) -> _ParseResult: ...

class asTuple(Parser): ...
class asGFF3(Parser): ...
class asGTF(Parser): ...
class asBed(Parser): ...
class asVCF(Parser): ...

class TabixFile(HTSFile):
    filename_index: bytes = ...
    @property
    def header(self) -> List[str]: ...
    @property
    def contigs(self) -> List[str]: ...
    def __init__(
        self,
        filename: str,
        mode: str = ...,
        parser: Parser = ...,
        index: Optional[str] = ...,
        encoding: str = ...,
        threads: int = ...,
        *args,
        **kwargs
    ) -> None: ...
    def fetch(
        self,
        reference: Optional[str] = ...,
        start: Optional[int] = ...,
        end: Optional[int] = ...,
        region: Optional[str] = ...,
        parser: Optional[Parser] = ...,
        multiple_iterators: bool = ...,
    ) -> Any: ...
    def close(self) -> None: ...

class TabixIterator:
    def __init__(self, encoding: str = ...) -> None: ...
    def __iter__(self) -> TabixIterator: ...
    def __next__(self) -> str: ...

class EmptyIterator:
    def __iter__(self) -> Any: ...
    def __next__(self) -> Any: ...

class TabixIteratorParsed(TabixIterator):
    def __init__(self, parser: Parser) -> None: ...
    def __next__(self) -> Any: ...

class GZIterator:
    def __init__(
        self, filename: str, bufer_size: int = ..., encoding: str = ...
    ) -> None: ...
    def __iter__(self) -> GZIterator: ...
    def __next__(self) -> str: ...

class GZIteratorHead(GZIterator): ...

class GZIteratorParsed(GZIterator):
    def __init__(self, parser: Parser) -> None: ...
    def __next__(self) -> _ParseResult: ...

def tabix_compress(filename_in: str, filename_out: str, force: bool = ...) -> None: ...
def tabix_index(
    filename: str,
    force: bool = ...,
    seq_col: Optional[int] = ...,
    start_col: Optional[int] = ...,
    end_col: Optional[int] = ...,
    preset: Optional[Literal["gff", "bed", "sam", "vcf", "psltbl", "pileup"]] = ...,
    meta_char: str = ...,
    line_skip: int = ...,
    zerobased: bool = ...,
    min_shift: int = ...,
    index: Optional[str] = ...,
    keep_original: bool = ...,
    csi: bool = ...,
) -> str: ...

class tabix_file_iterator:
    def __init__(self, infile: str, parser: Parser, buffer_size: int = ...) -> None: ...
    def __iter__(self) -> tabix_file_iterator: ...
    def __next__(self) -> _ParseResult: ...

class tabix_generic_iterator:
    def __init__(self, infile: str, parser: Parser) -> None: ...
    def __iter__(self) -> tabix_generic_iterator: ...
    def __next__(self) -> _ParseResult: ...

def tabix_iterator(infile: str, parser: Optional[Parser]) -> _ParseResult: ...

# backwards compatibility
class Tabixfile(TabixFile): ...
