---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet script'
canonical: "/puppet/latest/man/script.html"
---

# Man Page: puppet script

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-script** - Run a puppet manifests as a script without compiling
a catalog

## SYNOPSIS
Runs a puppet language script without compiling a catalog.

## USAGE
puppet script \[-h\|\--help\] \[-V\|\--version\] \[-d\|\--debug\]
\[-v\|\--verbose\] \[-e\|\--execute\] \[-l\|\--logdest
syslog\|eventlog\|*FILE*\|console\] \[\--noop\] *file*

## DESCRIPTION
This is a standalone puppet script runner tool; use it to run puppet
code without compiling a catalog.

When provided with a modulepath, via command line or config file, puppet
script can load functions, types, tasks and plans from modules.

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument. For example, \'environment\' is a valid setting, so
you can specify \'\--environment mytest\' as an argument.

See the configuration file documentation at
https://puppet.com/docs/puppet/latest/configuration.html for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with \'\--genconfig\'.

\--debug

:   Enable full debugging.

\--help

:   Print this help message

\--logdest

:   Where to send log messages. Choose between \'syslog\' (the POSIX
    syslog service), \'eventlog\' (the Windows Event Log), \'console\',
    or the path to a log file. Defaults to \'console\'. Multiple
    destinations can be set using a comma separated list (eg:
    **/path/file1,console,/path/file2**)\"

    A path ending with \'.json\' will receive structured output in JSON
    format. The log file will not have an ending \'\]\' automatically
    written to it due to the appending nature of logging. It must be
    appended manually to make the content valid JSON.

    A path ending with \'.jsonl\' will receive structured output in JSON
    Lines format.

\--noop

:   Use \'noop\' mode where Puppet runs in a no-op or dry-run mode. This
    is useful for seeing what changes Puppet will make without actually
    executing the changes. Applies to tasks only.

\--execute

:   Execute a specific piece of Puppet code

\--verbose

:   Print extra information.

## EXAMPLE

    $ puppet script -l /tmp/manifest.log manifest.pp
    $ puppet script --modulepath=/root/dev/modules -e 'notice("hello world")'

## AUTHOR
Henrik Lindberg

## COPYRIGHT
Copyright (c) 2017 Puppet Inc., LLC Licensed under the Apache 2.0
License
