/* ChannelListWriter.c generated by valac 0.34.4, the Vala compiler
 * generated from ChannelListWriter.vala, do not modify */

/*
 * Copyright (C) 2008-2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gst/mpegts/mpegts.h>
#include <gee.h>
#include <float.h>
#include <math.h>


#define DVB_IO_TYPE_CHANNEL_LIST_WRITER (dvb_io_channel_list_writer_get_type ())
#define DVB_IO_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter))
#define DVB_IO_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))
#define DVB_IO_IS_CHANNEL_LIST_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_IS_CHANNEL_LIST_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_CHANNEL_LIST_WRITER))
#define DVB_IO_CHANNEL_LIST_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterClass))

typedef struct _DVBioChannelListWriter DVBioChannelListWriter;
typedef struct _DVBioChannelListWriterClass DVBioChannelListWriterClass;
typedef struct _DVBioChannelListWriterPrivate DVBioChannelListWriterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;

#define DVB_TYPE_PARAMETER (dvb_parameter_get_type ())
#define DVB_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_PARAMETER, DVBParameter))
#define DVB_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_PARAMETER, DVBParameterClass))
#define DVB_IS_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_PARAMETER))
#define DVB_IS_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_PARAMETER))
#define DVB_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_PARAMETER, DVBParameterClass))

typedef struct _DVBParameter DVBParameter;
typedef struct _DVBParameterClass DVBParameterClass;

#define DVB_TYPE_DVB_SRC_DELSYS (dvb_dvb_src_delsys_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_DVB_TPARAMETER (dvb_dvb_tparameter_get_type ())
#define DVB_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter))
#define DVB_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))
#define DVB_IS_DVB_TPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_TPARAMETER))
#define DVB_IS_DVB_TPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_TPARAMETER))
#define DVB_DVB_TPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameterClass))

typedef struct _DVBDvbTParameter DVBDvbTParameter;
typedef struct _DVBDvbTParameterClass DVBDvbTParameterClass;

#define DVB_TYPE_DVB_SPARAMETER (dvb_dvb_sparameter_get_type ())
#define DVB_DVB_SPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameter))
#define DVB_DVB_SPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameterClass))
#define DVB_IS_DVB_SPARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_SPARAMETER))
#define DVB_IS_DVB_SPARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_SPARAMETER))
#define DVB_DVB_SPARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameterClass))

typedef struct _DVBDvbSParameter DVBDvbSParameter;
typedef struct _DVBDvbSParameterClass DVBDvbSParameterClass;

#define DVB_TYPE_DVB_CEUROPE_PARAMETER (dvb_dvb_ceurope_parameter_get_type ())
#define DVB_DVB_CEUROPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameter))
#define DVB_DVB_CEUROPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameterClass))
#define DVB_IS_DVB_CEUROPE_PARAMETER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER))
#define DVB_IS_DVB_CEUROPE_PARAMETER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DVB_CEUROPE_PARAMETER))
#define DVB_DVB_CEUROPE_PARAMETER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameterClass))

typedef struct _DVBDvbCEuropeParameter DVBDvbCEuropeParameter;
typedef struct _DVBDvbCEuropeParameterClass DVBDvbCEuropeParameterClass;

struct _DVBioChannelListWriter {
	GObject parent_instance;
	DVBioChannelListWriterPrivate * priv;
};

struct _DVBioChannelListWriterClass {
	GObjectClass parent_class;
};

struct _DVBioChannelListWriterPrivate {
	GFile* _file;
	GKeyFile* keyfile;
	GOutputStream* stream;
};

typedef enum  {
	DVB_DVB_SRC_DELSYS_SYS_UNDEFINED,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_A,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_B,
	DVB_DVB_SRC_DELSYS_SYS_DVBT,
	DVB_DVB_SRC_DELSYS_SYS_DSS,
	DVB_DVB_SRC_DELSYS_SYS_DVBS,
	DVB_DVB_SRC_DELSYS_SYS_DVBS2,
	DVB_DVB_SRC_DELSYS_SYS_DVBH,
	DVB_DVB_SRC_DELSYS_SYS_ISDBT,
	DVB_DVB_SRC_DELSYS_SYS_ISDBS,
	DVB_DVB_SRC_DELSYS_SYS_ISDBC,
	DVB_DVB_SRC_DELSYS_SYS_ATSC,
	DVB_DVB_SRC_DELSYS_SYS_ATSCMH,
	DVB_DVB_SRC_DELSYS_SYS_DTMB,
	DVB_DVB_SRC_DELSYS_SYS_CMMB,
	DVB_DVB_SRC_DELSYS_SYS_DAB,
	DVB_DVB_SRC_DELSYS_SYS_DVBT2,
	DVB_DVB_SRC_DELSYS_SYS_TURBO,
	DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_C
} DVBDvbSrcDelsys;


static gpointer dvb_io_channel_list_writer_parent_class = NULL;

GType dvb_io_channel_list_writer_get_type (void) G_GNUC_CONST;
#define DVB_IO_CHANNEL_LIST_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriterPrivate))
enum  {
	DVB_IO_CHANNEL_LIST_WRITER_DUMMY_PROPERTY,
	DVB_IO_CHANNEL_LIST_WRITER_FILE
};
static void dvb_io_channel_list_writer_open (DVBioChannelListWriter* self, GError** error);
GFile* dvb_io_channel_list_writer_get_file (DVBioChannelListWriter* self);
DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file);
DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file);
GType dvb_channel_get_type (void) G_GNUC_CONST;
void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
GType dvb_parameter_get_type (void) G_GNUC_CONST;
DVBParameter* dvb_channel_get_Param (DVBChannel* self);
GType dvb_dvb_src_delsys_get_type (void) G_GNUC_CONST;
DVBDvbSrcDelsys dvb_parameter_get_Delsys (DVBParameter* self);
static void dvb_io_channel_list_writer_write_terrestrial_channel (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
static void dvb_io_channel_list_writer_write_cable_channel (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
static void dvb_io_channel_list_writer_write_satellite_channel (DVBioChannelListWriter* self, DVBChannel* channel, GError** error);
const gchar* dvb_channel_get_Name (DVBChannel* self);
guint dvb_channel_get_Sid (DVBChannel* self);
GstMpegtsDVBServiceType dvb_channel_get_ServiceType (DVBChannel* self);
guint dvb_channel_get_VideoPID (DVBChannel* self);
GeeList* dvb_channel_get_AudioPIDs (DVBChannel* self);
gboolean dvb_channel_get_Scrambled (DVBChannel* self);
const gchar* dvb_channel_get_Network (DVBChannel* self);
guint dvb_channel_get_TransportStreamId (DVBChannel* self);
gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error);
GType dvb_dvb_tparameter_get_type (void) G_GNUC_CONST;
guint dvb_parameter_get_Frequency (DVBParameter* self);
guint dvb_dvb_tparameter_get_Bandwidth (DVBDvbTParameter* self);
gchar* dvb_getModulationString (GstMpegtsModulationType val);
GstMpegtsModulationType dvb_dvb_tparameter_get_Constellation (DVBDvbTParameter* self);
gchar* dvb_getCodeRateString (GstMpegtsDVBCodeRate val);
GstMpegtsDVBCodeRate dvb_dvb_tparameter_get_CodeRateHP (DVBDvbTParameter* self);
GstMpegtsDVBCodeRate dvb_dvb_tparameter_get_CodeRateLP (DVBDvbTParameter* self);
gchar* dvb_getGuardIntervalString (GstMpegtsTerrestrialGuardInterval val);
GstMpegtsTerrestrialGuardInterval dvb_dvb_tparameter_get_GuardInterval (DVBDvbTParameter* self);
gchar* dvb_getTransmissionModeString (GstMpegtsTerrestrialTransmissionMode val);
GstMpegtsTerrestrialTransmissionMode dvb_dvb_tparameter_get_TransmissionMode (DVBDvbTParameter* self);
gchar* dvb_getHierarchyString (GstMpegtsTerrestrialHierarchy val);
GstMpegtsTerrestrialHierarchy dvb_dvb_tparameter_get_Hierarchy (DVBDvbTParameter* self);
GType dvb_dvb_sparameter_get_type (void) G_GNUC_CONST;
guint dvb_dvb_sparameter_get_SymbolRate (DVBDvbSParameter* self);
GstMpegtsDVBCodeRate dvb_dvb_sparameter_get_InnerFEC (DVBDvbSParameter* self);
gchar* dvb_getPolarizationString (GstMpegtsSatellitePolarizationType val);
GstMpegtsSatellitePolarizationType dvb_dvb_sparameter_get_Polarization (DVBDvbSParameter* self);
gfloat dvb_dvb_sparameter_get_OrbitalPosition (DVBDvbSParameter* self);
gint dvb_dvb_sparameter_get_DiseqcSource (DVBDvbSParameter* self);
GType dvb_dvb_ceurope_parameter_get_type (void) G_GNUC_CONST;
guint dvb_dvb_ceurope_parameter_get_SymbolRate (DVBDvbCEuropeParameter* self);
GstMpegtsDVBCodeRate dvb_dvb_ceurope_parameter_get_InnerFEC (DVBDvbCEuropeParameter* self);
GstMpegtsModulationType dvb_dvb_ceurope_parameter_get_Modulation (DVBDvbCEuropeParameter* self);
static void dvb_io_channel_list_writer_set_file (DVBioChannelListWriter* self, GFile* value);
static void dvb_io_channel_list_writer_finalize (GObject* obj);
static void _vala_dvb_io_channel_list_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_dvb_io_channel_list_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void dvb_io_channel_list_writer_open (DVBioChannelListWriter* self, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	GKeyFile* _tmp2_ = NULL;
	GFileOutputStream* fostream = NULL;
	GFile* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	GFileOutputStream* _tmp13_ = NULL;
	GBufferedOutputStream* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->keyfile;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp1_ = g_key_file_new ();
	_g_key_file_unref0 (self->priv->keyfile);
	self->priv->keyfile = _tmp1_;
	_tmp2_ = self->priv->keyfile;
	g_key_file_set_list_separator (_tmp2_, ' ');
	fostream = NULL;
	_tmp3_ = self->priv->_file;
	_tmp4_ = g_file_query_exists (_tmp3_, NULL);
	if (_tmp4_) {
		GFileOutputStream* _tmp5_ = NULL;
		GFile* _tmp6_ = NULL;
		GFileOutputStream* _tmp7_ = NULL;
		GFileOutputStream* _tmp8_ = NULL;
		_tmp6_ = self->priv->_file;
		_tmp7_ = g_file_replace (_tmp6_, NULL, TRUE, 0, NULL, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fostream);
			return;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (fostream);
		fostream = _tmp8_;
		_g_object_unref0 (_tmp5_);
	} else {
		GFileOutputStream* _tmp9_ = NULL;
		GFile* _tmp10_ = NULL;
		GFileOutputStream* _tmp11_ = NULL;
		GFileOutputStream* _tmp12_ = NULL;
		_tmp10_ = self->priv->_file;
		_tmp11_ = g_file_create (_tmp10_, 0, NULL, &_inner_error_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (fostream);
			return;
		}
		_tmp12_ = _tmp9_;
		_tmp9_ = NULL;
		_g_object_unref0 (fostream);
		fostream = _tmp12_;
		_g_object_unref0 (_tmp9_);
	}
	_tmp13_ = fostream;
	_tmp14_ = (GBufferedOutputStream*) g_buffered_output_stream_new ((GOutputStream*) _tmp13_);
	_g_object_unref0 (self->priv->stream);
	self->priv->stream = (GOutputStream*) _tmp14_;
	_g_object_unref0 (fostream);
}


DVBioChannelListWriter* dvb_io_channel_list_writer_construct (GType object_type, GFile* file) {
	DVBioChannelListWriter * self = NULL;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = file;
	self = (DVBioChannelListWriter*) g_object_new (object_type, "file", _tmp0_, NULL);
	return self;
}


DVBioChannelListWriter* dvb_io_channel_list_writer_new (GFile* file) {
	return dvb_io_channel_list_writer_construct (DVB_IO_TYPE_CHANNEL_LIST_WRITER, file);
}


void dvb_io_channel_list_writer_write (DVBioChannelListWriter* self, DVBChannel* channel, GError** error) {
	GKeyFile* _tmp0_ = NULL;
	GKeyFile* _tmp1_ = NULL;
	DVBChannel* _tmp2_ = NULL;
	DVBParameter* _tmp3_ = NULL;
	DVBParameter* _tmp4_ = NULL;
	DVBDvbSrcDelsys _tmp5_ = 0;
	DVBDvbSrcDelsys _tmp6_ = 0;
	GKeyFile* _tmp10_ = NULL;
	DVBChannel* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	DVBChannel* _tmp14_ = NULL;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	GKeyFile* _tmp17_ = NULL;
	DVBChannel* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	DVBChannel* _tmp21_ = NULL;
	GstMpegtsDVBServiceType _tmp22_ = 0;
	GstMpegtsDVBServiceType _tmp23_ = 0;
	DVBChannel* _tmp24_ = NULL;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	DVBChannel* _tmp34_ = NULL;
	GeeList* _tmp35_ = NULL;
	GeeList* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	GKeyFile* _tmp66_ = NULL;
	DVBChannel* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	const gchar* _tmp69_ = NULL;
	DVBChannel* _tmp70_ = NULL;
	gboolean _tmp71_ = FALSE;
	gboolean _tmp72_ = FALSE;
	GKeyFile* _tmp73_ = NULL;
	DVBChannel* _tmp74_ = NULL;
	const gchar* _tmp75_ = NULL;
	const gchar* _tmp76_ = NULL;
	DVBChannel* _tmp77_ = NULL;
	const gchar* _tmp78_ = NULL;
	const gchar* _tmp79_ = NULL;
	GKeyFile* _tmp80_ = NULL;
	DVBChannel* _tmp81_ = NULL;
	const gchar* _tmp82_ = NULL;
	const gchar* _tmp83_ = NULL;
	DVBChannel* _tmp84_ = NULL;
	const gchar* _tmp85_ = NULL;
	const gchar* _tmp86_ = NULL;
	GKeyFile* _tmp87_ = NULL;
	DVBChannel* _tmp88_ = NULL;
	const gchar* _tmp89_ = NULL;
	const gchar* _tmp90_ = NULL;
	DVBChannel* _tmp91_ = NULL;
	guint _tmp92_ = 0U;
	guint _tmp93_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = self->priv->keyfile;
	if (_tmp0_ == NULL) {
		dvb_io_channel_list_writer_open (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp1_ = self->priv->keyfile;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = channel;
	_tmp3_ = dvb_channel_get_Param (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = dvb_parameter_get_Delsys (_tmp4_);
	_tmp6_ = _tmp5_;
	switch (_tmp6_) {
		case DVB_DVB_SRC_DELSYS_SYS_DVBT:
		{
			DVBChannel* _tmp7_ = NULL;
			_tmp7_ = channel;
			dvb_io_channel_list_writer_write_terrestrial_channel (self, _tmp7_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				return;
			}
			break;
		}
		case DVB_DVB_SRC_DELSYS_SYS_DVBC_ANNEX_A:
		{
			DVBChannel* _tmp8_ = NULL;
			_tmp8_ = channel;
			dvb_io_channel_list_writer_write_cable_channel (self, _tmp8_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				return;
			}
			break;
		}
		case DVB_DVB_SRC_DELSYS_SYS_DVBS:
		{
			DVBChannel* _tmp9_ = NULL;
			_tmp9_ = channel;
			dvb_io_channel_list_writer_write_satellite_channel (self, _tmp9_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				return;
			}
			break;
		}
		default:
		{
			return;
		}
	}
	_tmp10_ = self->priv->keyfile;
	_tmp11_ = channel;
	_tmp12_ = dvb_channel_get_Name (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = channel;
	_tmp15_ = dvb_channel_get_Sid (_tmp14_);
	_tmp16_ = _tmp15_;
	g_key_file_set_uint64 (_tmp10_, _tmp13_, "SERVICE_ID", (guint64) _tmp16_);
	_tmp17_ = self->priv->keyfile;
	_tmp18_ = channel;
	_tmp19_ = dvb_channel_get_Name (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = channel;
	_tmp22_ = dvb_channel_get_ServiceType (_tmp21_);
	_tmp23_ = _tmp22_;
	g_key_file_set_uint64 (_tmp17_, _tmp20_, "SERVICE_TYPE", (guint64) _tmp23_);
	_tmp24_ = channel;
	_tmp25_ = dvb_channel_get_VideoPID (_tmp24_);
	_tmp26_ = _tmp25_;
	if (_tmp26_ != ((guint) 0)) {
		GKeyFile* _tmp27_ = NULL;
		DVBChannel* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		DVBChannel* _tmp31_ = NULL;
		guint _tmp32_ = 0U;
		guint _tmp33_ = 0U;
		_tmp27_ = self->priv->keyfile;
		_tmp28_ = channel;
		_tmp29_ = dvb_channel_get_Name (_tmp28_);
		_tmp30_ = _tmp29_;
		_tmp31_ = channel;
		_tmp32_ = dvb_channel_get_VideoPID (_tmp31_);
		_tmp33_ = _tmp32_;
		g_key_file_set_uint64 (_tmp27_, _tmp30_, "VIDEO_PID", (guint64) _tmp33_);
	}
	_tmp34_ = channel;
	_tmp35_ = dvb_channel_get_AudioPIDs (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp38_ > 0) {
		gint* apid = NULL;
		DVBChannel* _tmp39_ = NULL;
		GeeList* _tmp40_ = NULL;
		GeeList* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gint _tmp43_ = 0;
		gint* _tmp44_ = NULL;
		gint apid_length1 = 0;
		gint _apid_size_ = 0;
		GKeyFile* _tmp61_ = NULL;
		DVBChannel* _tmp62_ = NULL;
		const gchar* _tmp63_ = NULL;
		const gchar* _tmp64_ = NULL;
		gint* _tmp65_ = NULL;
		gint _tmp65__length1 = 0;
		_tmp39_ = channel;
		_tmp40_ = dvb_channel_get_AudioPIDs (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = gee_collection_get_size ((GeeCollection*) _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = g_new0 (gint, _tmp43_);
		apid = _tmp44_;
		apid_length1 = _tmp43_;
		_apid_size_ = apid_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp45_ = FALSE;
				_tmp45_ = TRUE;
				while (TRUE) {
					gint _tmp47_ = 0;
					DVBChannel* _tmp48_ = NULL;
					GeeList* _tmp49_ = NULL;
					GeeList* _tmp50_ = NULL;
					gint _tmp51_ = 0;
					gint _tmp52_ = 0;
					gint* _tmp53_ = NULL;
					gint _tmp53__length1 = 0;
					gint _tmp54_ = 0;
					DVBChannel* _tmp55_ = NULL;
					GeeList* _tmp56_ = NULL;
					GeeList* _tmp57_ = NULL;
					gint _tmp58_ = 0;
					gpointer _tmp59_ = NULL;
					gint _tmp60_ = 0;
					if (!_tmp45_) {
						gint _tmp46_ = 0;
						_tmp46_ = i;
						i = _tmp46_ + 1;
					}
					_tmp45_ = FALSE;
					_tmp47_ = i;
					_tmp48_ = channel;
					_tmp49_ = dvb_channel_get_AudioPIDs (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = gee_collection_get_size ((GeeCollection*) _tmp50_);
					_tmp52_ = _tmp51_;
					if (!(_tmp47_ < _tmp52_)) {
						break;
					}
					_tmp53_ = apid;
					_tmp53__length1 = apid_length1;
					_tmp54_ = i;
					_tmp55_ = channel;
					_tmp56_ = dvb_channel_get_AudioPIDs (_tmp55_);
					_tmp57_ = _tmp56_;
					_tmp58_ = i;
					_tmp59_ = gee_list_get (_tmp57_, _tmp58_);
					_tmp53_[_tmp54_] = (gint) ((guint) ((guintptr) _tmp59_));
					_tmp60_ = _tmp53_[_tmp54_];
				}
			}
		}
		_tmp61_ = self->priv->keyfile;
		_tmp62_ = channel;
		_tmp63_ = dvb_channel_get_Name (_tmp62_);
		_tmp64_ = _tmp63_;
		_tmp65_ = apid;
		_tmp65__length1 = apid_length1;
		g_key_file_set_integer_list (_tmp61_, _tmp64_, "AUDIO_PID", _tmp65_, _tmp65__length1);
		apid = (g_free (apid), NULL);
	}
	_tmp66_ = self->priv->keyfile;
	_tmp67_ = channel;
	_tmp68_ = dvb_channel_get_Name (_tmp67_);
	_tmp69_ = _tmp68_;
	_tmp70_ = channel;
	_tmp71_ = dvb_channel_get_Scrambled (_tmp70_);
	_tmp72_ = _tmp71_;
	g_key_file_set_boolean (_tmp66_, _tmp69_, "SCRAMBLED", _tmp72_);
	_tmp73_ = self->priv->keyfile;
	_tmp74_ = channel;
	_tmp75_ = dvb_channel_get_Name (_tmp74_);
	_tmp76_ = _tmp75_;
	_tmp77_ = channel;
	_tmp78_ = dvb_channel_get_Network (_tmp77_);
	_tmp79_ = _tmp78_;
	g_key_file_set_string (_tmp73_, _tmp76_, "PROVIDER", _tmp79_);
	_tmp80_ = self->priv->keyfile;
	_tmp81_ = channel;
	_tmp82_ = dvb_channel_get_Name (_tmp81_);
	_tmp83_ = _tmp82_;
	_tmp84_ = channel;
	_tmp85_ = dvb_channel_get_Name (_tmp84_);
	_tmp86_ = _tmp85_;
	g_key_file_set_string (_tmp80_, _tmp83_, "SERVICE_NAME", _tmp86_);
	_tmp87_ = self->priv->keyfile;
	_tmp88_ = channel;
	_tmp89_ = dvb_channel_get_Name (_tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = channel;
	_tmp92_ = dvb_channel_get_TransportStreamId (_tmp91_);
	_tmp93_ = _tmp92_;
	g_key_file_set_uint64 (_tmp87_, _tmp90_, "TRANSPORT_STREAM_ID", (guint64) _tmp93_);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


gboolean dvb_io_channel_list_writer_close (DVBioChannelListWriter* self, GError** error) {
	gboolean result = FALSE;
	GKeyFile* _tmp0_ = NULL;
	GOutputStream* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GOutputStream* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->keyfile;
	if (_tmp0_ != NULL) {
		GOutputStream* _tmp1_ = NULL;
		GKeyFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		guint8* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		guint8* _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp1_ = self->priv->stream;
		_tmp2_ = self->priv->keyfile;
		_tmp3_ = g_key_file_to_data (_tmp2_, NULL, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_get_data (_tmp4_, &_tmp5__length1);
		_tmp6_ = _tmp5_;
		_tmp6__length1 = _tmp5__length1;
		g_output_stream_write_all (_tmp1_, _tmp6_, (gsize) _tmp6__length1, NULL, NULL, &_inner_error_);
		_g_free0 (_tmp4_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
		_g_key_file_unref0 (self->priv->keyfile);
		self->priv->keyfile = NULL;
	}
	_tmp7_ = self->priv->stream;
	if (_tmp7_ == NULL) {
		result = TRUE;
		return result;
	}
	_tmp9_ = self->priv->stream;
	_tmp10_ = g_output_stream_close (_tmp9_, NULL, &_inner_error_);
	_tmp8_ = _tmp10_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return FALSE;
	}
	result = _tmp8_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_channel_list_writer_write_terrestrial_channel (DVBioChannelListWriter* self, DVBChannel* channel, GError** error) {
	DVBDvbTParameter* param = NULL;
	DVBChannel* _tmp0_ = NULL;
	DVBParameter* _tmp1_ = NULL;
	DVBParameter* _tmp2_ = NULL;
	DVBDvbTParameter* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	DVBChannel* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	DVBChannel* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	GKeyFile* _tmp14_ = NULL;
	DVBChannel* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	GKeyFile* _tmp20_ = NULL;
	DVBChannel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GstMpegtsModulationType _tmp24_ = 0;
	GstMpegtsModulationType _tmp25_ = 0;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GKeyFile* _tmp28_ = NULL;
	DVBChannel* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GstMpegtsDVBCodeRate _tmp32_ = 0;
	GstMpegtsDVBCodeRate _tmp33_ = 0;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	GKeyFile* _tmp36_ = NULL;
	DVBChannel* _tmp37_ = NULL;
	const gchar* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	GstMpegtsDVBCodeRate _tmp40_ = 0;
	GstMpegtsDVBCodeRate _tmp41_ = 0;
	gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	GKeyFile* _tmp44_ = NULL;
	DVBChannel* _tmp45_ = NULL;
	const gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	GstMpegtsTerrestrialGuardInterval _tmp48_ = 0;
	GstMpegtsTerrestrialGuardInterval _tmp49_ = 0;
	gchar* _tmp50_ = NULL;
	gchar* _tmp51_ = NULL;
	GKeyFile* _tmp52_ = NULL;
	DVBChannel* _tmp53_ = NULL;
	const gchar* _tmp54_ = NULL;
	const gchar* _tmp55_ = NULL;
	GstMpegtsTerrestrialTransmissionMode _tmp56_ = 0;
	GstMpegtsTerrestrialTransmissionMode _tmp57_ = 0;
	gchar* _tmp58_ = NULL;
	gchar* _tmp59_ = NULL;
	GKeyFile* _tmp60_ = NULL;
	DVBChannel* _tmp61_ = NULL;
	const gchar* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	GstMpegtsTerrestrialHierarchy _tmp64_ = 0;
	GstMpegtsTerrestrialHierarchy _tmp65_ = 0;
	gchar* _tmp66_ = NULL;
	gchar* _tmp67_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Param (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, DVB_TYPE_DVB_TPARAMETER, DVBDvbTParameter));
	param = _tmp3_;
	_tmp4_ = self->priv->keyfile;
	_tmp5_ = channel;
	_tmp6_ = dvb_channel_get_Name (_tmp5_);
	_tmp7_ = _tmp6_;
	g_key_file_set_string (_tmp4_, _tmp7_, "DELIVERY_SYSTEM", "DVBT");
	_tmp8_ = self->priv->keyfile;
	_tmp9_ = channel;
	_tmp10_ = dvb_channel_get_Name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = dvb_parameter_get_Frequency ((DVBParameter*) param);
	_tmp13_ = _tmp12_;
	g_key_file_set_uint64 (_tmp8_, _tmp11_, "FREQUENCY", (guint64) _tmp13_);
	_tmp14_ = self->priv->keyfile;
	_tmp15_ = channel;
	_tmp16_ = dvb_channel_get_Name (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = dvb_dvb_tparameter_get_Bandwidth (param);
	_tmp19_ = _tmp18_;
	g_key_file_set_uint64 (_tmp14_, _tmp17_, "BANDWIDTH_HZ", (guint64) _tmp19_);
	_tmp20_ = self->priv->keyfile;
	_tmp21_ = channel;
	_tmp22_ = dvb_channel_get_Name (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = dvb_dvb_tparameter_get_Constellation (param);
	_tmp25_ = _tmp24_;
	_tmp26_ = dvb_getModulationString (_tmp25_);
	_tmp27_ = _tmp26_;
	g_key_file_set_string (_tmp20_, _tmp23_, "MODULATION", _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = self->priv->keyfile;
	_tmp29_ = channel;
	_tmp30_ = dvb_channel_get_Name (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = dvb_dvb_tparameter_get_CodeRateHP (param);
	_tmp33_ = _tmp32_;
	_tmp34_ = dvb_getCodeRateString (_tmp33_);
	_tmp35_ = _tmp34_;
	g_key_file_set_string (_tmp28_, _tmp31_, "CODE_RATE_HP", _tmp35_);
	_g_free0 (_tmp35_);
	_tmp36_ = self->priv->keyfile;
	_tmp37_ = channel;
	_tmp38_ = dvb_channel_get_Name (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = dvb_dvb_tparameter_get_CodeRateLP (param);
	_tmp41_ = _tmp40_;
	_tmp42_ = dvb_getCodeRateString (_tmp41_);
	_tmp43_ = _tmp42_;
	g_key_file_set_string (_tmp36_, _tmp39_, "CODE_RATE_LP", _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = self->priv->keyfile;
	_tmp45_ = channel;
	_tmp46_ = dvb_channel_get_Name (_tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = dvb_dvb_tparameter_get_GuardInterval (param);
	_tmp49_ = _tmp48_;
	_tmp50_ = dvb_getGuardIntervalString (_tmp49_);
	_tmp51_ = _tmp50_;
	g_key_file_set_string (_tmp44_, _tmp47_, "GUARD_INTERVAL", _tmp51_);
	_g_free0 (_tmp51_);
	_tmp52_ = self->priv->keyfile;
	_tmp53_ = channel;
	_tmp54_ = dvb_channel_get_Name (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = dvb_dvb_tparameter_get_TransmissionMode (param);
	_tmp57_ = _tmp56_;
	_tmp58_ = dvb_getTransmissionModeString (_tmp57_);
	_tmp59_ = _tmp58_;
	g_key_file_set_string (_tmp52_, _tmp55_, "TRANSMISSION_MODE", _tmp59_);
	_g_free0 (_tmp59_);
	_tmp60_ = self->priv->keyfile;
	_tmp61_ = channel;
	_tmp62_ = dvb_channel_get_Name (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = dvb_dvb_tparameter_get_Hierarchy (param);
	_tmp65_ = _tmp64_;
	_tmp66_ = dvb_getHierarchyString (_tmp65_);
	_tmp67_ = _tmp66_;
	g_key_file_set_string (_tmp60_, _tmp63_, "HIERARCHY", _tmp67_);
	_g_free0 (_tmp67_);
	_g_object_unref0 (param);
}


static void dvb_io_channel_list_writer_write_satellite_channel (DVBioChannelListWriter* self, DVBChannel* channel, GError** error) {
	DVBDvbSParameter* param = NULL;
	DVBChannel* _tmp0_ = NULL;
	DVBParameter* _tmp1_ = NULL;
	DVBParameter* _tmp2_ = NULL;
	DVBDvbSParameter* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	DVBChannel* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	DVBChannel* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	DVBDvbSParameter* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	GKeyFile* _tmp15_ = NULL;
	DVBChannel* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	DVBDvbSParameter* _tmp19_ = NULL;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	GKeyFile* _tmp22_ = NULL;
	DVBChannel* _tmp23_ = NULL;
	const gchar* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	DVBDvbSParameter* _tmp26_ = NULL;
	GstMpegtsDVBCodeRate _tmp27_ = 0;
	GstMpegtsDVBCodeRate _tmp28_ = 0;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_ = NULL;
	GKeyFile* _tmp31_ = NULL;
	DVBChannel* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	DVBDvbSParameter* _tmp35_ = NULL;
	GstMpegtsSatellitePolarizationType _tmp36_ = 0;
	GstMpegtsSatellitePolarizationType _tmp37_ = 0;
	gchar* _tmp38_ = NULL;
	gchar* _tmp39_ = NULL;
	GKeyFile* _tmp40_ = NULL;
	DVBChannel* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	DVBDvbSParameter* _tmp44_ = NULL;
	gfloat _tmp45_ = 0.0F;
	gfloat _tmp46_ = 0.0F;
	DVBDvbSParameter* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	gint _tmp49_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Param (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, DVB_TYPE_DVB_SPARAMETER, DVBDvbSParameter));
	param = _tmp3_;
	_tmp4_ = self->priv->keyfile;
	_tmp5_ = channel;
	_tmp6_ = dvb_channel_get_Name (_tmp5_);
	_tmp7_ = _tmp6_;
	g_key_file_set_string (_tmp4_, _tmp7_, "DELIVERY_SYSTEM", "DVBS");
	_tmp8_ = self->priv->keyfile;
	_tmp9_ = channel;
	_tmp10_ = dvb_channel_get_Name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = param;
	_tmp13_ = dvb_parameter_get_Frequency ((DVBParameter*) _tmp12_);
	_tmp14_ = _tmp13_;
	g_key_file_set_uint64 (_tmp8_, _tmp11_, "FREQUENCY", (guint64) _tmp14_);
	_tmp15_ = self->priv->keyfile;
	_tmp16_ = channel;
	_tmp17_ = dvb_channel_get_Name (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = param;
	_tmp20_ = dvb_dvb_sparameter_get_SymbolRate (_tmp19_);
	_tmp21_ = _tmp20_;
	g_key_file_set_uint64 (_tmp15_, _tmp18_, "SYMBOL_RATE", (guint64) _tmp21_);
	_tmp22_ = self->priv->keyfile;
	_tmp23_ = channel;
	_tmp24_ = dvb_channel_get_Name (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = param;
	_tmp27_ = dvb_dvb_sparameter_get_InnerFEC (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = dvb_getCodeRateString (_tmp28_);
	_tmp30_ = _tmp29_;
	g_key_file_set_string (_tmp22_, _tmp25_, "INNER_FEC", _tmp30_);
	_g_free0 (_tmp30_);
	_tmp31_ = self->priv->keyfile;
	_tmp32_ = channel;
	_tmp33_ = dvb_channel_get_Name (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = param;
	_tmp36_ = dvb_dvb_sparameter_get_Polarization (_tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = dvb_getPolarizationString (_tmp37_);
	_tmp39_ = _tmp38_;
	g_key_file_set_string (_tmp31_, _tmp34_, "POLARIZATION", _tmp39_);
	_g_free0 (_tmp39_);
	_tmp40_ = self->priv->keyfile;
	_tmp41_ = channel;
	_tmp42_ = dvb_channel_get_Name (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = param;
	_tmp45_ = dvb_dvb_sparameter_get_OrbitalPosition (_tmp44_);
	_tmp46_ = _tmp45_;
	g_key_file_set_double (_tmp40_, _tmp43_, "ORBITAL_POSITION", (gdouble) _tmp46_);
	_tmp47_ = param;
	_tmp48_ = dvb_dvb_sparameter_get_DiseqcSource (_tmp47_);
	_tmp49_ = _tmp48_;
	if (_tmp49_ > -1) {
		GKeyFile* _tmp50_ = NULL;
		DVBChannel* _tmp51_ = NULL;
		const gchar* _tmp52_ = NULL;
		const gchar* _tmp53_ = NULL;
		DVBDvbSParameter* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		_tmp50_ = self->priv->keyfile;
		_tmp51_ = channel;
		_tmp52_ = dvb_channel_get_Name (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = param;
		_tmp55_ = dvb_dvb_sparameter_get_DiseqcSource (_tmp54_);
		_tmp56_ = _tmp55_;
		g_key_file_set_uint64 (_tmp50_, _tmp53_, "SAT_NUMBER", (guint64) _tmp56_);
	}
	_g_object_unref0 (param);
}


static void dvb_io_channel_list_writer_write_cable_channel (DVBioChannelListWriter* self, DVBChannel* channel, GError** error) {
	DVBDvbCEuropeParameter* param = NULL;
	DVBChannel* _tmp0_ = NULL;
	DVBParameter* _tmp1_ = NULL;
	DVBParameter* _tmp2_ = NULL;
	DVBDvbCEuropeParameter* _tmp3_ = NULL;
	GKeyFile* _tmp4_ = NULL;
	DVBChannel* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GKeyFile* _tmp8_ = NULL;
	DVBChannel* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	GKeyFile* _tmp14_ = NULL;
	DVBChannel* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	GKeyFile* _tmp20_ = NULL;
	DVBChannel* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	const gchar* _tmp23_ = NULL;
	GstMpegtsDVBCodeRate _tmp24_ = 0;
	GstMpegtsDVBCodeRate _tmp25_ = 0;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GKeyFile* _tmp28_ = NULL;
	DVBChannel* _tmp29_ = NULL;
	const gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	GstMpegtsModulationType _tmp32_ = 0;
	GstMpegtsModulationType _tmp33_ = 0;
	gchar* _tmp34_ = NULL;
	gchar* _tmp35_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = dvb_channel_get_Param (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, DVB_TYPE_DVB_CEUROPE_PARAMETER, DVBDvbCEuropeParameter));
	param = _tmp3_;
	_tmp4_ = self->priv->keyfile;
	_tmp5_ = channel;
	_tmp6_ = dvb_channel_get_Name (_tmp5_);
	_tmp7_ = _tmp6_;
	g_key_file_set_string (_tmp4_, _tmp7_, "DELIVERY_SYSTEM", "DVBC/ANNEX_A");
	_tmp8_ = self->priv->keyfile;
	_tmp9_ = channel;
	_tmp10_ = dvb_channel_get_Name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = dvb_parameter_get_Frequency ((DVBParameter*) param);
	_tmp13_ = _tmp12_;
	g_key_file_set_uint64 (_tmp8_, _tmp11_, "FREQUENCY", (guint64) _tmp13_);
	_tmp14_ = self->priv->keyfile;
	_tmp15_ = channel;
	_tmp16_ = dvb_channel_get_Name (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = dvb_dvb_ceurope_parameter_get_SymbolRate (param);
	_tmp19_ = _tmp18_;
	g_key_file_set_uint64 (_tmp14_, _tmp17_, "SYMBOL_RATE", (guint64) _tmp19_);
	_tmp20_ = self->priv->keyfile;
	_tmp21_ = channel;
	_tmp22_ = dvb_channel_get_Name (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = dvb_dvb_ceurope_parameter_get_InnerFEC (param);
	_tmp25_ = _tmp24_;
	_tmp26_ = dvb_getCodeRateString (_tmp25_);
	_tmp27_ = _tmp26_;
	g_key_file_set_string (_tmp20_, _tmp23_, "INNER_FEC", _tmp27_);
	_g_free0 (_tmp27_);
	_tmp28_ = self->priv->keyfile;
	_tmp29_ = channel;
	_tmp30_ = dvb_channel_get_Name (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = dvb_dvb_ceurope_parameter_get_Modulation (param);
	_tmp33_ = _tmp32_;
	_tmp34_ = dvb_getModulationString (_tmp33_);
	_tmp35_ = _tmp34_;
	g_key_file_set_string (_tmp28_, _tmp31_, "MODULATION", _tmp35_);
	_g_free0 (_tmp35_);
	_g_object_unref0 (param);
}


GFile* dvb_io_channel_list_writer_get_file (DVBioChannelListWriter* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}


static void dvb_io_channel_list_writer_set_file (DVBioChannelListWriter* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp1_;
	g_object_notify ((GObject *) self, "file");
}


static void dvb_io_channel_list_writer_class_init (DVBioChannelListWriterClass * klass) {
	dvb_io_channel_list_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioChannelListWriterPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_io_channel_list_writer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_dvb_io_channel_list_writer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_channel_list_writer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_CHANNEL_LIST_WRITER_FILE, g_param_spec_object ("file", "file", "file", g_file_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_io_channel_list_writer_instance_init (DVBioChannelListWriter * self) {
	self->priv = DVB_IO_CHANNEL_LIST_WRITER_GET_PRIVATE (self);
}


static void dvb_io_channel_list_writer_finalize (GObject* obj) {
	DVBioChannelListWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter);
	_g_object_unref0 (self->priv->_file);
	_g_key_file_unref0 (self->priv->keyfile);
	_g_object_unref0 (self->priv->stream);
	G_OBJECT_CLASS (dvb_io_channel_list_writer_parent_class)->finalize (obj);
}


/**
     * Example:
     * try {
     *     var writer = new DVB.ChannelListWriter (File.new_for_path ("/path/to/channels.conf"));
     *     foreach (DVB.Channel c in reader.Channels) {
     *         writer.write (c);
     *     }
     *     writer.close ();
     * } catch (IOError e) {
     *     error (e.message);
     * }
     */
GType dvb_io_channel_list_writer_get_type (void) {
	static volatile gsize dvb_io_channel_list_writer_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_channel_list_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioChannelListWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_channel_list_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioChannelListWriter), 0, (GInstanceInitFunc) dvb_io_channel_list_writer_instance_init, NULL };
		GType dvb_io_channel_list_writer_type_id;
		dvb_io_channel_list_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioChannelListWriter", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_channel_list_writer_type_id__volatile, dvb_io_channel_list_writer_type_id);
	}
	return dvb_io_channel_list_writer_type_id__volatile;
}


static void _vala_dvb_io_channel_list_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioChannelListWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_WRITER_FILE:
		g_value_set_object (value, dvb_io_channel_list_writer_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_dvb_io_channel_list_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioChannelListWriter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_IO_TYPE_CHANNEL_LIST_WRITER, DVBioChannelListWriter);
	switch (property_id) {
		case DVB_IO_CHANNEL_LIST_WRITER_FILE:
		dvb_io_channel_list_writer_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



