/*
 * Copiright 2000 by Hans Reiser, licensing governed by reiserfs/README
 */

#ifndef _REISER_FS_I
#define _REISER_FS_I

#define REISERFS_N_BLOCKS 10

struct reiserfs_inode_info {
  struct pipe_inode_info reserved;
  __u32 i_key [4];
  __u32 i_first_direct_byte;

  int i_data_length;
  __u32 i_data [REISERFS_N_BLOCKS];
  int i_is_being_converted;
  int i_read_sync_counter;
  int i_pack_on_close ;
  int i_transaction_index ;
  int i_transaction_id ;


    int nopack;  /* nopack-attribute */
    int i_not_charged;  /* symlink or empty dir eats 1 block quota. When
			   symink or empty dir's body get removed - that quota
			   gets freed. But when symlink or empty dir's
			   creation fails before it eats its quota and we have
			   to delete symlink or empty dir's body - we have to
			   skip freeing of the quota as it was not eaten yet */
};


#endif
