/*
 * 
 * rd.untar.c
 * 
 * Dimitri Maziuk
 * and
 * Dave Cinege
 * 
 * Parts stolen from GNU 'Let's make the same archive 10 different ways' tar
 * 
 * 1998-01-10
 * This version of untar is very limited. It expects a fairly good archive, 
 * as well as expansion to a clean root.
 * 
 * It does not:
 * 
 * Look for a leading '/'
 * Check before making links
 * Look at the header checksum
 * Check or create any leading directory structure
 * 
 * 1998-01-17
 * Is GNUtar the biggest fuck-up in released software since MS-DOS? 
 * It could be.
 * 
 * Tar decides it sometimes likes to make a dir entry that is blank or "./".
 * We now check for this, and modified our exit pattern to deal with it.
 * 
 * Although both Dima and I thought it wasn't possible, tar can  
 * stor files without first storing the dir they require.
 * If your nice freshly made archive doesn't work don't be surprised.
 * Try specing a different way to make it.
 *
 * Dima has a forthcoming mini tar archive creator (ctar) that should
 * better deal with these problems. You may want to look for it if normal
 * tar does not suite your needs when using this kernel feature.
 * 
 * 1998-02-22
 * Convert to 2.1 file ops. Open /dev/ram1 locally. With 2.1 outfile in rd.c
 * was not holding it's value when we entered this code. I think it has
 * to do with the newer __initfunc(); thingy. Couldn't figure out how to
 * make it work. Did this instead.
 *
 * 1998-10-17
 * Move to wrapper function.
 *
 */

#include <linux/unistd.h>
#include <linux/stat.h>
#include <linux/fcntl.h>
#include <linux/stddef.h>  
#include <linux/utime.h>

//DEBUG_UNTAR only
// #include <linux/delay.h>


static unsigned long simple_strtoul_wrapper(const char *cp,char **endp,unsigned int base);

static
int untar(void)
{

//#define DEBUG_UNTAR

#define E_NAMETOOLONG	1
#define E_CANNOTSTAT	2
#define E_READLINK	3
#define E_SHORTWRITE	4
#define E_FOPEN		5
#define E_MALLOC	6
#define E_OPENDIR	7
#define E_WRONG_FTYPE	8

#define	TARBLOCKSIZE	512

#define NAME_FIELD_SIZE   100
#define PREFIX_FIELD_SIZE 155
#define UNAME_FIELD_SIZE   32
#define GNAME_FIELD_SIZE   32

#define TMAGIC   "ustar "	/* ustar and a null */
#define TMAGLEN  6
#define TVERSION " \0"		/* 00 and no null */
#define TVERSLEN 2

#define REGTYPE	 '0'		/* regular file */
#define AREGTYPE '\0'		/* regular file */
#define LNKTYPE  '1'		/* link */
#define SYMTYPE  '2'		/* reserved */
#define CHRTYPE  '3'		/* character special */
#define BLKTYPE  '4'		/* block special */
#define DIRTYPE  '5'		/* directory */
#define FIFOTYPE '6'		/* FIFO special */
#define CONTTYPE '7'		/* reserved */

#define BUF_SIZE (1024*64)

//#define strtoul simple_strtoul
#define strtoul simple_strtoul_wrapper

/* POSIX header  */
struct fileHeader
{					/* byte offset */
  char name[NAME_FIELD_SIZE];		/*   0 */
  char mode[8];				/* 100 */
  char uid[8];				/* 108 */
  char gid[8];				/* 116 */
  char size[12];			/* 124 */
  char mtime[12];			/* 136 */
  char chksum[8];			/* 148 */
  char typeflag;			/* 156 */
  char linkname[NAME_FIELD_SIZE];	/* 157 */
  char magic[TMAGLEN];			/* 257 */
  char version[TVERSLEN];		/* 263 */
  char uname[UNAME_FIELD_SIZE];		/* 265 */
  char gname[GNAME_FIELD_SIZE];		/* 297 */
  char devmajor[8];			/* 329 */
  char devminor[8];			/* 337 */
  char prefix[PREFIX_FIELD_SIZE];	/* 345 */
					/* 500 */
};

union TarInfo 
{
  char buf[TARBLOCKSIZE];
  struct fileHeader header;
};

typedef union TarInfo	TarInfo;

extern int sys_write(unsigned int fd,char * buf,unsigned int count);
extern int sys_chmod(const char * filename, mode_t mode);
extern int sys_chown(const char * filename, uid_t user, gid_t group);
extern int sys_mknod(const char * filename, int mode, dev_t dev);
extern int sys_mkdir(const char * pathname, int mode);
extern int sys_chdir(const char * filename);
extern int sys_link(const char * oldname, const char * newname);
extern int sys_symlink(const char * oldname, const char * newname);
extern int sys_utime(char * filename, struct utimbuf * times);
extern int sys_time(int * tloc);

	char *buf = 0;
	int err, fd;
	unsigned long fsize, fsizebuf, rwsize;
	mode_t fmode;
	kdev_t fdev;
	
	struct inode inode;
	struct file infile;
	struct dentry in_dentry;
	kdev_t ram_device;
	struct utimbuf ut;
	union TarInfo *tarInfo;	
    	
	ram_device = MKDEV(MAJOR_NR,1);
	
  	memset(&infile, 0, sizeof(infile));
	memset(&inode, 0, sizeof(inode));
	memset(&in_dentry, 0, sizeof(in_dentry));
	inode.i_rdev = MKDEV(MAJOR_NR, 1);
	infile.f_mode = 1; /* read only */
	infile.f_dentry = &in_dentry;
	in_dentry.d_inode = &inode;
    	
	if (blkdev_open(&inode, &infile) != 0) return -1;
  
  
	//sanity check
	infile.f_pos = 0;
  
	tarInfo = kmalloc(TARBLOCKSIZE,GFP_KERNEL);
	if(tarInfo == 0) {
		printk(KERN_ERR "RAMDISK: Can't allocate tar header buffer\n");
		err=-1;
		goto exit;
	}
	memset(tarInfo,0,TARBLOCKSIZE);  

	buf = kmalloc(BUF_SIZE,GFP_KERNEL);
  	if(buf == 0) {
		printk(KERN_ERR "RAMDISK: Can't allocate tar dump buffer\n");
		err=-1;
		goto exit;
	}
	memset(buf,0,BUF_SIZE);  

	printk(KERN_NOTICE "RAMDISK: Extracting root archive: ");

/* main loop */  
	while(1) {
       
		//read header or return short read
		err=infile.f_op->read(&infile, (char *)tarInfo, TARBLOCKSIZE, &infile.f_pos);
		if(err < TARBLOCKSIZE) {
			if(err == 0) {
				goto exit;
			} else {
				printk(KERN_ERR "RAMDISK: Corrupt tar archive\n");
				err=-1;
				goto exit;
			}
		}

		fmode=strtoul(tarInfo->header.mode,NULL,8);
		fsize=strtoul(tarInfo->header.size,NULL,8);
	
#ifdef DEBUG_UNTAR
printk("\ntype: %c ",tarInfo->header.typeflag);   
printk("name: %s ",tarInfo->header.name);
printk("fsize: %ld ",fsize); 
udelay(100000);
#endif

/*
 * This should fix the problem with '\0' named dirs killing the archive
 * extraction. A better way would be to look to see if fsize[0] contains 
 * '\0' as a normal header would either have a number their or pad it with
 * a ' '. Not sure if all tar's do this, so it may not be safe
 */

		if((tarInfo->header.name[0] == '\0') && (fmode == 0) && (fsize == 0)) {
			err=0;
			goto exit;
		}

		err=0;

		//check the type
		switch(tarInfo->header.typeflag) {
		
			case AREGTYPE : 
			case REGTYPE  :
			
				fd=sys_open(tarInfo->header.name, O_CREAT|O_WRONLY|O_TRUNC, fmode);

				if(fd == -1) {
					err=1;
					break;
				}

				//dump the file in big blocks
				fsizebuf = fsize;

				while (fsizebuf > 0) {
	  
					if (fsizebuf > BUF_SIZE)
						rwsize = BUF_SIZE;
					else
						rwsize = fsizebuf;

					if (infile.f_op->read(&infile , buf, rwsize, &infile.f_pos) < rwsize) 
						err=1;
		
					if (sys_write(fd, buf, rwsize) < rwsize)
						err=1;
			
					fsizebuf -= rwsize;
				}

				sys_close(fd);
	
				if(fsize%TARBLOCKSIZE != 0) 
					infile.f_pos += (TARBLOCKSIZE*(fsize/TARBLOCKSIZE+1))-fsize;
	
				break;
      
			case LNKTYPE  :
			
				err=sys_link(tarInfo->header.linkname,tarInfo->header.name);
				break;

			case SYMTYPE  :
			
				err=sys_symlink(tarInfo->header.linkname,tarInfo->header.name);
				break;
	
			case CHRTYPE  :	
			case BLKTYPE  :	
			case FIFOTYPE :	
			
				fdev=MKDEV(strtoul(tarInfo->header.devmajor,NULL,8),
					   strtoul(tarInfo->header.devminor,NULL,8));
				err=sys_mknod(tarInfo->header.name,fmode,fdev);
       				break;
	
			case DIRTYPE  :
	
				//Skip if name is "" "./" "." ".."
				if((tarInfo->header.name[0] != '.' && tarInfo->header.name[0] != '\0') &&
				   (tarInfo->header.name[1] != '/' && tarInfo->header.name[1] != '\0') &&
				   (tarInfo->header.name[1] != '\0')) {
				err=sys_mkdir(tarInfo->header.name,fmode);
				} else {
					continue;
				}	
				break;
	
			default:
				printk(KERN_ERR "RAMDISK: corrupt tar archive\n");
				err=-1;
				goto exit;
		}


		//Good idea to continue anyhow??
		if(err)
			printk("\nError making %s", tarInfo->header.name);
    
	
		if(tarInfo->header.typeflag != LNKTYPE && tarInfo->header.typeflag != SYMTYPE) {
			err=sys_chown(tarInfo->header.name,
				      strtoul(tarInfo->header.uid,NULL,8),
				      strtoul(tarInfo->header.gid,NULL,8));
			err=sys_chmod(tarInfo->header.name,fmode);
		}

		if(err)
			printk("\nError chown and/or chmod %s", tarInfo->header.name);
		
		ut.actime=sys_time(NULL);
		ut.modtime=strtoul(tarInfo->header.mtime,NULL,8);
		sys_utime(tarInfo->header.name,&ut);
	
	}
/* end main loop */

exit:

	kfree(tarInfo);
	kfree(buf);
	invalidate_buffers(ram_device);

	if (infile.f_op->release)
		infile.f_op->release(&inode, &infile);

	printk("done.\n");

	return (err);
	
}

/*
 * simple_strtoul() does not strip leading spaces (0x20) from the input
 * string. The 'real' strtoul does. This wrapper works around this.
 * NOTE: This probably should be fixed in: lib/vsprintf.c 
 *
 */

static
unsigned long simple_strtoul_wrapper(const char *cp,char **endp,unsigned int base)
{
	while (*cp == ' ') {
		cp++;
	}

	return ( simple_strtoul(cp,endp,base) );
}
