/*****************************************************************************
* fpipemon.h	Frame Relay Monitor definitions.
*
* Author:	Jaspreet Singh <jaspreet@sangoma.com>
*
* Copyright:	(c) 1995-1997 Sangoma Technologies Inc.
*
*		This program is free software; you can redistribute it and/or
*		modify it under the terms of the GNU General Public License
*		as published by the Free Software Foundation; either version
*		2 of the License, or (at your option) any later version.
* ----------------------------------------------------------------------------
* Oct 20, 1997	Jaspreet Singh	Driver statistics commands, router up command
* Jun 24, 1997	Jaspreet Singh	S508/FT1 commands
* Apr 25, 1997	Farhan Thawar	Initial version based on fpipemon for WinNT.
*****************************************************************************/
/* FAPI_M.H - mailbox command codes (FR only) */

/* Frame Relay Mailbox commands */
#define	INFORMATION_WRITE				0x01
#define	INFORMATION_READ				0x02
#define	ISSUE_IN_CHANNEL_SIGNALLING_FRAME		0x03
#define	SET_DLCI_CONFIGURATION				0x10
#define	READ_DLCI_CONFIGURATION				0x11
#define	DISABLE_COMMUNICATIONS				0x12
#define	ENABLE_COMMUNICATIONS				0x13
#define	READ_DLC_STATUS					0x14
#define	READ_DLC_STATISTICS				0x15
#define	FLUSH_DLC_STATISTICS				0x16
#define	LIST_ACTIVE_DLCI				0x17
#define	FLUSH_INFORMATION_BUFFERS			0x18
#define READ_ADD_DLC_STATISTICS				0x19
#define	ADD_DLCI					0x20
#define	DELETE_DLCI					0x21
#define	ACTIVATE_DLCI					0x22
#define	DEACTIVATE_DLCI					0x23
#define	READ_MODEM_STATUS				0x30
#define	SET_MODEM_STATUS				0x31
#define	READ_COMMS_ERR_STATS				0x32
#define FLUSH_COMMS_ERR_STATS				0x33
#define	READ_CODE_VERSION				0x40
#define FT1_MONITOR_STATUS_CTRL				0x80
#define SET_FT1_MODE					0x81

#define	UNUSED_CMD_FOR_EVENTS				0x7f

#define ADDR_PAR_PORT_A_INTERFACE_BYTE		0x1020
#define ADDR_PAR_PORT_B_INTERFACE_BYTE		0x1021

#define	Z80_TIMEOUT_ERROR	0x0a
#define	DATA_LENGTH_TOO_BIG	0x05
#define	NO_BUFFS			0x08
#define	NO_DATA_AVAILABLE	0x05


/* UDP management commands */
#define FPIPE_ENABLE_TRACING			0x41
#define FPIPE_DISABLE_TRACING			0x42
#define FPIPE_GET_TRACE_INFO			0x43
#define FPIPE_FT1_READ_STATUS			0x44
#define FPIPE_DRIVER_STAT_IFSEND		0x45
#define FPIPE_DRIVER_STAT_INTR			0x46
#define FPIPE_DRIVER_STAT_GEN			0x47
#define FPIPE_FLUSH_DRIVER_STATS		0x48
#define FPIPE_ROUTER_UP_TIME			0x49
