#!/bin/sh

set -e

if [ "$1" == "" ]; then
    echo "No installation directory, aborting."
    exit 1;
fi

h=`sort tinylogin.links | uniq`

for i in $h ; do
	echo "  $1$i -> /bin/tinylogin"
	mkdir -p $1/`echo $i | sed -e 's/\/[^\/]*$//' `
	ln -fs /bin/tinylogin $1$i
done
rm -f $1/bin/tinylogin
install -m 755 tinylogin $1/bin/tinylogin

exit 0
