RCSID $Id: drivers.net.Space.c,v 1.3 1999/04/06 04:54:29 rgb Exp $
--- ./drivers/net/Space.c.preipsec	Sun Nov 15 13:33:02 1998
+++ ./drivers/net/Space.c	Mon Apr  5 05:26:29 1999
@@ -473,6 +473,40 @@
 #define	NEXT_DEV	(&fddi0_dev)
 #endif 
 
+#ifdef CONFIG_IPSEC
+extern int ipsec_tunnel_probe(struct device *);
+
+static struct device dev_ipsec1 = 
+{
+	"ipsec1\0   ",		/* name */
+	0,			/* recv memory end */
+	0,			/* recv memory start */
+	0,			/* memory end */
+	0,			/* memory start */
+ 	0x0,			/* base I/O address */
+	0,			/* IRQ */
+	0, 0, 0,		/* flags */
+	NEXT_DEV,		/* next device */
+	ipsec_tunnel_probe	/* setup */
+};
+
+static struct device dev_ipsec0 = 
+{
+	"ipsec0\0   ",		/* name */
+	0,			/* recv memory end */
+	0,			/* recv memory start */
+	0,			/* memory end */
+	0,			/* memory start */
+ 	0x0,			/* base I/O address */
+	0,			/* IRQ */
+	0, 0, 0,		/* flags */
+	&dev_ipsec1,		/* next device */
+	ipsec_tunnel_probe	/* setup */
+};
+#   undef	NEXT_DEV
+#   define	NEXT_DEV	(&dev_ipsec0)
+#endif /* CONFIG_IPSEC */
+
 #ifdef CONFIG_NET_IPIP
 	extern int tunnel_init(struct device *);
 	
