/*
 * IPSEC tunneling code
 * Copyright (C) 1996, 1997  John Ioannidis.
 * Copyright (C) 1998, 1999  Richard Guy Briggs.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * RCSID $Id: ipsec_tunnel.h,v 1.8 1999/04/11 00:29:01 henry Exp $
 */

/*
 * Heavily based on drivers/net/new_tunnel.c.  Lots
 * of ideas also taken from the 2.1.x version of drivers/net/shaper.c
 */

struct ipsectunnelconf
{
	__u32	cf_cmd;
	union
	{
		char 	cfu_name[12];
	} cf_u;
#define cf_name cf_u.cfu_name
};

#define IPSEC_SET_DEV	(SIOCDEVPRIVATE)
#define IPSEC_DEL_DEV	(SIOCDEVPRIVATE + 1)
#define IPSEC_CLR_DEV	(SIOCDEVPRIVATE + 2)

#ifdef __KERNEL__
struct ipsecpriv
{
	struct sk_buff_head sendq;
	struct device *dev;
	struct wait_queue *wait_queue;
	char locked;
	int  (*hard_start_xmit) (struct sk_buff *skb,
		struct device *dev);
	int  (*hard_header) (struct sk_buff *skb,
		struct device *dev,
		unsigned short type,
		void *daddr,
		void *saddr,
		unsigned len);
	int  (*rebuild_header)(void *buff, struct device *dev,
			unsigned long raddr, struct sk_buff *skb);
	int  (*set_mac_address)(struct device *dev, void *addr);
	void (*header_cache_bind)(struct hh_cache **hhp, struct device *dev,
				 unsigned short htype, __u32 daddr);
	void (*header_cache_update)(struct hh_cache *hh, struct device *dev, unsigned char *  haddr);
	struct enet_statistics *(*get_stats)(struct device *dev);
	struct enet_statistics mystats;
	int mtu;	/* What is the desired MTU? */
};

#define IPSEC_NUM_IF	2

extern char ipsec_tunnel_c_version[];

int ipsec_tunnel_init_module(void);

void ipsec_tunnel_cleanup_module(void);

extern void ipsec_init(void);

extern struct proc_dir_entry ipsec_eroute;
extern struct proc_dir_entry ipsec_spi;
extern struct proc_dir_entry ipsec_spigrp;
extern struct proc_dir_entry ipsec_tncfg;
extern struct proc_dir_entry ipsec_spinew;
extern struct proc_dir_entry ipsec_version;

#ifdef DEBUG_IPSEC
extern int debug_tunnel;
#endif /* DEBUG_IPSEC */
#endif /* __KERNEL__ */

#ifdef DEBUG_IPSEC
#define DB_TN_INIT	0x0001
#define DB_TN_PROCFS	0x0002
#define DB_TN_XMIT	0x0010
#define DB_TN_OHDR	0x0020
#define DB_TN_CROUT	0x0040
#define DB_TN_OXFS	0x0080
#define DB_TN_REVEC	0x0100
#endif /* DEBUG_IPSEC */

/*
 * $Log: ipsec_tunnel.h,v $
 * Revision 1.8  1999/04/11 00:29:01  henry
 * GPL boilerplate
 *
 * Revision 1.7  1999/04/06 04:54:28  rgb
 * Fix/Add RCSID Id: and Log: bits to make PHMDs happy.  This includes
 * patch shell fixes.
 *
 * Revision 1.6  1999/03/31 05:44:48  rgb
 * Keep PMTU reduction private.
 *
 * Revision 1.5  1999/02/10 22:31:20  rgb
 * Change rebuild_header member to reflect generality of link layer.
 *
 * Revision 1.4  1998/12/01 13:22:04  rgb
 * Added support for debug printing of version info.
 *
 * Revision 1.3  1998/07/29 20:42:46  rgb
 * Add a macro for clearing all tunnel devices.
 * Rearrange structures and declarations for sharing with userspace.
 *
 * Revision 1.2  1998/06/25 20:01:45  rgb
 * Make prototypes available for ipsec_init and ipsec proc_dir_entries
 * for static linking.
 *
 * Revision 1.1  1998/06/18 21:27:50  henry
 * move sources from klips/src to klips/net/ipsec, to keep stupid
 * kernel-build scripts happier in the presence of symlinks
 *
 * Revision 1.3  1998/05/18 21:51:50  rgb
 * Added macros for num of I/F's and a procfs debug switch.
 *
 * Revision 1.2  1998/04/21 21:29:09  rgb
 * Rearrange debug switches to change on the fly debug output from user
 * space.  Only kernel changes checked in at this time.  radij.c was also
 * changed to temporarily remove buggy debugging code in rj_delete causing
 * an OOPS and hence, netlink device open errors.
 *
 * Revision 1.1  1998/04/09 03:06:13  henry
 * sources moved up from linux/net/ipsec
 *
 * Revision 1.1.1.1  1998/04/08 05:35:05  henry
 * RGB's ipsec-0.8pre2.tar.gz ipsec-0.8
 *
 * Revision 0.5  1997/06/03 04:24:48  ji
 * Added transport mode.
 * Changed the way routing is done.
 * Lots of bug fixes.
 *
 * Revision 0.4  1997/01/15 01:28:15  ji
 * No changes.
 *
 * Revision 0.3  1996/11/20 14:39:04  ji
 * Minor cleanups.
 * Rationalized debugging code.
 *
 * Revision 0.2  1996/11/02 00:18:33  ji
 * First limited release.
 *
 *
 */
