/* wrapper for untar()
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <error.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "ctar.h"
 
 
int untar(char* path, int infd);

/* usage: 
untar filename path
untar path        (takes stdin)
untar              (takes stdin, uncompresses to current dir)
*/
int main(int argc, char **argv) 
{
  int fd, ec;
  if(argc<3) {
    fd=0;
    argv--;
  }
  else
  if((fd=open(argv[1],O_RDONLY)) == -1) {
    fprintf(stderr,"Can't open %s\n",argv[1]);
    exit(2);
  }
  ec= (argc>1 ? untar(argv[2],fd): untar(NULL,fd));
  close(fd);
  return(ec);
}

/* 
 * untar() -- see comments for return codes
 *	outfd may be left open on exit !!
 */

/* defined in <sys/sysmacros.h> */
#define MAKEDEV(major,minor) (((major) << 8) | (minor)) 

int untar(char *path, int infd)
{
  char c;
  int err;
  int outfd;
  
  int isreg, isdir, islnk, isblk, ischr, isfifo;
  unsigned long i, fsize;
  mode_t fmode;
  uid_t fuid;
  gid_t fgid;
  dev_t fdev;
  union TarInfo *tarInfo;	/* 512 bytes */
  int len = sizeof(union TarInfo);
  
  if((tarInfo = malloc((size_t) len)) == NULL)
  {
    perror("malloc(header)");
    exit(1);
  }
  
/* cd to target dir or return 2 */
  if(path)
    if((err=chdir(path)) == -1) 
    {
      perror("Can't chdir()");
      return(2);
    }
  
/* loop till EOF */  
  while(TRUE) {
  isreg=FALSE; isdir=FALSE; islnk=FALSE; isblk=FALSE; ischr=FALSE; isfifo=FALSE;

/* read header or return (3 on short read) */
  err=read(infd,tarInfo,(size_t) len);
  if(err < len) 
  {
#ifdef DEBUG
fprintf(stderr,"Short read(): %d bytes\n",err);
#endif
    if (err == 0) return(0);  /* EOF */
    else return(3);
  }
  
/* set up for extraction */
  if(tarInfo->header.name[0] == '\0') /* EOF or corrupt header */
  {
#ifdef DEBUG
fprintf(stderr,"EOF or corrupt tar header\n");
#endif
    return(0);
  }
    
  fmode=(mode_t)strtol(tarInfo->header.mode,(char **)NULL,8);
  fuid=(uid_t)strtol(tarInfo->header.uid,(char **)NULL,8);
  fgid=(gid_t)strtol(tarInfo->header.gid,(char **)NULL,8);
  fsize=(unsigned long)strtol(tarInfo->header.size,(char **)NULL,8);
  
/* process according to file type */
  switch(tarInfo->header.typeflag) {
  
    case REGTYPE :		/* regular file */
    case AREGTYPE:
      isreg=TRUE;
#ifdef DEBUG
fprintf(stderr,"Processing regular file %s\n",tarInfo->header.name);
#endif
/* create the file or return 4 */
      if((outfd=open(tarInfo->header.name,O_WRONLY|O_CREAT)) == -1)
      {
#ifdef DEBUG
perror("Can't open()");
#endif
        return(4);
      }

/* dump the file, return 5 on short read and 6 on write error */
      for(i=0;i<fsize;i++) {		/* FIXME: dumping 1 byte at a time is stupid */
        if((err=read(infd,&c,(size_t)1)) < 1) 
	{
#ifdef DEBUG
perror("Can't read()");
#endif
	  return(5);
	}
        if((err=write(outfd,&c,(size_t)1)) < 1) 
	{
#ifdef DEBUG
perror("Can't write()");
#endif
	  return(6);
	}
      }
  
      close(outfd);
	
      break;
      
    case LNKTYPE :		/* hardlink */
#ifdef DEBUG
fprintf(stderr,"Processing hard link file %s\n",tarInfo->header.name);
#endif
      err=link(tarInfo->header.linkname,tarInfo->header.name);
#ifdef DEBUG
if (err < 0) {
fprintf(stderr,"Can't link %s to %s\n",tarInfo->header.name,tarInfo->header.linkname);
perror("link()");
return(7);
}
#endif
      break;
    
    case SYMTYPE :		/* symlink */
      islnk = TRUE;
#ifdef DEBUG
fprintf(stderr,"Processing symlink file %s\n",tarInfo->header.name);
#endif
      err=symlink(tarInfo->header.linkname,tarInfo->header.name);
#ifdef DEBUG
if (err < 0) {
fprintf(stderr,"Can't symlink %s to %s\n",tarInfo->header.name,tarInfo->header.linkname);
perror("symlink()");
return(11);
}
#endif
      break;
      
    case CHRTYPE :		/* char device */
    case BLKTYPE :		/* block device */
    case FIFOTYPE:		/* named pipe */
#ifdef DEBUG
fprintf(stderr,"Processing special file %s\n",tarInfo->header.name);
#endif
      fdev=MAKEDEV(strtol(tarInfo->header.devmajor,(char **)NULL,8),
                   strtol(tarInfo->header.devminor,(char **)NULL,8));
      err=mknod(tarInfo->header.name,fmode,fdev);
      break;
     
    case DIRTYPE :		/* directory */
#ifdef DEBUG
fprintf(stderr,"Processing directory %s\n",tarInfo->header.name);
#endif
      err=mkdir(tarInfo->header.name,fmode);
#ifdef DEBUG
if (err < 0) {
fprintf(stderr,"Can't mkdir %s\n",tarInfo->header.name);
perror("mkdir()");
}
#endif
      break;
      
    default:  return(8);	/* huh? */
  }
  
/* chmod and chown it or return 9 and 10 resp */
  if(!islnk)
  {
      if((err=chown(tarInfo->header.name,fuid,fgid)) == -1) 
      {
#ifdef DEBUG
if (err < 0) {
fprintf(stderr,"Can't chown %s\n",tarInfo->header.name);
perror("chown()");
}
#endif
        return(9);
      }
      if((err=chmod(tarInfo->header.name,fmode)) == -1) 
      {
#ifdef DEBUG
if (err < 0) {
fprintf(stderr,"Can't chmod %s\n",tarInfo->header.name);
perror("chmod()");
}
#endif
        return(10);
      }
  }
  
/* skip to the next header */
  if(isreg)
    if(fsize%BLOCKSIZE) 
      read(infd,tarInfo,(BLOCKSIZE*(fsize/BLOCKSIZE+1)-fsize));
//    if(fsize%BLOCKSIZE != 0) 
//      lseek(infd,(off_t)(BLOCKSIZE*(fsize/BLOCKSIZE+1)-fsize),SEEK_CUR);

  } /* end loop */
 
  free(tarInfo); 
}
