/*************************************************************
 *                                                           *
 *    ths  Filesystem                  04.08.94      V0.1    *
 *                                                           *
 *    Thomas Scheuermann     ths@ai-lab.fh-furtwangen.de     *
 *                                                           *
 *************************************************************/

#ifndef _THS_I_H
#define _THS_I_H

struct ths_sb_info
{
	unsigned char SektorenProCluster;
	unsigned char SektorenProFat;
	unsigned char BitsProCluster;
	unsigned short AnzahlCluster;
	unsigned long FatStart;
	unsigned short RootMaxEintraege;
	unsigned long DatenStart;
	unsigned long DatenMax;
	unsigned long RootStart;
	unsigned short *fat[32];
	char art;
	unsigned long uFATStart;
	unsigned long uDatenStart;
	unsigned char uSektorenProCluster;
	unsigned char uBitsProCluster;
	unsigned short uAnzahlCluster;
	unsigned short StartCluster;
	unsigned long BitFATStart;
	unsigned long MDFATStart;
	unsigned long BootStart;
	unsigned short dcluster;
};

struct ths_inode_info
{
	unsigned short Cluster;
	char name[13];
};

struct ths_boot_sektor
{
	char nichts[11];
	unsigned char BytesProSektor[2];
	unsigned char SektorenProCluster;
	unsigned char ReservierteSektoren[2];
	unsigned char AnzahlFats;
	unsigned char EintraegeRootverzeichnis[2];
	unsigned char SektorenImVolume[2];
	unsigned char MediaDescriptor;
	unsigned char SektorenProFat[2];
	unsigned char SektorenProSpur[2];
	unsigned char Koepfe[2];
	unsigned char hidden[4];
	unsigned char SektorenImVolume2[4];
};

struct dbl_boot_sektor
{
	char nichts[11];
	unsigned char BytesProSektor[2];
	unsigned char SektorenProCluster;
	unsigned char ReservierteSektoren[2];
	unsigned char AnzahlFats;
	unsigned char EintraegeRootverzeichnis[2];
	unsigned char SektorenImVolume[2];
	unsigned char MediaDescriptor;
	unsigned char SektorenProFat[2];
	unsigned char SektorenProSpur[2];
	unsigned char Koepfe[2];
	unsigned char hidden[4];
	unsigned char SektorenImVolume2[4];
	unsigned char MDFATStart[2];
	unsigned char log1;
	unsigned char res0[2];
	unsigned char RootDirStart[2];
	unsigned char DatenStart[2];
	unsigned char ClusterStart[2];
	unsigned char BitFATSeiten;
	unsigned char res1[2];
	unsigned char log2;
	unsigned char res2[2];
	unsigned char res3[4];
	unsigned char res4[4];
	unsigned char wFAT;
	unsigned char maxmem[2];
};

struct ths_block
{
	char data[1024];
};

struct ths_dir
{
	unsigned char name[8];
	char endung[3];
	unsigned char attribut;
	unsigned char reserviert[10];
	unsigned char zeit[2];
	unsigned char datum[2];
	unsigned char cluster[2];
	unsigned char laenge[4];
};

struct ths_buffer
{
	unsigned char sektore;
	long bnr[16];
	long sektnr[16];
	int hl[16];
	unsigned char *data[16];
	int dirty;
	unsigned short cluster;
};

#endif
