/*************************************************************
 *                                                           *
 *    ths  Filesystem                  04.08.94      V0.1    *
 *                                                           *
 *    Thomas Scheuermann     ths@ai-lab.fh-furtwangen.de     *
 *                                                           *
 *************************************************************/

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/sched.h>
#include <linux/errno.h>
#include <linux/string.h>
#include <linux/stat.h>
#include <linux/mm.h>
#include <linux/locks.h>
#include <linux/fs.h>
#include <linux/malloc.h>
#include "ths.h"
#include "ths_i.h"


void fatfree(struct super_block *s)
{
	int i;
	struct ths_sb_info *ths_sb;

	ths_sb = (struct ths_sb_info *)s->u.generic_sbp;

#ifdef DEBUG
	printk("fatfree\n");
#endif
/*
 * Speicher der Clusteradressen freigeben
 */

	for(i=0;i<ths_sb->AnzahlCluster+2;)
	{
		kfree_s(ths_sb->fat[i/2048],4096);
		i+=2048;
	}
}

void fatmem2(struct super_block *s)
{
	struct ths_sb_info *ths_sb;
	struct ths_buffer tbf;
	int i,k,t;
	unsigned short cl1,cl2,cluster,addr;
	unsigned char *data=NULL;

	ths_sb = (struct ths_sb_info *)s->u.generic_sbp;

#ifdef DEBUG
	printk("fatmem2\n");
#endif

/*
 * Speicher fuer alle Clusteradressen holen
 */

	for(i=0;i<ths_sb->AnzahlCluster+2;)
	{
		ths_sb->fat[i/2048] = (short *)kmalloc(4096,GFP_KERNEL);
		i+=2048;
	}

#ifdef DEBUG
	printk("Speicher erhalten : %d\n",i);
#endif


/*
 * k	: Nibble-Zaehler
 * addr : Adresse des Speicherblocks
 * i	: Byte vom Clustersektor
 * addr : Adresse im FAT-Speicher = Clusternummer
 */
	t = ths_sb->BitsProCluster/4;
	cl1 = 0;
	cl2 = 0;
	addr = 0;
	k = 0;

	for(i=0,addr=0;addr<(ths_sb->AnzahlCluster+2);)
	{
		if(!(i & 0x1ff))
		{
			if(ths_read_sektor(s,ths_sb->FatStart+(i>>9),&tbf))
			{
				printk("Fehler\n");
				return;
			}
			data = tbf.data[0];
		}
		cl1 = (short)data[i&0x1ff];
		k=(k+1)%t;
		if(!k)
		{
			cluster = (cl2 | ((cl1<<8)&0x0fff));
			(ths_sb->fat[addr/2048])[addr%2048] = cluster;
#ifdef DEBUG
			if(addr>0xb8f && addr<0xc00)
				printk("Cluster :0x%4x folgt 0x%4x\n",addr,cluster);
#endif
			addr++;
		}
		k=(k+1)%t;
		if(!k)
		{
			if(t==3)
			{
				cluster = ((cl2 & 0xf0) >> 4) | (cl1 << 4);
			}
			else
			{
				cluster = cl2 | (cl1 << 8);
			}
			(ths_sb->fat[addr / 2048])[addr % 2048] = cluster;
#ifdef DEBUG
			if(addr>0xb8f && addr<0xc00)
				printk("Cluster :0x%4x folgt 0x%4x\n",addr,cluster);
#endif
			addr++;
		}
		cl2 = cl1;
		i++;
		if(!(i & 0x1ff))
			ths_free_sektor(&tbf);
	}
	if(i & 0x1ff)
		ths_free_sektor(&tbf);
}



