.TH "MSNDCTL" 1 "$Revision: 2.1.0.1 $"
.\"
.\"	Copyright (c) 1994 by Markus Mummert
.\"
.\"	Redistribution and use of this software, modifcation and inclusion
.\"	into other forms of software are permitted provided that the following
.\"	conditions are met:
.\"
.\"	1. Redistributions of this software must retain the above copyright
.\"	   notice, this list of conditions and the following disclaimer.
.\"	2. If this software is redistributed in a modified condition
.\"	   it must reveal clearly that it has been modified.
.\"	
.\"	THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
.\"	AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
.\"	TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
.\"	PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR
.\"	CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
.\"	EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
.\"	PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
.\"	PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
.\"	OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
.\"	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
.\"	USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
.\"	DAMAGE.
.\"
.SH "NAME"
msndctl, rec, play \- control operation of MultiSound audio device, recording and playback
.SH "SYNOPSIS"
.nf
msnd [ options ]
rec [ options ] [ file ]
play [ options ] [ file [ file ... ] ]
.fi
.SH "DESCRIPTION"
\fImsndctl\fP allows to alter the operational parameters of the
device /dev/msnd which accesses the MultiSound/Tahiti soundcard. This can
be done by \fIrec\fP and \fIplay\fP partly too, but in addition these
commands can directly record audio to a file or, respectively, play audio 
from one or more files. For a short discription of options invoke the
command without arguments. The current setting of the operational parameters
will also be shown then.
.PP
A dash \fI-\fP used as option will cause rec and play to use
standard input or, respectively, output instead of file(s).
If invoked with the option \fI-a\fP play can perform continuous
playback by autorewinding to the beginning of the first file in
the argument list after the end of the last file has been reached.
Transitions between end and beginnig of the file(s) are seamless
with respect to the sampling rate. 
.PP
All three commands share (unless stated otherwise) the following options
to alter the operational parameters of the device /dev/msnd. The settings
of these parameters will remain in effect until altered explicitly again:
.IP "-z"
Force initialization of MultiSound hardware. This takes
a delay of a about second and causes a switching noise on `OUT'.
(\fImsndctl\fP only)
.IP "-x\fIllrr\fP"
Set the level of `IN' (main input) to a level of 0x\fIll\fP on the left 
and to a level of 0x\fIrr\fP on the right channel. This
implies initialization as above with the stated drawbacks.
(\fImsndctl\fP only)
.IP "-i\fIllrr\fP"
Same as above for the `AUX' input on the hardware. `AUX' input is mixed
anlog-ically to `OUT'. 
(\fImsndctl\fP only)
.IP "-p\fIn\fP"
Select playback limit of \fIn\fP bytes. Only this many bytes
from the file(s) being read will be chosen for playback. If
If \fIn\fP is zero there will be no limit at all.
(not \fIrec\fP)
.IP "-r\fIn\fP"
Select recording limit of \fIn\fP bytes. Only this many bytes
will be recorded to the file.
\fIn\fP is zero there will be no limit at all.
(not \fIplay\fP)
.IP "-1 -2 -4"
Set sampling rate to 11.025, 22.05 or 44.1kHz respectively.
.IP "-m -s"
Select mono or stereo.
.IP "-h -l"
Set sample format to highbyte,lowbyte (Motorla, big-endian)
or lowbyte,highbyte (Intel, little-endian).
.IP "-f -q"
Select feed `IN'-to-`OUT' or silence, when recording or playback
has finished. In the first case this means that one can monitor
the input without actually using the device. Obviously
the AD- and DA-converters are connected digitally then (This is
also always the case while recording, but never the case while
playing.) To select silence is BEST choice on playback,
because then there will be no switching noise when beginning and
ending to play.
.SH "CAVEATS"
\fIPlay\fP, \fIrec\fP and \fImsndctl\fP are links to the same executable.
The function is determined by analyzing argv[0]. Don't change names
and don't invoke by full path, like for example /usr/local/bin/play.
.SH "FILES"
/dev/msnd
.SH "SEE ALSO"
msnd(7)
.SH "COPYRIGHT"
Copyright (C) 1994-1995 by Markus Mummert
.PP
See the file \fICOPYING\fP (distributed with the source code)
for policy.




