/* 
 * Motif Tools Library, Version 2.0
 * $Id: Initialize.c,v 1.5 1994/07/04 03:03:50 david Exp $
 * 
 * Written by David Flanagan.
 * Copyright (c) 1992, 1993, 1994 by Dovetail Systems.
 * All Rights Reserved.  See the file COPYRIGHT for details.
 * This is not free software.  See the file SHAREWARE for details.
 * There is no warranty for this software.  See NO_WARRANTY for details.
 */


/*
 * Some of the code in this file is derived from the Xt sources:
 * Xt/Initialize.c and Xt/Display.c
 */

#include <Xmt/Xmt.h>
#include <Xmt/AppRes.h>
#include <Xmt/Converters.h>
#include <Xmt/Layout.h>

#if NeedFunctionPrototypes
Widget XmtInitialize(XtAppContext *app_context_return,
		     String application_class,
		     XrmOptionDescList options, Cardinal num_options,
		     int *argc_in_out, String *argv_in_out,
		     String *fallback_resources,
		     ArgList args, Cardinal num_args)
#else
Widget XmtInitialize(app_context_return, application_class,
		     options, num_options, argc_in_out, argv_in_out,
		     fallback_resources, args, num_args)
XtAppContext *app_context_return;
String application_class;
XrmOptionDescList options;
Cardinal num_options;
int *argc_in_out;
String *argv_in_out;
String *fallback_resources;
ArgList args;
Cardinal num_args;
#endif
{
    Widget root;

    /*
     * Initialize Xt and create the root shell widget.
     */
    root = XtAppInitialize(app_context_return,
			   application_class,
			   options, num_options,
			   argc_in_out, argv_in_out,
			   fallback_resources,
			   args, num_args);

    /*
     * parse Xmt-specific command-line options
     */
    XmtParseCommandLine(root, argc_in_out, argv_in_out);

    /*
     * register some type converters.
     * We do this now so we can convert
     * Xmt application resources read below.
     */
    XmtRegisterPixelConverter();
    XmtRegisterBitmapConverter();
    XmtRegisterBitmaskConverter();
    XmtRegisterPixmapConverter();
    XmtRegisterColorTableConverter();
    XmtRegisterWidgetConverter();
    XmtRegisterCallbackConverter();
    XmtRegisterXmStringConverter(); 
    XmtRegisterXmFontListConverter();
    XmtRegisterStringListConverter();
    XmtRegisterMenuItemsConverter();
    XmtRegisterPixmapListConverter();

    /*
     * These aren't strictly type converters, but
     * the idea is the same.
     */
    XmtRegisterLayoutParser();
    XmtRegisterLayoutCreateMethod();

    /*
     * Now register the shell, and look up the app-resources
     * (and do app-resource-related initialization.)
     */
    XmtInitializeApplicationShell(root, args, num_args);

    return(root);
}
