/* $Id: isdnrep.c,v 2.02 1996/01/10  20:10:17  sl Exp sl $
 *
 * ISDN accounting for isdn4linux. (Report-module)
 *
 * Copyright 1995, 1996 by Andreas Kool (akool@Kool.f.EUnet.de),
 *                         Stefan Luethje (luethje@konstanz.netsurf.de)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Log: isdnrep.c,v $
 * Revision 2.02  1996/01/10  20:10:17  sl
 * Zeitraumausgabe angepasst, loeschen von isdn.log-Eintraegen
 *
 * Revision 2.01  1996/01/06  18:15:20  sl
 * Zeitraumausgabe, nur Calls-Anzeige, optionales Logfile
 *
 * Revision 2.00  1996/01/01  17:50:19  akool
 * Auswertung der neuen Eintraege (I/O, Cause) implementiert
 * Vollstaendiges Redesign
 *
 * Revision 1.25  1995/11/19  09:56:19  akool
 * Neue Option "-c" aktiviert die eigene Berechnung der Einheiten bei
 *   fehlender Gebuehreninfo
 *
 * Revision 1.24  1995/11/12  11:09:19  akool
 * Formatfelder vergroessert
 * Fremdverursachte Einheiten werden ge-()
 * Alle Floating-Point-Zahlen werden deutsch (mit Komma) ausgegeben
 *
 * Revision 1.23  1995/11/06  18:04:19  akool
 * Denkfehler in der "-6" Berechnung :-(
 *
 * Revision 1.22  1995/10/22  15:31:19  akool
 * Aufschluesselung bach Tarifzonen implementiert
 *
 * Revision 1.21  1995/10/17  19:53:19  akool
 * Auf echte Charging-Info umgestellt
 *
 * Revision 1.20  1995/10/15  17:58:19  akool
 * Vergleich errechnete zu uebermittelten Einheiten implementiert
 *
 * Revision 1.16  1995/10/12  13:50:19  akool
 * Neue Option "MYMSNS=x" in der "isdnlog.conf" zum definieren der Anzahl
 * eigener MSN's
 *
 * Revision 1.15  1995/10/09  18:42:18  akool
 * Offensichtlich sinnlose Daten i.d. "isdn.log" werden nun ignoriert
 *
 * Revision 1.14  1995/10/08  10:25:16  akool
 * Ueberschreitung verschiedener Zeittakte bei einer Verbindung implementiert.
 *
 * Revision 1.6  1995/09/30  19:55:17  akool
 * First public release
 *
 * Revision 1.1  1995/09/23  16:44:19  akool
 * Initial revision
 *
 */


#define  PUBLIC extern
#define END_TIME		1

#include "isdnlog.h"

time_t get_month(char *String, int TimeStatus);
time_t get_time(char *String, int TimeStatus);
int get_term (char *String, time_t *Begin, time_t *End);

typedef struct {
  char   num[NUMSIZE];
  int	 called;
  int	 connects;
  time_t connect[MAXCONNECTS];
} UNKNOWN;


static int      unknowns = 0;
static UNKNOWN  unknown[MAXUNKNOWN];
static int  	zones[MAXZONES];
static int  	zones_usage[MAXZONES];
static double  	zones_dm[MAXZONES];
static double  	zones_dur[MAXZONES];


static char msg1[]    = "%s: Can't open %s (errno=%d)\n";
static char usage[]   = "%s: usage: %s [ -%s ]\n";
static char wrongdate[]   = "unknown date: %s\n";
static char wrongdate2[]   = "wrong date for delete: %s\n";

static char options[] = "ancv6t:f:d:";
static char fnbuff[512];
static char *lfnam = LOGFILE;

static int  delentries = 0;


int main(int argc, char *argv[], char *envp[])
{
  register char      *p, *p1, *p2;
  register int	      i, k, n;
  auto     FILE      *fi, *ftmp = NULL;
  auto     char       string[BUFSIZ], s[BUFSIZ], s1[BUFSIZ], num[2][20];
  auto	   char	      start[20], stop[20], timestring[256] = "";
  auto	   char	      tmpfile[256];
  auto	   int	      hit, lday = -1, eh, ehs = 0;
  auto	   int	      ehss = 0;
  auto	   double     duration, restdm = 0.0;
  auto	   int	      ins = 0, inss = 0, outs = 0, outss = 0;
  auto	   int	      ers = 0, erss = 0, computed;
  extern   int        errno;
  auto	   time_t     t, now, from = (time_t)0;
  auto	   time_t     begintime, endtime;
  auto	   double     t1, t2, takt;
  auto 	   struct tm *tm;
  auto	   double     dm, dms = 0.0, dmss = 0.0, einheit = 0.23;
  auto	   double     dins = 0.0, dinss = 0.0, douts = 0.0, doutss = 0.0;
  auto	   int	      nx[2], dir, cause = 0;
  auto	   int 	      Tarif96 = 0, Tarif962 = 0, c, notforus, resteh = 0;
  auto	   double     restdur = 0.0, restidur = 0.0;
  auto	   int	      all = 0, numbers = 0, new = 0, restusage = 0;
  auto	   int	      restiusage = 0;
  auto	   int        compute = 0;
  auto	   int        verbose = 0;


  while ((c = getopt(argc, argv, options)) != EOF)
    switch (c) {
      case 'a' : all++;
      	       	 break;

      case 'n' : numbers++;
      	       	 break;

      case 'd' : strcpy(timestring, optarg);
								 delentries++;

      case 't' : strcpy(timestring, optarg);
								 if (!get_term(timestring,&begintime,&endtime))
								 {
									fprintf(stderr, wrongdate, timestring);
									return 1;
								 }
                 break;

      case 'c' : compute++;
      	       	 break;

      case 'v' : verbose++;
      	       	 break;

      case '6' : new++;
      	       	 break;

      case 'f' : strcpy(fnbuff, optarg);
                 lfnam = fnbuff;
                 break;

      case '?' : fprintf(stderr, usage, argv[0], argv[0], options);
	         return(1);
    } /* switch */

	if (delentries)
		if(begintime)
		{
			fprintf(stderr, wrongdate2, timestring);
			return 1;
		}
		else
		{
			sprintf(tmpfile,"/tmp/isdnrep%d",getpid());

  		if ((ftmp = fopen(tmpfile, "w")) == (FILE *)NULL)
		  {
		    fprintf(stderr, msg1, tmpfile, errno);
		    return(1);
		  }
		}

  if (!all) { /* from darf nicht gesetzt werden, wenn alle Telefonate angezeigt werden sollen */
    time(&now);
    	/* aktuelle Zeit wird gesetzt */
    tm = localtime(&now);
    	/* Zeit von 1970 nach Struktur */
    tm->tm_sec = tm->tm_min = tm->tm_hour = 0;
    from = mktime(tm);
    	/* Struktur nach Zeit von 1970 */
    	/* from hat den aktuellen Tag 0.00 Uhr */
  } /* if */

	if ((fi = fopen(lfnam, "r")) != (FILE *)NULL){

    readconfig(argv[0]);

    memset(zones, 0, sizeof(zones));

    *start = 0;

    while (fgets(s, BUFSIZ, fi)) {
      strcpy(string,s);

      if ((*s != '#') && (p = strchr(s, '|'))) {
      /* hier wird das erste Trennzeichen gesucht */

      	eh = notforus = 0;
        dir = -1;
        	/* Zeigt die Gespraechsrichtung an: rein oder raus */

     	if ((p1 = p2 = strchr(p + 1, '|'))) {
          do {
            *p1-- = 0; /* p1 ist Zaehler fuer Anrufer */
          } while (isspace(*p1));

       	  strcpy(num[0], p + 1);
       	  	/* num[0] enthaelt die Anrufernummer */

       	  p = p2 + 1;

          if ((p1 = p2 = strchr(p, '|'))) {

            do {
              *p1-- = 0;
            } while (isspace(*p1));

            strcpy(num[1], p);
            	/* num[1] enthaelt die angerufende Nummer */

            p = p2 + 1;

            duration = (double)atoi(p);
              /* Gespraechsdauer auf sek. */

            if ((p1 = p2 = strchr(p, '|'))) {
              p = p2 + 1;
              duration = atoi(p) / 100.0;
              	/* Gespraechsdauer auf 100stel sek. */

              if ((p1 = p2 = strchr(p, '|'))) {
                p = p2 + 1;
                t = atol(p);
                	/* t ist Zeit seit 1970 von Gespraechsende ? */
              	if ((p1 = p2 = strchr(p, '|'))) { /* Gebuehrenimpuls */
                  p = p2 + 1;
                  eh = atoi(p);
                  	/* Verbrauchte Einheiten (-1 ist keine Angabe ?) */

              	  if ((p1 = p2 = strchr(p, '|'))) { /* I/O */
                    p = p2 + 1;
                    dir = (*p == 'I') ? DIALIN : DIALOUT;
              	    if ((p1 = p2 = strchr(p, '|'))) { /* Cause */
                      p = p2 + 1;
            	      cause = atoi(p);
                    } /* if */
              	  } /* if */
                } /* if */
              }
              else
                t = atom(s);
                	/* Umrechnung des ersten Teilstring in Zeit von 1970 */
            }
            else
              t = atom(s);
               	/* Umrechnung des ersten Teilstring in Zeit von 1970 */


						if (timestring[0] != '\0')
						{
							if (delentries)
								if (t > endtime)
									fputs(string,ftmp);
								else
									continue;

							if (t < begintime || t > endtime)
								continue;
						}
						else
            if (t < from)
              continue; /* Einlesen des naechsten Telefonats */

						if (!verbose && duration == 0)
								continue;

            tm = localtime(&t);
    					/* Zeit von 1970 nach Struktur */
            day = tm->tm_mday;
            month = tm->tm_mon;

            Tarif96 = tm->tm_year > 95;

            /* Ab Juli '96 gibt's noch mal eine Senkung in den Zonen 3 und 4
               genaue Preise sind jedoch noch nicht bekannt. FIX-ME */

            Tarif962 = Tarif96 && (tm->tm_mon > 5);

            if (new) /* wenn new immer Tarif96 */
              Tarif96 = 1;

            einheit = Tarif96 ? 0.12 : 0.23;

            if (duration > 172800.0) /* laenger als 2 Tage? Das KANN nicht sein! */
              duration = 0;


            for (n = CALLING; n <= CALLED; n++) {

              nx[n] = -1;
              hit = 0;

              if (!*num[n]) {
                if (!numbers)
                  strcpy(num[n], "UNKNOWN");
                    /* Wenn keine Nummer, dann Name "UNKNOWN" */

                hit++;
              }
              else {
								/* In der folg. Schleife werden Nummern durch Namen ersetzt */
                for (i = 0; i < knowns; i++) {
                  if (match(num[n], known[i]->num)) {

                    if (!numbers)
                      strcpy(num[n], known[i]->who);

                    nx[n] = i;

                    known[i]->usage[dir]++;
                    	/* Gesamte Anrufe auf gleiche Nummern werden gezeahlt */
                    known[i]->dur[dir] += duration;
                    	/* Gesamte Gespraechsdauer auf gleiche Nummern wird gezeahlt */

                    hit++;
                    break;
                  } /* if */

                } /* for */

								/* In der naechsten Schleife werden die unbekannten Nummern
		   						 registriert */
              	if (!hit) {
                  for (i = 0; i < unknowns; i++)
                    if (!strcmp(unknown[i].num, num[n])) {
                      hit++;
                      break;
                    } /* if */

                  strcpy(unknown[i].num, num[n]);
                  unknown[i].called = !n;
                  unknown[i].connect[unknown[i].connects] = t;

									/* ACHTUNG: MAXCONNECTS und MAXUNKNOWN sollten unbedingt groesser sein ! */
                  if (unknown[i].connects + 1 < MAXCONNECTS)
                    unknown[i].connects++;
                  else
                    fprintf(stderr, "%s: WARNING: Too many unknown connection's from %s\n", argv[0], unknown[i].num);

                  if (!hit) {
                    if (unknowns < MAXUNKNOWN)
                      unknowns++;
                    else
                      fprintf(stderr, "%s: WARNING: Too many unknown number's\n", argv[0]);
                  } /* if */

                } /* if */
              } /* else */
            } /* for */


            strcpy(s1, ctime(&t));

            if ((p = strchr(s1, '\n')))
              *p = 0;

            if (day != lday) {
              if (lday == -1) {
                time(&now);
                printf("I S D N  Connection Report  -  %s", ctime(&now));
              }
              else {
								printf("-------------------------------------------------------------------------\n");
                printf("%3d IN=%s, %3d OUT=%s, %3d failed     %7d EH  %s DM",
                  ins,
                  double2clock(dins),
                  outs,
                  double2clock(douts),
                  ers,
                  ehs, double2str(dms, 8, 2, 0));

                dmss += dms;
                dms = 0;

                ehss += ehs;
                ehs = 0;

                dinss += dins;
                dins = 0.0;

                doutss += douts;
                douts = 0.0;

                inss += ins;
                ins = 0;

                outss += outs;
                outs = 0;

                erss += ers;
                ers = 0;

              } /* if */

              *(s1 + 10) = 0;
              printf("\n\n%s %s\n", s1, s1 + 20);
              lday = day;

              if (!*start)
                sprintf(start, "%s %s", s1, s1 + 20);
	      			else
                sprintf(stop, "%s %s", s1, s1 + 20);

            } /* if */


            *(s1 + 19) = 0;

            printf("  %s %s",
              s1 + 11,
              double2clock(duration));

            if (dir)
              printf(" %14s <- %-14s",
	        			num[CALLED], num[CALLING]);
            else
              printf(" %14s -> %-14s",
	        			num[CALLING], num[CALLED]);

            computed = 0;

            if (!dir && ((eh == -1) || (!eh && duration))) { /* DIALOUT, keine AOCE Meldung */
              t1 = t;
              t2 = t + duration;

              eh = takt = 0;
              computed = 1;

              while (t1 < t2) {
                if (Tarif96)
                  takt = cheap96((time_t)t1, (nx[1] == -1) ? 4 : known[nx[1]]->zone);
                else
                  takt = cheap((time_t)t1, (nx[1] == -1) ? 4 : known[nx[1]]->zone);

                if (!takt) {
                  fprintf(stderr, "%s: OOPS! Abbruch: Zeittakt==0 ???\n", argv[0]);
                  break;
                } /* if */

                eh++;
                t1 += takt;

              } /* while */
            } /* if */

            if (duration || (eh > 0)) {
              if (dir) {
                if (duration > 0)
                  dins += duration;

                ins++;

                if (nx[CALLING] == -1) {
                  restiusage++;

                  if (duration > 0)
                    restidur += duration;
                } /* if */
              }
              else {

                dm = eh * einheit;
	    	dms += dm;

                ehs += eh;

                if (nx[CALLED] == -1) {
                  resteh += eh;
                  restdm += dm;
                  restusage++;

                  if (duration > 0)
                    restdur += duration;
                }
                else {
                  known[nx[CALLED]]->eh += eh;
                  known[nx[CALLED]]->dm += dm;

                  zones[known[nx[CALLED]]->zone] += eh;
                  zones_dm[known[nx[CALLED]]->zone] += dm;

                  if (duration > 0)
                    zones_dur[known[nx[CALLED]]->zone] += duration;

                  zones_usage[known[nx[CALLED]]->zone]++;
                } /* if */

                if (duration > 0)
                  douts += duration;

                outs++;

                printf(" %4d EH  %s DM",
                  eh, double2str(dm, 8, 2, 0));

                if (computed)
                  printf(" *");
              } /* else */
            }
            else {
              printf(" %s", CauseValue[cause]);
              ers++;
            } /* else */


            printf("\n");
          } /* if */
        } /* if */
      } /* if */
    } /* while */

    fclose(fi);

		if (delentries) /* Erzeugt neue verkuerzte Datei */
			lday = -1;

    if (lday != -1) {

      if (all) {
        printf("-------------------------------------------------------------------------\n");
        printf("%3d IN=%s, %3d OUT=%s, %3d failed     %7d EH  %s DM\n\n",
          ins,
          double2clock(dins),
          outs,
          double2clock(douts),
          ers,
          ehs, double2str(dms, 8, 2, 0));
      } /* if */

      dmss += dms;
      ehss += ehs;
      dinss += dins;
      doutss += douts;
      inss += ins;
      outss += outs;
      erss += ers;

      printf("=========================================================================\n");
      printf("%3d IN=%s, %3d OUT=%s, %3d failed     %7d EH  %s DM\n\n",
        inss,
        double2clock(dinss),
        outss,
        double2clock(doutss),
        erss,
        ehss, double2str(dmss, 8, 2, 0));

      if (all)
        printf("\nDIALOUT Summary for %s .. %s\n", start, stop);
      else
        printf("\nDIALOUT Summary for %s\n", start);
      printf("-----------------------------------------------------------\n");

      for (i = mymsns; i < knowns; i++) {
        if (known[i]->usage[DIALOUT]) {
          printf("%-14s %3d call(s) %s  %4d EH %s DM\n",
            known[i]->who,
            known[i]->usage[DIALOUT],
            double2clock(known[i]->dur[DIALOUT]),
            known[i]->eh,
            double2str(known[i]->dm, 7, 2, 0));
        } /* if */
      } /* for */

      if (restusage) {
        printf("%-14s %3d call(s) %s  %4d EH %s DM\n",
          "UNKNOWN",
          restusage,
          double2clock(restdur),
          resteh,
          double2str(restdm, 7, 2, 0));
      } /* if */

      printf("\n");

      if (all)
        printf("\nDIALIN Summary for %s .. %s\n", start, stop);
      else
        printf("\nDIALIN Summary for %s\n", start);
      printf("-----------------------------------------------------------\n");

      for (i = mymsns; i < knowns; i++) {
        if (known[i]->usage[DIALIN]) {
          printf("%-14s %3d call(s) %s\n",
            known[i]->who,
            known[i]->usage[DIALIN],
            double2clock(known[i]->dur[CALLED]));
        } /* if */
      } /* for */

      if (restiusage) {
        printf("%-14s %3d call(s) %s\n",
          "UNKNOWN",
          restiusage,
          double2clock(restidur));
      } /* if */

      printf("\n\n");

      for (i = 1; i < MAXZONES; i++)
        if (zones[i]) {

          p = "";

          switch (i) {
            case 1 : p = "City";       break;
            case 2 : p = "Region 50";  break;
            case 3 : p = "Region 200"; break;
            case 4 : p = "Fernzone";   break;
          } /* switch */

          printf("Zone %d : %-15s %3d call(s) %s  %5d EH %s DM\n", i, p,
            zones_usage[i],
            double2clock(zones_dur[i]),
            zones[i],
            double2str(zones_dm[i], 7, 2, 0));
        } /* if */

      if (resteh)
        printf("Zone x : %-15s %d call(s) %s  %5d EH %s DM\n", "UNKNOWN",
          restusage,
          double2clock(restdur),
          resteh,
          double2str(resteh * einheit, 7, 2, 0));


      if (unknowns) {
        printf("\n\nUnknown caller(s)\n");
      	printf("-----------------------------------------------------------\n");

        for (i = 0; i < unknowns; i++) {

          printf("%s %-14s ", unknown[i].called ? "called by" : "  calling", unknown[i].num);

          for (k = 0; k < unknown[i].connects; k++) {
            strcpy(s1, ctime(&unknown[i].connect[k]));

            if ((p = strchr(s1, '\n')))
              *p = 0;

            *(s1 + 19) = 0;

            if (k && (k + 1) % 2) {
              printf("\n\t\t\t ");
            } /* if */

            printf("%s%s", k & 1 ? ", " : "", s1 + 4);
          } /* for */

          printf("\n");
        } /* for */
      } /* if */
    } /* if */
  }
  else {
    fprintf(stderr, msg1, argv[0], lfnam, errno);
    return(1);
  } /* else */


	if (delentries) /* Erzeugt neue verkuerzte Datei */
	{
		fclose(ftmp);

 		if ((ftmp = fopen(tmpfile, "r")) == (FILE *)NULL)
	  {
	    fprintf(stderr, msg1, tmpfile, errno);
	    return(1);
	  }
 		if ((fi = fopen(lfnam, "w")) == (FILE *)NULL)
	  {
	    fprintf(stderr, msg1, lfnam, errno);
	    return(1);
	  }

	  while (fgets(s, BUFSIZ, ftmp))
			fputs(s,fi);

		fclose(fi);
		fclose(ftmp);

		unlink(tmpfile);
	}

  return(0);
} /* main */

int get_term (char *String, time_t *Begin, time_t *End)
{
	time_t now;
	time_t  Date[2];
	int Cnt;
	char DateStr[2][256] = {"",""};


	time(&now);

	if (String[0] == '-')
		strcpy(DateStr[1],String+1);
	else
	if (String[strlen(String)-1] == '-')
	{
		strcpy(DateStr[0],String);
		DateStr[0][strlen(String)-1] ='\0';
	}
	else
	if (strchr(String,'-'))
	{
		if (sscanf(String,"%[/.0-9]-%[/.0-9]",DateStr[0],DateStr[1]) != 2)
			return 0;
	}
	else
	{
		strcpy(DateStr[0],String);
		strcpy(DateStr[1],String);
	}

	for (Cnt = 0; Cnt < 2; Cnt++)
	{
		if (strchr(DateStr[Cnt],'/'))
			Date[Cnt] = get_month(DateStr[Cnt],delentries?0:Cnt);
		else
			Date[Cnt] = get_time(DateStr[Cnt],delentries?0:Cnt);
	}

	*Begin = DateStr[0][0] == '\0' ? 0 : Date[0];
	*End = DateStr[1][0] == '\0' ? now : Date[1];

	return 1;
}

time_t get_month(char *String, int TimeStatus)
{
	time_t now;
	int Cnt = 0;
	struct tm *TimeStruct;
	int Args[3];
	int ArgCnt;


	time(&now);
	TimeStruct = localtime(&now);
	TimeStruct->tm_sec = 0;
	TimeStruct->tm_min = 0;
	TimeStruct->tm_hour= 0;
	TimeStruct->tm_mday= 1;
	TimeStruct->tm_isdst= -1;

	ArgCnt = sscanf(String,"%d/%d/%d",&(Args[0]),&(Args[1]),&(Args[2]));

	switch (ArgCnt)
	{
		case 3:
			TimeStruct->tm_mday = Args[0];
			Cnt++;
		case 2:
			if (Args[Cnt+1] > 99)
				TimeStruct->tm_year = ((Args[Cnt+1] / 100) - 19) * 100 + (Args[Cnt+1]%100);
			else
				TimeStruct->tm_year = Args[Cnt+1];
		case 1:
			TimeStruct->tm_mon = Args[Cnt];
			break;
		default:
			return 0;
	}

	if (TimeStatus == END_TIME)
	{
		if (ArgCnt == 3)	/* Wenn Tag angegeben ist */
		{
			TimeStruct->tm_mday++;
			TimeStruct->tm_mon--;
		}
	}
	else
			TimeStruct->tm_mon--;

	return mktime(TimeStruct);
}

time_t get_time(char *String, int TimeStatus)
{
	time_t now;
	int Len = 0;
	int Year;
	char *Ptr;
	struct tm *TimeStruct;


	time(&now);
	TimeStruct = localtime(&now);
	TimeStruct->tm_sec = 0;
	TimeStruct->tm_min = 0;
	TimeStruct->tm_hour= 0;
	TimeStruct->tm_isdst= -1;

	switch (strlen(String))
	{
		case 0:
			return 0;
		case 1:
		case 2:
			TimeStruct->tm_mday = atoi(String);
			break;
		default:
			Len = strlen(String);

			if ((Ptr = strchr(String,'.')) != NULL)
			{
				TimeStruct->tm_sec = atoi(Ptr+1);
				Len -= strlen(Ptr);
			}

			if (Len % 2)
				return 0;

			if (sscanf(String,"%2d%2d%2d%2d%d",
				&(TimeStruct->tm_mon),
				&(TimeStruct->tm_mday),
				&(TimeStruct->tm_hour),
				&(TimeStruct->tm_min),
				&Year		) 		> 4)
				if (Year > 99)
					TimeStruct->tm_year = ((Year / 100) - 19) * 100 + (Year%100);
				else
					TimeStruct->tm_year = Year;

			TimeStruct->tm_mon--;
			break;
	}

	if (TimeStatus == END_TIME)
		if (TimeStruct->tm_sec == 0 &&
				TimeStruct->tm_min == 0 &&
				TimeStruct->tm_hour== 0   )
			TimeStruct->tm_mday++;
		else
		if (TimeStruct->tm_sec == 0 &&
				TimeStruct->tm_min == 0   )
			TimeStruct->tm_hour++;
		else
		if (TimeStruct->tm_sec == 0   )
			TimeStruct->tm_min++;
		else
			TimeStruct->tm_sec++;

	return mktime(TimeStruct);
}
