/*
 * Copyright (c) 1988, 1989, 1990, 1991, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef lint
static char rcsid[] =
    "@(#) $Header: print-icmp.c,v 1.20 94/06/14 20:17:39 leres Exp $ (LBL)";
#endif

#include <sys/param.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>

#include <net/if.h>

#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <netinet/in_systm.h>
#if defined(__GNUC__)&&defined(__osf__)&&defined(__STDC__)&&(__STDC__==1)
#define __STDC__	0	/* force bit fields declaration */
#endif
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/ip_var.h>
#include <netinet/udp.h>
#include <netinet/udp_var.h>
#include <netinet/tcp.h>
#include <netinet/tcpip.h>

#include <stdio.h>

#include "interface.h"
#include "addrtoname.h"

#ifndef ICMP_ROUTERADVERT
#define ICMP_ROUTERADVERT	9
#endif
#ifndef ICMP_ROUTERSOLICIT
#define ICMP_ROUTERSOLICIT	10
#endif
#ifndef ICMP_UNREACH_NET_UNKNOWN
#define ICMP_UNREACH_NET_UNKNOWN	6
#endif
#ifndef ICMP_UNREACH_HOST_UNKNOWN
#define ICMP_UNREACH_HOST_UNKNOWN	7
#endif
#ifndef ICMP_UNREACH_ISOLATED
#define ICMP_UNREACH_ISOLATED		8
#endif
#ifndef ICMP_UNREACH_NET_PROHIB
#define ICMP_UNREACH_NET_PROHIB		9
#endif
#ifndef ICMP_UNREACH_HOST_PROHIB
#define ICMP_UNREACH_HOST_PROHIB	10
#endif
#ifndef ICMP_UNREACH_TOSNET
#define ICMP_UNREACH_TOSNET		11
#endif
#ifndef ICMP_UNREACH_TOSHOST
#define ICMP_UNREACH_TOSHOST		12
#endif

void
icmp_print(register const u_char *bp, register const u_char *bp2)
{
	register const struct icmp *dp;
	register const struct ip *ip;
	register const char *str;
	register const struct ip *oip;
	register const struct udphdr *ouh;
	register int hlen, dport;
	register const u_char *ep;
	int hasnextip = 0;

#define TCHECK(var, l) if ((u_char *)&(var) > ep - l) goto trunc

	dp = (struct icmp *)bp;
	ip = (struct ip *)bp2;
	/* 'ep' points to the end of avaible data. */
	ep = snapend;

        (void)printf("%s > %s: ",
		ipaddr_string(&ip->ip_src),
		ipaddr_string(&ip->ip_dst));

	TCHECK(dp->icmp_code, sizeof(dp->icmp_code));
	(void)printf("icmp: ");
	switch (dp->icmp_type) {
	case ICMP_ECHOREPLY:
		if (vflag) {
			TCHECK(dp->icmp_void, sizeof(dp->icmp_void));
			(void)printf("echo reply %d/%d",
				     dp->icmp_id, dp->icmp_seq);
		} else
			fputs("echo reply", stdout);
		break;
	case ICMP_UNREACH:
		TCHECK(dp->icmp_ip.ip_dst, sizeof(dp->icmp_ip.ip_dst));
		switch (dp->icmp_code) {
		case ICMP_UNREACH_NET:
			(void)printf("net %s unreachable",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		case ICMP_UNREACH_HOST:
			(void)printf("host %s unreachable",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		case ICMP_UNREACH_PROTOCOL:
			TCHECK(dp->icmp_ip.ip_p, sizeof(dp->icmp_ip.ip_p));
			(void)printf("%s protocol %d unreachable",
				     ipaddr_string(&dp->icmp_ip.ip_dst),
				     dp->icmp_ip.ip_p);
			break;
		case ICMP_UNREACH_PORT:
			TCHECK(dp->icmp_ip.ip_p, sizeof(dp->icmp_ip.ip_p));
			oip = &dp->icmp_ip;
			hlen = oip->ip_hl * 4;
			ouh = (struct udphdr *)(((u_char *)oip) + hlen);
			dport = ntohs(ouh->uh_dport);
			switch (oip->ip_p) {
			case IPPROTO_TCP:
				(void)printf("%s tcp port %s unreachable",
					     ipaddr_string(&oip->ip_dst),
					     tcpport_string(dport));
				break;
			case IPPROTO_UDP:
				(void)printf("%s udp port %s unreachable",
					     ipaddr_string(&oip->ip_dst),
					     udpport_string(dport));
				break;
			default:
				(void)printf("%s protocol %d port %d unreachable",
					     ipaddr_string(&oip->ip_dst),
					     oip->ip_p, dport);
				break;
			}
			break;
		case ICMP_UNREACH_NEEDFRAG:
			if (vflag) {
				TCHECK(dp->icmp_void, sizeof(dp->icmp_void));
				(void)printf(
					"%s unreachable - need to frag to %d",
					ipaddr_string(&dp->icmp_ip.ip_dst),
#ifndef icmp_nextmtu
#define icmp_nextmtu icmp_seq
#endif
				      ntohs(dp->icmp_nextmtu));
			} else
				(void)printf("%s unreachable - need to frag",
					ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		case ICMP_UNREACH_SRCFAIL:
			(void)printf("%s unreachable - source route failed",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		case ICMP_UNREACH_NET_UNKNOWN:
			(void)printf("net %s unknown",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		case ICMP_UNREACH_HOST_UNKNOWN:
			(void)printf("host %s unknown",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
                        break;
		case ICMP_UNREACH_ISOLATED:
			(void)printf("host %s isolated",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		case ICMP_UNREACH_NET_PROHIB:
			(void)printf("net %s prohibited",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
                        break;
		case ICMP_UNREACH_HOST_PROHIB:
			(void)printf("host %s prohibited",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
                        break;
		case ICMP_UNREACH_TOSNET:
			(void)printf("net %s unreachable for TOS",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		case ICMP_UNREACH_TOSHOST:
			(void)printf("host %s unreachable for TOS",
                                     ipaddr_string(&dp->icmp_ip.ip_dst));
                        break;
		}
		hasnextip = 1;
		break;
	case ICMP_SOURCEQUENCH:
		TCHECK(dp->icmp_ip.ip_dst, sizeof(dp->icmp_ip.ip_dst));
		(void)printf("source quench %s",
			     ipaddr_string(&dp->icmp_ip.ip_dst));
		hasnextip = 1;
		break;
	case ICMP_REDIRECT:
		TCHECK(dp->icmp_ip.ip_dst, sizeof(dp->icmp_ip.ip_dst));
		switch (dp->icmp_code) {
		case ICMP_REDIRECT_NET:
			(void)printf("redirect %s to net %s",
				     ipaddr_string(&dp->icmp_ip.ip_dst),
				     ipaddr_string(&dp->icmp_gwaddr));
			break;
		case ICMP_REDIRECT_HOST:
			(void)printf("redirect %s to host %s",
				     ipaddr_string(&dp->icmp_ip.ip_dst),
				     ipaddr_string(&dp->icmp_gwaddr));
			break;
		case ICMP_REDIRECT_TOSNET:
			(void)printf("redirect-tos %s to net %s",
				     ipaddr_string(&dp->icmp_ip.ip_dst),
				     ipaddr_string(&dp->icmp_gwaddr));
			break;
		case ICMP_REDIRECT_TOSHOST:
			(void)printf("redirect-tos %s to host %s",
				     ipaddr_string(&dp->icmp_ip.ip_dst),
				     ipaddr_string(&dp->icmp_gwaddr));
			break;
		}
		hasnextip = 1;
		break;
	case ICMP_ECHO:
		if (vflag) {
			TCHECK(dp->icmp_void, sizeof(dp->icmp_void));
			(void)printf("echo request %d/%d",
				     dp->icmp_id, dp->icmp_seq);
		} else
			fputs("echo request", stdout);
		break;
	case ICMP_ROUTERADVERT:
		fputs("router advertisement", stdout);
		break;
	case ICMP_ROUTERSOLICIT:
		fputs("router solicitation", stdout);
		break;
	case ICMP_TIMXCEED:
		TCHECK(dp->icmp_ip.ip_dst, sizeof(dp->icmp_ip.ip_dst));
		switch (dp->icmp_code) {
		case ICMP_TIMXCEED_INTRANS:
			(void)printf("time exceeded in-transit for %s",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		case ICMP_TIMXCEED_REASS:
			(void)printf("ip reassembly time exceeded for %s",
				     ipaddr_string(&dp->icmp_ip.ip_dst));
			break;
		}
		hasnextip = 1;
		break;
	case ICMP_PARAMPROB:
		if (dp->icmp_code)
			(void)printf("parameter problem - code %d",
				     dp->icmp_code);
		else {
			TCHECK(dp->icmp_pptr, sizeof(dp->icmp_pptr));
			(void)printf("parameter problem - octet %d",
				     dp->icmp_pptr);
		}
		hasnextip = 1;
		break;
	case ICMP_TSTAMP:
		fputs("time stamp request", stdout);
		break;
	case ICMP_TSTAMPREPLY:
		fputs("time stamp reply", stdout);
		break;
	case ICMP_IREQ:
		fputs("information request", stdout);
		break;
	case ICMP_IREQREPLY:
		fputs("information reply", stdout);
		break;
	case ICMP_MASKREQ:
		fputs("address mask request", stdout);
		break;
	case ICMP_MASKREPLY:
		TCHECK(dp->icmp_mask, sizeof(dp->icmp_mask));
		(void)printf("address mask is 0x%08x", ntohl(dp->icmp_mask));
		break;
	default:
		(void)printf("type-#%d", dp->icmp_type);
		break;
	}
	if (hasnextip && (vflag > 1)) {
		int ovflag = vflag;

		TCHECK(dp->icmp_ip.ip_len, sizeof(dp->icmp_ip.ip_len));
		printf(" : ");
		vflag = 0;
		ip_print((u_char *)&dp->icmp_ip, ntohs(dp->icmp_ip.ip_len));
		vflag = ovflag;
	}			 
	return;
trunc:
	fputs("[|icmp]", stdout);
#undef TCHECK
}
