/* Cisco ISO-IGRP defines */

#define ISO_IGRP_FIXED_SIZE	9

#define ISO_IGRP_OPCODE_STATION	0x01
#define ISO_IGRP_OPCODE_AREA 	0x02
#define ISO_IGRP_OPCODE_HELLO	0x04
#define ISO_IGRP_OPCODE_QUERY	0x10

#define ISO_IGRP_LEVEL0		0
#define ISO_IGRP_LEVEL1_ONLY    1
#define ISO_IGRP_LEVEL2_ONLY    2
#define ISO_IGRP_LEVEL1_LEVEL2  3

struct iso_igrp_fixed {		/* ISO-IGRP fixed part */
    u_char nlpi;		/* Network Layer Protocol ID */
    u_char hlen;		/* header length */
    u_char vers;		/* version */
    u_char edit;		/* edition */
    u_char opcode;		/* opcode */
    u_char lenh;		/* length (high) */
    u_char lenl;		/* length (low) */
    u_char chkh;		/* checksum (high) */
    u_char chkl;		/* checksum (low) */
    /* not in packets */
    u_short len;		/* length */
    u_short chk;		/* checksum */
};

#define ISO_IGRP_AREALIST	1	/* list of areas this router is in */
#define ISO_IGRP_AREAROUTE	2	/* list of areas we can route to */
#define ISO_IGRP_STATIONROUTE	3	/* list of stations we can route to */
#define ISO_IGRP_PREFIXROUTE	4	/* list of prefix routes we know */
#define ISO_IGRP_PARAMS		5	/* routing parameters (timers and k?) */

#define ISO_IGRP_AREA_SIZE	2	/* 2 bytes / 4 digits areas */
#define ISO_IGRP_STATION_SIZE	6	/* 6 bytes / 12 digits StationIDs */

#define ISO_IGRP_METRIC_SIZE	11
struct iso_igrp_metric {	/* ISO-IGRP metrics */
    u_char dly[3];		/* delay, in tens of microseconds */
    u_char bw[3];		/* bandwidth, in units of 1 kbit/s */
    u_char m[2];		/* MTU, in octets */
    u_char reliability;		/* percent packets successfully tx/rx */
    u_char load;		/* percent of channel occupied */
    u_char hopcount;		/* hop count */
    /* not in packets */
    int delay, bandwidth, mtu, metric;
};

#define ISO_IGRP_PREFVAL_SIZE	6
struct iso_igrp_prefval {	/* ISO-IGRP prefix route validation */
    u_long time;
    u_char holdh;
    u_char holdl;
    /* not in packets */
    u_short hold;
};

#define ISO_IGRP_HELLO_SIZE	3
struct iso_igrp_hello {		/* ISO-IGRP hello header */
    u_char type;		/* type (L1,L2,L1&2) */
    u_char holdh;		/* holdtime (high) */
    u_char holdl;		/* holdtime (low) */
    /* not in packets */
    u_short hold;		/* holdtime */
};

#define ISO_IGRP_PARAM_SIZE	9
struct iso_igrp_param {	/* ISO-IGRP parameters */
    u_char cycle;
    u_char flush;
    u_char blind;
    u_char hello;
    u_char k1;
    u_char k2;
    u_char k3;
    u_char k4;
    u_char k5;
};
