/* IGMP, DVMRP and PIM defines */

/* IGMP packet common format */

struct igmp {
	u_char		igmp_type;	/* version & type of IGMP message  */
	u_char		igmp_code;	/* unused, should be zero          */
	u_short		igmp_cksum;	/* IP-style checksum               */
	struct in_addr	igmp_group;	/* group address being reported    */
};					/*  (zero for queries)             */

#define IGMP_MINLEN		     8

/* IGMP packet types */
#define IGMP_HOST_MEMBERSHIP_QUERY	0x11
#define IGMP_HOST_MEMBERSHIP_REPORT	0x12
#define IGMP_DVMRP			0x13
#define IGMP_PIM			0x14
#define IGMP_HOST_NEW_MEMBERSHIP_REPORT	0x16
#define IGMP_HOST_LEAVE_MESSAGE		0x17
#define IGMP_MTRACE_RESP		0x1e
#define IGMP_MTRACE			0x1f

/* DVMRP packet codes */
#define DVMRP_PROBE		1
#define DVMRP_REPORT		2
#define DVMRP_ASK_NEIGHBORS	3
#define DVMRP_NEIGHBORS		4
#define DVMRP_ASK_NEIGHBORS2	5
#define DVMRP_NEIGHBORS2	6
#define DVMRP_PRUNE		7
#define DVMRP_GRAFT		8
#define DVMRP_GRAFT_ACK		9

#define DVMRP_REPORT_LAST	0x80

/* 'flags' byte values in DVMRP_NEIGHBORS2 reply */
#define DVMRP_NF_TUNNEL		0x01
#define DVMRP_NF_SRCRT		0x02
#define DVMRP_NF_DOWN		0x10
#define DVMRP_NF_DISABLED	0x20
#define DVMRP_NF_QUERIER	0x40

/* PIM packet codes */
#define PIM_QUERY		0
#define PIM_REGISTER		1
#define PIM_REGISTER_STOP	2
#define PIM_JOIN_PRUNE		3
#define PIM_RP_REACHABLE	4
#define PIM_ASSERT		5
#define PIM_GRAFT		6
#define PIM_GRAFT_ACK		7
#define PIM_MODE		8
