/* Inter Domain Routeing Protocol (ISO DIS 10747) defines */

#define IDRP_HDR_SIZE	30

/* BISPDU types */
#define IDRP_OPEN	1	/* Open PDU */
#define IDRP_UPDATE	2	/* Update PDU */
#define IDRP_ERROR	3	/* IDRP Error PDU */
#define IDRP_KEEPALIVE	4	/* Keepalive PDU */
#define IDRP_CEASE	5	/* Cease PDU */
#define IDRP_REFRESH	6	/* RIB Refresh PDU */

#define IDRP_VERSION	1	/* version number */
#define IDRP_MINMAX_SZ	1024	/* Minimun maximum PDU size */

/* ERROR codes */
#define IDRP_ERR_OPEN	1	/* OPEN_PDU_Error */
#define IDRP_ERR_UPDATE	2	/* UPDATE_PDU_Error */
#define IDRP_ERR_HOLD	3	/* Hold_Timer_Expired */
#define IDRP_ERR_FSM	4	/* FSM_Error */
#define IDRP_ERR_RIB	5	/* RIB_REFRESH_PDU_Error */

/* OPEN_PDU_Error subcodes */
#define IDRP_ERO_VER	1	/* Unsupported_Version_Number */
#define IDRP_ERO_MAX	2	/* Bad_Max_PDU_Size */
#define IDRP_ERO_PEER	3	/* Bad_Peer_RD */
#define IDRP_ERO_AUTHC	4	/* Unsupported_Authentification_code */
#define IDRP_ERO_AUTHF	5	/* Authentification_Failure */
#define IDRP_ERO_RIB	6	/* Bad_RIB_AttsSet */
#define IDRP_ERO_RDC	7	/* RDC_Mismatch */

/* UPDATE_PDU_Error subcodes */
#define IDRP_ERU_FORML	1	/* Malformed_Attribute_List */
#define IDRP_ERU_UWKA	2	/* Unrecognized_Well-known_Attribute */
#define IDRP_ERU_MWKA	3	/* Missing_Well-known_Attribute */
#define IDRP_ERU_ATTF	4	/* Attribute_Flags_Error */
#define IDRP_ERU_ATTL	5	/* Attribute_Length_Error */
#define IDRP_ERU_RDRL	6	/* RD_Routeing_Loop */
#define IDRP_ERU_INHA	7	/* Invalid_NEXT_HOP_Attribute */
#define IDRP_ERU_OPTA	8	/* Optional_Attribute_Error */
#define IDRP_ERU_IREA	9	/* Invalid_Reachability_Information */
#define IDRP_ERU_MRDC	10	/* Misconfigured_RDCs */
#define IDRP_ERU_NLRI	11	/* Malformed_NLRI */

/* Hold_Timer_Expired subcodes */
#define IDRP_ERH_NULL	0	/* NULL */

/* FSM_Error subcodes */
#define IDRP_ERF_CLOSED	1	/* CLOSED */
#define IDRP_ERF_ORCVD	2	/* OPEN-RECVD */
#define IDRP_ERF_OSENT	3	/* OPEN-SENT */
#define IDRP_ERF_CLOSW	4	/* CLOSE-WAIT */
#define IDRP_ERF_ESTAB	5	/* ESTABLISHED */

/* RIB_REFRESH_PDU_Error subcodes */
#define IDRP_ERRR_INV	1	/* Invalid_OpCode */
#define IDRP_ERRR_ATT	2	/* Unsupported_RIB-Atts */

/* RIB REFRESH OpCodes */
#define IDRP_RIB_REQ	1	/* RIB Refresh Request */
#define IDRP_RIB_START	2	/* RIB Refresh Start */
#define IDRP_RIB_END	3	/* RIB Refresh End */

struct idrp_packet {		/* IDRP BISPDU */
    struct idrp_header {	/* IDRP BISPDU header */
	u_char nlpi;		/* Network Layer Protocol ID */
	u_char lenh;		/* BISPDU length (high) */
	u_char lenl;		/* BISPDU length (low) */
	u_char type;		/* type */
	u_char seq0;		/* sequence (0) */
	u_char seq1;		/* sequence (1) */
	u_char seq2;		/* sequence (2) */
	u_char seq3;		/* sequence (3) */
	u_char ack0;		/* acknowledgement (0) */
	u_char ack1;		/* acknowledgement (1) */
	u_char ack2;		/* acknowledgement (2) */
	u_char ack3;		/* acknowledgement (3) */
	u_char cdtoff;		/* credit offered */
	u_char cdtavl;		/* credit available */
	u_char valid[16];	/* validation pattern */
	u_char data[1];		/* data */
	/* not in packets */
	u_short len;		/* BISPDU length */
	u_long seq;		/* sequence */
	u_long ack;		/* acknowledgement */
    } ih;
    union {
      struct idrp_open {	/* OPEN */
	u_char vers;		/* version */
	u_char holdh;		/* holdtime (high) */
	u_char holdl;		/* holdtime (low) */
	u_char maxszh;		/* maximum PDU size (high) */
	u_char maxszl;		/* maximum PDU size (low) */
	/* not in packets */
	u_short hold;		/* holdtime */
	u_short maxsz;		/* maximum PDU size */
      } io;
      struct idrp_update {	/* UPDATE */
	/* not in packets */
	u_short unrtcnt;	/* unfeasible route count */
	u_short tpalen;		/* total path attributes length */
      } iu;
      struct idrp_error {	/* ERROT */
	u_char code;		/* error code */
	u_char subcode;		/* error subcode */
      } ie;
      struct idrp_rib_refresh {	/* RIB REFRESH */
	u_char opcode;		/* OpCode */
      } irr;
  } iun;
};

#define idrp_nlpi	pkt.ih.nlpi
#define idrp_lenh	pkt.ih.lenh
#define idrp_lenl	pkt.ih.lenl
#define idrp_type	pkt.ih.type
#define idrp_seq0	pkt.ih.seq0
#define idrp_seq1	pkt.ih.seq1
#define idrp_seq2	pkt.ih.seq2
#define idrp_seq3	pkt.ih.seq3
#define idrp_ack0	pkt.ih.ack0
#define idrp_ack1	pkt.ih.ack1
#define idrp_ack2	pkt.ih.ack2
#define idrp_ack3	pkt.ih.ack3
#define idrp_cdtoff	pkt.ih.cdtoff
#define idrp_cdtavl	pkt.ih.cdtavl
#define idrp_valid	pkt.ih.valid
#define idrp_data	pkt.ih.data
#define idrp_len	pkt.ih.len
#define idrp_seq	pkt.ih.seq
#define idrp_ack	pkt.ih.ack
#define idrp_vers	pkt.iun.io.vers
#define idrp_holdh	pkt.iun.io.holdh
#define idrp_holdl	pkt.iun.io.holdl
#define idrp_maxszh	pkt.iun.io.maxszh
#define idrp_maxszl	pkt.iun.io.maxszl
#define idrp_hold	pkt.iun.io.hold
#define idrp_maxsz	pkt.iun.io.maxsz
#define idrp_unrtcnt	pkt.iun.iu.unrtcnt
#define idrp_tpalen	pkt.iun.iu.tpalen
#define idrp_code	pkt.iun.ie.code
#define idrp_subcode	pkt.iun.ie.subcode
#define idrp_opcode	pkt.iun.irr.opcode

/* Path Attribute Flags */
#define IDRP_PAF_OPT	0x80	/* Optional bit */
#define IDRP_PAF_TRANS	0x40	/* Transitive bit */
#define IDRP_PAF_PART	0x20	/* Partial bit */
#define IDRP_PAF_RES	0x1f	/* Reserved bits */

/* Path Attribute Types */
#define IDRP_PAT_RT_ID	1	/* ROUTE_ID */
#define IDRP_PAT_EXT_I	2	/* EXT_INFO */
#define IDRP_PAT_RD_PA	3	/* RD_PATH */
#define IDRP_PAT_N_HOP	4	/* NEXT_HOP */
#define IDRP_PAT_DL_IN	5	/* DIST_LIST_INCL */
#define IDRP_PAT_DL_EX	6	/* DIST_LIST_EXCL */
#define IDRP_PAT_EXIT	7	/* MULTI_EXIT_DISC */
#define IDRP_PAT_PREF	8	/* LOCAL_PREF */
#define IDRP_PAT_DELAY	9	/* TRANSIT_DELAY */
#define IDRP_PAT_R_ERR	10	/* RESIDUAL_ERROR */
#define IDRP_PAT_EXPS	11	/* EXPENSE */
#define IDRP_PAT_S_QOS	12	/* SOURCE_SPECIFIC_QOS */
#define IDRP_PAT_D_QOS	13	/* DESTINATION_SPECIFIC_QOS */
#define IDRP_PAT_H_REC	14	/* HIERARCHICAL_RECORDING */
#define IDRP_PAT_RD_HC	15	/* RD_HOP_COUNT */
#define IDRP_PAT_S_SEC	16	/* SOURCE_SPECIFIC_SECURITY */
#define IDRP_PAT_D_SEC	17	/* DESTINATION_SPECIFIC_SECURITY */
#define IDRP_PAT_CAPA	18	/* CAPACITY */
#define IDRP_PAT_PRI	19	/* PRIORITY */

struct idrp_path_attr {
    u_char flag;		/* flag */
    u_char type;		/* type */
    u_char lenh;		/* length (high) */
    u_char lenl;		/* length (low) */
    u_char value[1];		/* value */
    /* not in packets */
    u_short len;		/* length */
};

/* RD_PATH Segment Types */
#define IDRP_RD_SET	1	/* RD_SET */
#define IDRP_RD_SEQ	2	/* RD_SEQ */
#define IDRP_ENTRY_SEQ	3	/* ENTRY_SEQ */
#define IDRP_ENTRY_SET	4	/* ENTRY_SET */

#define IDRP_NH_SERVA	0xff	/* IDRP_Server_Allowed */
#define IDRP_PT_9577	1	/* Proty_type ISO TR 9577 IPI/SPI */
#define IDRP_PT_8802	2	/* Proty_type ISO IS 8802 LSAP */

#define PACK4(full,b0,b1,b2,b3) \
 full = ((u_long)b0 << 24) | ((u_long)b1 << 16) | \
        ((u_long)b2 << 8) | ((u_long)b3)
