/* ES-IS defines */

struct esis_fixed {	/* ESIS fixed part */
    u_char nlpi;	/* Network Layer Protocol ID */
    u_char len;		/* PDU length */
    u_char ver;		/* Version/Protocol ID extension */
    u_char res;		/* reserved (not to Digital, must be 0) */
    u_char type;	/* PDU type */
    u_char holdh;	/* holding time (high) */
    u_char holdl;	/* holding time (low) */
    u_char chkh;	/* checksum (high) */
    u_char chkl;	/* checksum (low) */
    /* no in packets */
    u_short hold;	/* holding time*/
    u_short chk;	/* checksum */
};
#define ESIS_FIXED_SIZE	9	/* length (don't use sizeof !) */
#define ESIS_MAX_LEN	254	/* length == 255 is reserved */
#define ESIS_VERSION	1	/* version ONE */
#define ESIS_ESH_PDU	0x02	/* Intermediate System Hello */
#define ESIS_ISH_PDU	0x04	/* End System Hello */
#define ESIS_RD_PDU	0x06	/* Redirect Hello */
#define ESIS_OPT_SECU	0xc5	/* security */
#define ESIS_OPT_QOS	0xc3	/* quality of service */
#define ESIS_OPT_PRI	0xcd	/* priority */
#define ESIS_OPT_AMSK	0xe1	/* address mask */
#define ESIS_OPT_SMSK	0xe2	/* SNPA mask */
#define ESIS_OPT_ESCT	0xc6	/* ES configuration timer */
#define ESIS_OPT_PRO	0x81	/* (Integrated ISIS) Protocols supported */
