/* according to Christian Claveleira of Universite' Rennes I */

#define ETHERTYPE_BR3COM	0x9002

struct br3com_alive {	/* frame 3Com TCP/IP bridge management */
    u_char es_addr[6];
    u_char ed_addr[6];
    u_char unknown1[2];
    u_char ip_addr[4];
    u_char unknown2[2];
    u_char timer[4];
    char s[24];
};

/* According to Interconnections, Bridges and Routers by Radia Perlman */

struct br8021d_conf {	/* frame 802.1d configuration message */
    u_char pid[2];	/* protocol identifier */
    u_char ver;		/* version */
    u_char type;	/* message type */
    u_char flags;	/* flags */
    u_char rootID[8];	/* root ID */
    u_char cost[4];	/* cost of path to root */
    u_char bridgeID[8];	/* bridge ID */
    u_char portID[2];	/* port ID */
    u_char age[2];	/* message age */
    u_char hello[2];	/* hello time */
    u_char fdelay[2];	/* forward delay */
};

#define BR8021D_PID	0
#define BR8021D_VER	0
#define BR8021D_CONF	0
#define BR8021D_TCNOT	128
#define BR8021D_TCA_F	0x80
#define BR8021D_TC_F	0x01
