/* ------------------------------------------------------------------------- */
/* 									     */
/* i2c.h - definitions for the \iic-bus interface			     */
/* 									     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
/*
 * See below for configuration options. 
 *
 * $Id: i2c.h,v 2.2 1996/11/18 22:34:29 i2c Exp i2c $ 
 *
 * $Log: i2c.h,v $
 * Revision 2.2  1996/11/18 22:34:29  i2c
 * removed PCF_* definitions
 *
 * Revision 2.1  1996/11/17 14:04:08  i2c
 * clean-up. Moved private parts into i2c_priv.h
 *
 * Revision 1.5  1996/03/29 13:33:43  i2c
 * div. cleanups
 *
 * Revision 1.4  1996/03/25 19:03:10  i2c
 * added rcs header
 *
 */
#ifndef _I2C_H
#define _I2C_H

/* --- General options ------------------------------------------------	*/
#define I2C_MAJOR	89			/* Device major number	*/

/* --- Select one of the following: -----------------------------------	*/
/*
 * As I only have a small subset of the adapters listed ( namely the 
 * Philips-style one), I could not test all of them. If there are bugs,
 * please tell me, along with possible solutions, if available. 
 *
 */

#define	PARALLEL	/* Philips style parallel port adapter		*/
#undef	VT1500		/* VT1500 TV Card (which company?)		*/


#define I2C_MAGIC	0x090203/* magic number for the struct		*/

/* ----- IOCTL's - note that some HW may support some, others not!	*/
				/* -> bit-adapter specific ioctls	*/
#define I2C_TIMEOUT	0x0701	/* set timeout - call with int 		*/
#define I2C_UDELAY	0x0702  /* set delay in microsecs between each  */
				/* written byte (except address)	*/
#define I2C_MDELAY	0x0703	/* millisec delay between written bytes */
#define I2C_RETRIES	0x0704  /* number times a device adress should  */
				/* be polled when not acknowledging 	*/
#define I2C_ADDR	0x0705	/* Change adapter's \iic address 	*/

				/******** new features			*/
#define I2C_SLAVE	0x0706	/* Change slave address			*/
				/* for 10-bit addresses,concat the adr.:*/
				/* f0 (1st), 13 (2nd byte) to transmit	*/
				/*	--> arg=0x0000f013		*/
				/******** these are for debugging:	*/
#define I2C_RESET	0x07fd	/* reset adapter			*/
#define I2C_CLEAR	0x07fe	/* when lost, use to clear stale info	*/
#define I2C_V_SLOW	0x07ff  /* set jiffies delay call with int 	*/

#define I2C_INTR	0x0707	/* Pass interrupt number (*lp*)		*/

/* This is strictly experimental and currently not used (but soon;)	*/
#ifdef VT1500
#define I2C_VT1500_SET	0X0780	/* set values on the port		*/
#define I2C_VT1500_CEAR	0X0781	/* reset values				*/
#endif


/* ----- port info structure */
struct i2c_struct {
	unsigned int base;
	unsigned int flags;
	int timeout;
	int udelay,mdelay;	/* usec & msec delay times 		*/
	int retries;
	int veryslow;		/* used by SLO_IO - only for debugging 	*/
				/* this might go away if not needed...	*/
	int irq;		/* number of int, or 0 if none		*/
	
	struct wait_queue *wait_q;/* for interrupt enabled HW		*/
	char *buffer;		/* int. buffer for transfer		*/
	void *minor_data;	/* low-level data, for ease of reference*/
};

extern struct i2c_struct i2c_table[];


/* ----- Flags field:							*/
#define P_EXIST 0x8000		/* port is alive			*/
#define P_BUSY	0x4000		/* port in use (r/w)			*/
#define P_SLOW  0x2000		/* slow mode 				*/

				/* hardware adapter types:		*/
#define P_TMASK	0x00ff		/* Adapter type mask. see i2c_priv.h	*/

/*
 * ---- Adapter types: Add a define statement & the struct ---------------
 *
 * First, we distinguish between several algorithms to access the hardware
 * interface types, as a PCF 8584 needs other care than a bit adapter.
 */

#define ALG_NONE	0x00
#define ALG_BIT		0x10	/* bit style adapters			*/
#define ALG_PCF		0x20	/* PCF 8584 style adapters		*/

#define ALG_MASK	0xf0	/* Mask for algorithms			*/
#define ALG_SHIFT	0x04	/* right shift to get index values 	*/

#define I2C_HW_ADAPS	0x10	/* number of different hw implements per*/
				/* algorithm layer module		*/
#define I2C_HW_MASK	0x0f	/* space for indiv. hw implmentations	*/

/* --- Bit algorithm adapters 						*/
#define HW_B_LP		0x00	/* Parallel port Philips style adapter	*/
#define HW_B_LPC	0x01	/* Parallel port, over control reg.	*/
#define HW_B_SER	0x02	/* Serial line interface		*/
#define HW_B_ELV	0x03	/* ELV Card				*/
#define HW_B_VELLE	0x04	/* Vellemann K8000			*/

/* --- PCF 8584 based algorithms					*/
#define HW_P_LP		0x00	/* Parallel port interface		*/
#define HW_P_ISA	0x01	/* generic ISA Bus inteface card	*/
#define HW_P_ELEK	0x02	/* Elektor ISA Bus inteface card	*/

#endif
