/* ------------------------------------------------------------------------- */
/* bit-lp.c i2c-hw access for philips style parallel port adapters	     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-96 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
static char rcsid[] = "$Id: bit-lp.c,v 1.1 1996/11/17 11:00:03 i2c Exp $";
/*
 * $Log: bit-lp.c,v $
 * Revision 1.1  1996/11/17 11:00:03  i2c
 * Initial revision
 *
 *
 */

#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/errno.h>

#include "i2c.h"
#include "i2c_priv.h"

/* ----- global defines -----------------------------------------------	*/
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x) 	/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/

/* ----- local functions --------------------------------------------------- */

#if (BITADAPS) > 1
#  define Local static
#else
#  define Local inline
#endif


Local void setscl(int minor, int state)
{
	if (state) {
		outb(I2C_SCL,   CTRL);
	} else {
		outb(I2C_CMASK, CTRL);
	}
	
}

Local void setsda(int minor, int state)
{
	if (state) {
		outb(I2C_DMASK , DATA);
	} else {
		outb(I2C_SDA , DATA);
	}
	
} 

Local int getscl(int minor)
{
	return ( 0 != ( (inb(STAT)) & I2C_SCLIN ) );
}

Local int getsda(int minor)
{
	return ( 0 != ( (inb(STAT)) & I2C_SDAIN ) );
}

Local int bit_init(int minor)
{
	if (check_region(i2c_table[minor].base,
		(i2c_table[minor].base == 0x3bc)? 3 : 8) < 0 ) {
		DEBE(printk("i2c_init: Port %#x already in use.\n",
			i2c_table[minor].base));
		return -ENODEV;
	} else {
		request_region(i2c_table[minor].base, 
			(i2c_table[minor].base == 0x3bc)? 3 : 8, 
			"i2c (Parallel port adapter)");

		setsda(minor,1);
		setscl(minor,1);
	}
	printk("i2c%d: scl: %d     sda %d \n",minor,getscl(minor),getsda(minor));
	return 0;
}

Local void bit_exit(int minor)
{	
	release_region( i2c_table[minor].base , 
		(i2c_table[minor].base == 0x3bc)? 3 : 8 );
}


/* ------------------------------------------------------------------------
 * Encapsulate the above functions in the correct operations structure.
 * This is only done when more than one hardware adapter is supported.
 */
#if (BITADAPS) > 1
struct i2c_bit_ops bit_lp_ops = {
	setscl,
	setsda,
	getscl,
	getsda,
	bit_init,
	bit_exit
};
#endif