/* ------------------------------------------------------------------------- */
/* alg-illeg.c  i2c dummy stub						     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995-96 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
static char rcsid[] = "$Id: alg-illeg.c,v 1.3 1996/11/16 18:48:41 i2c Exp $";
/*
 * $Log: alg-illeg.c,v $
 * Revision 1.3  1996/11/16 18:48:41  i2c
 * changed debugging messages
 *
 * Revision 1.2  1996/03/28 20:34:31  i2c
 * added exit
 *
 * Revision 1.1  1996/03/28 19:37:58  root
 * Initial revision
 *
 */

#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/lp.h>

#include "i2c.h"
#include "i2c_priv.h"

/* ----- global defines ---------------------------------------------------- */
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x) 	/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/
#define DEBI(x) x	/* ioctl and its arguments 			*/
#define DEBACK(x)	/* ack failed message				*/

/* ----- global variables -------------------------------------------------- */

/* ----- local functions --------------------------------------------------- */

/* ----- level 2: communication with the kernel  ----- */

static int i2c_open(struct inode * inode, struct file * file) 
{
	printk("i2c: invalid device called (illeg)!\n");
	return -EINVAL;
}


static void i2c_release (struct inode * inode, struct file * file) 
{
	printk("i2c: invalid device called (illeg)!\n");
}


static int i2c_write(struct inode * inode, struct file * file,
	const char * buf, int count)
{
	printk("i2c: invalid device called (illeg)!\n");
	return -EINVAL;
}

static int i2c_read(struct inode * inode, struct file * file,
	char * buf, int count) 
{
	printk("i2c: invalid device called (illeg)!\n");
	return -EINVAL;
}

static int i2c_ioctl(struct inode *inode, struct file *file,
	unsigned int cmd, unsigned long arg)
{
	printk("i2c: invalid device called (illeg)!\n");
	return -EINVAL;
}

static int i2c_init(int minor)
{	
	printk("i2c: invalid device called (illeg)!\n");
	return -EINVAL;
}

static void i2c_exit(int minor)
{	
}
                
/* -----exported file operations: -------------------------------------	*/
struct i2c_opns illegops = {
	i2c_read,
	i2c_write,
	i2c_ioctl,
	i2c_open,
	i2c_release,
	i2c_init,
	i2c_exit
};
