/*
 WARNING: THIS CODE DOES NOT WORK YET! 
 
 I need a bidirectional parallel port first to build the 
 hardware ....
 
 
 
 */

/* ------------------------------------------------------------------------- */
/* adap-lppcf.c  i2c with PCF 8584 on parallel port			     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 19996 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
static char rcsid[] = "$Id: adap-lppcf.c,v 1.1 1996/03/29 16:02:17 i2c Exp i2c $";
/*
 * $Log: adap-lppcf.c,v $
 * Revision 1.1  1996/03/29 16:02:17  i2c
 * Initial revision
 *
 */

#include <linux/kernel.h>
#include <linux/delay.h>
#include <linux/ioport.h>
#include <asm/io.h>
#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/lp.h>

#include "i2c.h"
#include "i2c_priv.h"

/* ----- global defines ---------------------------------------------------- */
#define DEB(x)		/* should be reasonable open, close &c. 	*/
#define DEB2(x) 	/* low level debugging - very slow 		*/
#define DEBE(x)	x	/* error messages 				*/
#define DEBI(x) x	/* ioctl and its arguments 			*/
#define DEBACK(x)	/* ack failed message - may be annoying		*/

/* some convenience defines: */
#define cmd(data)	i2c_outb(minor,(data),1)
#define dta(data)	i2c_outb(minor,(data),0)
#define stat()		i2c_inb(minor,1)
#define recv()		i2c_inb(minor,0)

/* ----- global variables -------------------------------------------------- */
static int state;
/* ----- local functions --------------------------------------------------- */

static void i2c_outb(int minor,char data,int a0) {
	if (a0)
		state|=LP_PAUTOLF;
	outb(data,DATA);
	state ^= LP_PINITP;
	udelay(LP_DELAY);
	outb(state,CTRL);
	state ^= LP_PSTROBE;
	udelay(LP_DELAY);
	outb(state,CTRL);
	state ^= LP_PSTROBE;
	udelay(LP_DELAY);
	outb(state,CTRL);
	state ^= LP_PINITP;
	outb(state,CTRL);
	udelay(LP_DELAY);
};

static int i2c_inb(int minor, int a0) {
	char data;

	if (a0)
		state|=LP_PAUTOLF;
	udelay(LP_DELAY);
	outb(0x00,DATA);
	state ^= LP_PINITP;
	udelay(LP_DELAY);
	outb(state,CTRL);
	state ^= LP_PSELECP;
	udelay(LP_DELAY);
	outb(state,CTRL);
	data=inb(DATA);
	state ^= LP_PSELECP;
	udelay(LP_DELAY);
	outb(state,CTRL);
	state ^= LP_PINITP;
	udelay(LP_DELAY);
	outb(state,CTRL);
	return data;
};

static int i2c_open(struct inode * inode, struct file * file) 
{
	printk("i2c: invalid device called!\n");
	return -EINVAL;
}


static void i2c_release (struct inode * inode, struct file * file) 
{
	printk("i2c: invalid device called!\n");
}


static int i2c_write(struct inode * inode, struct file * file,
	const char * buf, int count)
{
	printk("i2c: invalid device called!\n");
	return -EINVAL;
}

static int i2c_read(struct inode * inode, struct file * file,
	char * buf, int count) 
{
	printk("i2c: invalid device called!\n");
	return -EINVAL;
}

static int i2c_ioctl(struct inode *inode, struct file *file,
	unsigned int cmd, unsigned long arg)
{
	unsigned int minor = MINOR(inode->i_rdev);

	printk("i2c: invalid device called!\n");
	switch (cmd) {
		case 0x0800:		/* reset state		*/
			state=0x14;
			break;
		case 0x0804:		/* toggle a0 line	*/
			state ^= LP_PAUTOLF;
			break;
		case 0x0802:		/* toggle rd line	*/
			state ^= LP_PSELECP;
			break;
		case 0x0801:		/* toggle wr line	*/
			state ^= LP_PSTROBE;
			break;
		case 0x0803:		/* toggle cs line	*/
			state ^= LP_PINITP;
			break;
		case 0x0810:		/* print line state	*/
			printk(KERN_INFO 
				"i2c: lp state: a0 %d, rd %d, wr %d, cs %d\n",
				(state&LP_PAUTOLF) ? 0:1,
				(state&LP_PSELECP) ? 0:1,
				(state&LP_PSTROBE) ? 0:1,
				(state&LP_PINITP ) ? 0:1
				);
			return 0;
		default:
			return -EINVAL;
	}
	outb(state,CTRL);
	return 0;
}

static int i2c_init(int minor)
{	
	if (check_region(i2c_table[minor].base, 
		(i2c_table[minor].base == 0x3bc)? 3 : 8) < 0 ) {
		DEBE(printk("i2c_init: Port %#x already in use.\n",
			i2c_table[minor].base));
		return -ENODEV;
	} 
	request_region(i2c_table[minor].base, 
		(i2c_table[minor].base == 0x3bc)? 3 : 8, 
		"i2c (PCF 8584)");
	
	outb(0x00,DATA);
	udelay(LP_DELAY);
	outb(0x14,CTRL);
	udelay(LP_DELAY);
	state=0x14;
/*	printk("i2c: %#x %#x %#x %#x %#x %#x %#x %#x\n",
		inb(DATA),  inb(STAT),  inb(CTRL),  inb(CTRL+1),
		inb(CTRL+2),inb(CTRL+3),inb(CTRL+4),inb(CTRL+5));
*/	cmd(0x80);			/* reset signal			*/
	udelay(50);
	dta(0x11);			/* our address: 0x22 		*/
	cmd(0xa0);			/* load clock reg.:		*/
	dta(0x18+3);
	cmd(0xc1);			/* enable \iic-bus interface	*/
	printk("i2c: chip reads         0x%x\n",stat());

	outb(0x14+LP_PAUTOLF,CTRL);
	return 0;
}

static void i2c_exit(int minor)
{
	release_region( i2c_table[minor].base , 
		(i2c_table[minor].base == 0x3bc)? 3 : 8 );	
}
                
/* -----exported file operations: -------------------------------------	*/
struct i2c_opns lppcfops = {
	i2c_read,
	i2c_write,
	i2c_ioctl,
	i2c_open,
	i2c_release,
	i2c_init,
	i2c_exit
};
