/* ------------------------------------------------------------------------- */
/* 									     */
/* i2c.h - definitions for the \iic-bus interface			     */
/* 									     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */
/* $Id: i2c.h,v 1.5 1996/03/29 13:33:43 i2c Exp $ 
 *
 * $Log: i2c.h,v $
 * Revision 1.5  1996/03/29 13:33:43  i2c
 * div. cleanups
 *
 * Revision 1.4  1996/03/25 19:03:10  i2c
 * added rcs header
 *
 */

#ifndef _I2C_H
#define _I2C_H

#define I2C_MAJOR	63
#define I2C_MAGIC	0x090203

/* ----- IOCTLs */
				/* -> bit-adapter specific ioctls	*/
#define I2C_TIMEOUT	0x0701	/* set timeout - call with int 		*/
#define I2C_UDELAY	0x0702  /* set delay in microsecs between each  */
				/* written byte (except address)	*/
#define I2C_MDELAY	0x0703	/* millisec delay between written bytes */
#define I2C_RETRIES	0x0704  /* number times a device adress should  */
				/* be polled when not acknowledging 	*/
#define I2C_ADDR	0x0705	/* Change adapter's \iic address 	*/

				/******** new features			*/
#define I2C_SLAVE	0x0720	/* Change slave address			*/
				/* for 10-bit addresses,concat the adr.:*/
				/* f0 (1st), 13 (2nd byte) to transmit	*/
				/*	--> arg=0x0000f013		*/
				/******** these are for debugging:	*/
#define I2C_RESET	0x07fd	/* reset adapter			*/
#define I2C_CLEAR	0x07fe	/* when lost, use to clear stale info	*/
#define I2C_V_SLOW	0x07ff  /* set jiffies delay call with int 	*/

#define	BASE		i2c_table[(minor)].base	/* hardware base port 	*/

/* ----- parallel port specific definitions: */
#define DATA	BASE
#define STAT	(BASE+1)
#define CTRL	(BASE+2)
						/*Pin Port  Inv	name	*/
#define I2C_ON		0x20			/* 12 status N	paper	*/

#define I2C_SDA		0x80			/*  9 data   N	data7	*/
#define I2C_SCL		0x08			/* 17 ctrl   N	dsel	*/

#define I2C_DMASK	0x7f			
#define I2C_CMASK	0xf7			

#define I2C_SDAIN	0x80			/* 11 stat   Y	busy	*/
#define I2C_SCLIN	0x10			/* 15 stat   Y	enable	*/


/* ----- port info structure */
struct i2c_struct {
	unsigned int base;
	unsigned int flags;
	int timeout;
	int udelay,mdelay;	/* usec & msec delay times 		*/
	int retries;
	int veryslow;	/* used by SLO_IO - only for debugging 		*/
};
extern struct i2c_struct i2c_table[];

/* ----- Flags field:							*/
#define P_EXIST 0x8000		/* port is alive			*/
#define P_BUSY	0x4000		/* port in use (r/w)			*/
#define P_SLOW  0x2000		/* slow mode 				*/

				/* hardware adapter types:		*/
#define P_TMASK	0x000f		/* Adapter type mask. see i2c_adap.c	*/


#endif
