#ifndef _PRT_H
#define _PRT_H

#include <linux/lp.h>
#define PRT_MAJOR	7
/* timeout for each character.  This is relative to bus cycles -- it
 * is the count in a busy loop.  THIS IS THE VALUE TO CHANGE if you
 * have extremely slow printing, or if the machine seems to slow down
 * a lot when you print.  If you have slow printing, increase this
 * number and recompile, and if your system gets bogged down, decrease
 * this number.  This can be changed with the tunelp(8) command as well.
 */

#define PRT_INIT_CHAR 1000

/* The parallel port specs apparently say that there needs to be
 * a .5usec wait before and after the strobe.  Since there are wildly
 * different computers running linux, I can't come up with a perfect
 * value, but since it worked well on most printers before without,
 * I'll initialize it to 0.
 */

#define PRT_INIT_WAIT 0

/* This is the amount of time that the driver waits for the printer to
 * catch up when the printer's buffer appears to be filled.  If you
 * want to tune this and have a fast printer (i.e. HPIIIP), decrease
 * this number, and if you have a slow printer, increase this number.
 * This is in hundredths of a second, the default 2 being .05 second.
 * Or use the tunelp(8) command, which is especially nice if you want
 * change back and forth between character and graphics printing, which
 * are wildly different...
 */

#define PRT_INIT_TIME 2

/* IOCTL numbers */
#define LPCHAR   0x0001  /* corresponds to LP_INIT_CHAR */
#define LPTIME   0x0002  /* corresponds to LP_INIT_TIME */
#define LPABORT  0x0004  /* call with TRUE arg to abort on error,
			    FALSE to retry.  Default is retry.  */
#define LPSETIRQ 0x0005  /* call with new IRQ number,
			    or 0 for polling (no IRQ) */
#define LPGETIRQ 0x0006  /* get the current IRQ number */
#define LPWAIT   0x0008  /* corresponds to LP_INIT_WAIT */

/* timeout for printk'ing a timeout, in jiffies (100ths of a second).
   This is also used for re-checking error conditions if LP_ABORT is
   not set.  This is the default behavior. */

#define PRT_TIMEOUT_INTERRUPT	(60 * HZ)
#define PRT_TIMEOUT_POLLED	(10 * HZ)

#define PRT_B(minor)	lp_table[(minor)].base		/* IO address */
#define PRT_F(minor)	lp_table[(minor)].flags		/* flags for busy, etc. */
#define PRT_S(minor)	inb_p(PRT_B((minor)) + 1)	/* status port */
#define PRT_C(minor)	(lp_table[(minor)].base + 2)	/* control port */
#define PRT_CHAR(minor)	lp_table[(minor)].chars		/* busy timeout */
#define PRT_TIME(minor)	lp_table[(minor)].time		/* wait time */
#define PRT_WAIT(minor)	lp_table[(minor)].wait		/* strobe wait */
#define PRT_IRQ(minor)	lp_table[(minor)].irq		/* interrupt # */
							/* 0 means polled */

#define PRT_BUFFER_SIZE 256

struct lp_struct prt_table[] = {
	/* port i# flags       chars           time           wait   qu   *buf */
	{ 0x278, 0, 0, PRT_INIT_CHAR, PRT_INIT_TIME, PRT_INIT_WAIT, NULL, NULL, }
}; 
#define PRT_NO 1 /* we only use lp2, so we wont conflict with printers */

/* 
 * the value written to ports to test existence. PC-style ports will 
 * return the value written. AT-style ports will return 0. so why not
 * make them the same ? 
 */
#define PRT_DUMMY	0x00

/*
 * This is the port delay time.  Your mileage may vary.
 * It is used only in the lp_init() routine.
 */
#define PRT_DELAY 	150000

/* ---------------------------------------------------------------------------
 * function prototypes
 * ---------------------------------------------------------------------------
 */


#endif
