/* ------------------------------------------------------------------------- */
/* 									     */
/* i2c.h - definitions for the \iic-bus interface			     */
/* 									     */
/* ------------------------------------------------------------------------- */
/*   Copyright (C) 1995 Simon G. Vogl

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		     */
/* ------------------------------------------------------------------------- */

#ifndef _I2C_H
#define _I2C_H

#define I2C_MAJOR	24

/* IOCTLs */
#define I2C_TIMEOUT	0X0701	/* set timeout - call with int 		*/
#define I2C_UDELAY	0x0702  /* set delay in microsecs between each 
				   written byte (except address)	*/
#define I2C_MDELAY	0x0703	/* millisec delay between written bytes */
#define I2C_RETRIES	0x0704  /* number times, a device adress should 
				   be polled, when not acknowledging 	*/
#define I2C_RESET	0x07fd
#define I2C_CLEAR	0x07fe
#define I2C_V_SLOW	0x07ff  /* set jiffies delay call with int 	*/


#define	BASE		i2c_table[(minor)].base	/* hardware port */

#define DATA	BASE
#define STAT	(BASE+1)
#define CTRL	(BASE+2)

#define I2C_ON		0x20
#define I2C_SDA		0x80
#define I2C_SCL		0x08
#define I2C_DMASK	0x7f
#define I2C_CMASK	0xf7

#define I2C_SCLI(minor)	(STAT((minor)) & I2C_SCL )
#define I2C_PWON(minor)	(inb(STAT) & I2C_ON  )
#define I2C_SDAI(minor)	(STAT((minor)) & I2C_SDA )

#define FLAG(minor)	pinfo.flags
#  define I2C_BUSY	0x01	/* port already open			*/
#  define I2C_ERROR	0x02	/* error during last communication 	*/

typedef struct {
	unsigned int base;
	unsigned int flags;
	int timeout;
	int udelay,mdelay;	/* usec & msec delay times */
	int retries;
	int veryslow;	/* used by SLO_IO - only for debugging */
} portinfo;

/* the flags field : */
#define P_BUSY	0x0001		/* port in use (r/w)			*/
#define P_SLOW  0x0002		/* slow mode 				*/
#define P_EXIST 0x1000		/* port exists 				*/

extern portinfo pinfo;


#endif
