#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>

#include "atm.h"


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ <atm_addr> ]\n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    struct sockaddr_atmsvc addr;
    struct atm_blli blli;
    char buffer[MAX_ATM_ADDR_LEN+1];
    char *here;
    int s,passive,len;

    if ((s = socket(PF_ATMSVC,SOCK_DGRAM,ATM_AAL5)) < 0) {
	perror("socket");
	return 1;
    }
    memset(&addr,0,sizeof(addr));
    memset(&blli,0,sizeof(blli));
    addr.sas_family = AF_ATMSVC;
    addr.sas_family = AF_ATMSVC;
    addr.sas_addr.blli = &blli;
    addr.sas_txtp.class = addr.sas_rxtp.class = ATM_UBR;
    blli.l2_proto = 1;
    blli.next = NULL;
    if (bind(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    if (!(passive = argc == 1)) {
	if (argc != 2) usage(argv[0]);
	if (text2atm(argv[1],(struct sockaddr *) &addr,sizeof(addr),T2A_NAME)
	  < 0) {
	    fprintf(stderr,"%s: invalid ATM address\n",argv[1]);
	    return 1;
	}
    }
    addr.sas_addr.blli = &blli;
    addr.sas_txtp.class = addr.sas_rxtp.class = ATM_UBR;
    here = strrchr(argv[0],'/');
    if (!passive) {
	if (connect(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	    perror("connect");
	    return 1;
	}
    }
    else {
	if (listen(s,0) < 0) {
	    perror("listen");
	    return 1;
	}
	if ((s = accept(s,NULL,0)) < 0) { /* loses listening socket dsc */
	    perror("accept");
	    return 1;
	}
    }
    len = sizeof(addr);
    if (getsockname(s,(struct sockaddr *) &addr,&len) < 0)
	perror("getsockname");
    else {
	if (atm2text(buffer,MAX_ATM_ADDR_LEN+1,(struct sockaddr *) &addr,
	  A2T_NAME | A2T_PRETTY) < 0) strcpy(buffer,"<invalid>");
	printf("Local: %s\n",buffer);
    }
    fflush(stdout);
    len = sizeof(addr);
    if (getpeername(s,(struct sockaddr *) &addr,&len) < 0)
	perror("getpeername");
    else {
	if (atm2text(buffer,MAX_ATM_ADDR_LEN+1,(struct sockaddr *) &addr,
	  A2T_NAME | A2T_PRETTY) < 0) strcpy(buffer,"<invalid>");
	printf("Remote: %s\n",buffer);
    }
    printf("Press [Enter] to continue ");
    fflush(stdout);
    (void) getchar();
    return 0;
}
