%{
/* cfg.y - configuration language */

/* Written 1995,1996 by Werner Almesberger, EPFL-LRC */


#include <string.h>
#include <ctype.h>
#include <linux/atm.h>

#include "atmd.h"

#include "proto.h"
#include "io.h"


extern int net;


static int hex2num(char digit)
{
    if (isdigit(digit)) return digit-'0';
    if (islower(digit)) return toupper(digit)-'A'+10;
    return digit-'A'+10;
}

%}

%union {
    int num;
    struct sockaddr_atmpvc pvc;
};


%token		TOK_LEVEL TOK_DEBUG TOK_INFO TOK_WARN TOK_ERROR TOK_FATAL
%token		TOK_SIG TOK_UNI30 TOK_UNI31 TOK_SAAL TOK_SVC
%token		TOK_IO TOK_NET TOK_VPCI TOK_ITF
%token <num>	TOK_NUMBER
%token <pvc>	TOK_PVC

%type <num>	level

%%

all:
    | item all
    ;

item:
    TOK_LEVEL level
	{
	    set_verbosity(NULL,$2);
	}
    | TOK_SIG sig
    | TOK_SAAL saal
    | TOK_IO io
    ;

sig:
    sig_item
    | '{' sig_items '}'
    ;

sig_items:
    | sig_item sig_items
    ;

saal:
    saal_item
    | '{' saal_items '}'
    ;

saal_items:
    | saal_item saal_items
    ;

io:
    io_item
    | '{' io_items '}'
    ;

io_items:
    | io_item io_items
    ;

sig_item:
    TOK_LEVEL level
	{
	    set_verbosity("Q2931",$2);
	    set_verbosity("KERNEL",$2);
	}
    | TOK_VPCI TOK_NUMBER TOK_ITF TOK_NUMBER
	{
	    enter_vpci($2,$4);
	}
    | TOK_UNI30
	{
	    /* that's the default anyway */
	}
    | TOK_UNI31
	{
	    yyerror("Sorry, not supported yet");
	}
    | TOK_NET
	{
	    net = 1;
	}
    ;

saal_item:
    TOK_LEVEL level
	{
	    set_verbosity("SSCF",$2);
	    set_verbosity("SSCOP",$2);
	}
    ;

io_item:
    TOK_LEVEL level
	{
	    set_verbosity("IO",$2);
	}
    | TOK_SVC TOK_PVC
	{
	    signaling_pvc = $2;
	}
    ;

level:
    TOK_DEBUG
	{
	    $$ = DIAG_DEBUG;
	}
    | TOK_INFO
	{
	    $$ = DIAG_INFO;
	}
    | TOK_WARN
	{
	    $$ = DIAG_WARN;
	}
    | TOK_ERROR
	{
	    $$ = DIAG_ERROR;
	}
    | TOK_FATAL
	{
	    $$ = DIAG_FATAL;
	}
    ;
