/* itf.c - IP interface registry */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

#include <stdlib.h>
#include <string.h>

#include "atmd.h"

#include "table.h"
#include "io.h"
#include "itf.h"


#define COMPONENT "ITF"


ITF *lookup_itf(int number)
{
    ITF *itf;

    for (itf = itfs; itf; itf = itf->next)
	if (itf->number == number) break;
    return itf;
}


ITF *lookup_itf_by_ip(unsigned long ip)
{
    ITF *itf;

    for (itf = itfs; itf; itf = itf->next)
	if (!((itf->local_ip ^ ip) & itf->netmask)) break;
    return itf;
}


int itf_create(int number)
{
    diag(COMPONENT,DIAG_DEBUG,"ITF CREATE %d",number);
    return 0;
}


void itf_up(int number)
{
    ITF *itf;

    diag(COMPONENT,DIAG_DEBUG,"ITF UP %d",number);
    itf = alloc_t(ITF);
    if (ip_itf_info(number,&itf->local_ip,&itf->netmask) < 0) {
	free(itf);
	return;
    }
    itf->number = number;
    itf->table = itf->arp_srv = NULL;
    Q_INSERT_HEAD(itfs,itf);
}


void itf_down(int number)
{
    diag(COMPONENT,DIAG_DEBUG,"ITF DOWN %d",number);
    /* should remove interface */
}
