#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/atm.h>


static void usage(const char *name)
{
    fprintf(stderr,"usage: %s [ <nsap_addr> ]\n",name);
    exit(1);
}


int main(int argc,char **argv)
{
    struct sockaddr_atmsvc addr;
    struct atm_blli blli;
    char *here;
    int s,n,i,passive;

    if ((s = socket(PF_ATMSVC,SOCK_DGRAM,0)) < 0) {
	perror("socket");
	return 1;
    }
    memset(&addr,0,sizeof(addr));
    memset(&blli,0,sizeof(blli));
    if (!(passive = argc == 1)) {
	if (argc != 2) usage(argv[0]);
	if (strlen(argv[1]) != 40) {
	    fprintf(stderr,"NSAP address must contain exactly 40 hex digits\n");
	    return 1;
	}
	for (i = 0; i < 20; i++) {
	    int tmp;

	    sscanf(argv[1]+2*i,"%2x",&tmp);
	    addr.sas_addr.prv[i] = tmp;
	}
    }
    addr.sas_family = AF_ATMSVC;
    addr.sas_addr.blli = &blli;
    blli.l2_proto = 1;
    blli.next = NULL;
    if (bind(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("bind");
	return 1;
    }
    here = strrchr(argv[0],'/');
    if (!passive) {
	if (connect(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	    perror("connect");
	    return 1;
	}
    }
    else {
	if (listen(s,0) < 0) {
	    perror("listen");
	    return 1;
	}
	if ((n = accept(s,NULL,0)) < 0) {
	    perror("accept");
	    return 1;
	}
    }
    printf("Press [Enter] to continue ");
    fflush(stdout);
    (void) getchar();
    return 0;
}
