/*
  $Id: $

  sunimode.c - get/set S/UNI loopback mode
  
  Christophe Lizzi (lizzi@cnam.fr), December 1999.
  
  This software may be used and distributed according to the terms
  of the GNU General Public License, incorporated herein by reference.
*/

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <atm.h>
#include <linux/atm_suni.h>


static const char* suni_mode[] = {
    "normal operation",
    "diagnostic loopback",
    "line loopback"
};

char* progname;

void usage(void)
{
    fprintf(stderr, "%s [{-n, -d, -l}] [itf]\n"
	    "\t-n: normal operation\n"
	    "\t-d: diagnostic loopback (tx -> rx)\n"
	    "\t-l: line loopback (rx -> tx)\n", progname);
    exit(-1);
}


int main(int argc, char** argv)
{
    int sock, normal_op, diag_loop, line_loop, loop_mode, itf;
    struct atmif_sioc req;

    normal_op = diag_loop = line_loop = itf = 0;
    
    progname = *(argv++);

    while (argc > 1) {
        if ((*argv)[0] == '-') {
            switch ((*argv)[1]) {
	    case 'n':
		normal_op = 1;
		loop_mode = SUNI_LM_NONE;
		break;
	    case 'd':
		diag_loop = 1;
		loop_mode = SUNI_LM_DIAG;
		break;
	    case 'l':
		line_loop = 1;
		loop_mode = SUNI_LM_LOOP;
		break;
	    default:
		usage();
	    }
	}
	else {
	    itf = atoi(*argv);
	    if (itf < 0)
		usage();
	}
	argc--;
	argv++;
    }

 if ((sock = socket(PF_ATMPVC, SOCK_DGRAM, 0)) < 0) {
	perror("socket");
	exit(-1);
    }

    switch(normal_op + diag_loop + line_loop) {

    case 0: /* get the current loopback mode */
	req.number = itf;
	req.length = sizeof(loop_mode);
	req.arg    = (void*) &loop_mode;

	if (ioctl(sock, SUNI_GETLOOP, &req) < 0)
	    perror("ioctl SUNI_GETLOOP");
	else
	    printf("itf %d: %s\n", itf, suni_mode[ loop_mode ]);
	
	exit(loop_mode);
	
    case 1: /* set a new loopback mode */
	req.number = itf;
	req.length = 0;
	req.arg    = (void*) loop_mode;
	
	if (ioctl(sock, SUNI_SETLOOP, &req) < 0)
	    perror("ioctl SUNI_SETLOOP");

	exit(0);
	
    default: /* more than one mode was supplied */
	usage();
    }

    return 0;
}
