/* timeout.c - Processing of Q.2931 timeout events */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 

#include <stdio.h>
#include <errno.h>
#include <assert.h>

#include "atmd.h"

#include "q2931.h"
#include "proto.h"
#include "timeout.h"


#define COMPONENT "Q2931"


static void complain(SOCKET *sock,const char *timer)
{
    diag(COMPONENT,DIAG_FATAL,"Timer %s expired in incompatible state %s",
      timer,state_name[sock->state]);
}


void on_T303(void *user) /* CONNECTING */
{
    SOCKET *sock;

    sock = user;
    diag(COMPONENT,DIAG_DEBUG,"T303 on 0x%lx",sock->id);
    if (sock->state != ss_connecting) complain(sock,"T303");
    send_kernel(sock->id,0,as_close,-ETIMEDOUT,NULL);
    sock->conn_timer = NULL;
    free_sock(sock);
}


void on_T308_1(void *user) /* WAIT_REL or REL_REQ */
{
    SOCKET *sock;

    sock = user;
    diag(COMPONENT,DIAG_DEBUG,"T308_1 on 0x%lx",sock->id);
    if (sock->state != ss_wait_rel && sock->state != ss_rel_req)
	complain(sock,"T308_1");
    send_release(sock,ATM_CV_TIMER_EXP,308); /* @@@ ? */
    sock->conn_timer = NULL;
    START_TIMER(sock,T308_2);
}


void on_T308_2(void *user) /* WAIT_REL or REL_REQ */
{
    SOCKET *sock;

    sock = user;
    diag(COMPONENT,DIAG_WARN,"Trouble: T308_2 has expired");
    if (sock->state != ss_wait_rel && sock->state != ss_rel_req)
	complain(sock,"T308_2");
    /* should initiate restart procedure now ... but we retry forver instead */
    send_release(sock,ATM_CV_TIMER_EXP,308); /* @@@ ? */
    sock->conn_timer = NULL;
    START_TIMER(sock,T308_2);
}


void on_T310(void *user)
{
    on_T303(user);
    diag(COMPONENT,DIAG_DEBUG,"(it's actually T310)");
}


void on_T313(void *user) /* ACCEPTING */
{
    SOCKET *sock;

    sock = user;
    diag(COMPONENT,DIAG_DEBUG,"T313 on 0x%lx",sock->id);
    if (sock->state != ss_accepting) complain(sock,"T313");
    send_release(sock,ATM_CV_TIMER_EXP,313);
    sock->conn_timer = NULL;
    START_TIMER(sock,T308_1);
    new_state(sock,ss_rel_req);
}
