/* qgen.h - constructor/parser generator for Q.2931-like data structures */
 
/* Written 1995 by Werner Almesberger, EPFL-LRC */
 
 
#ifndef QGEN_H
#define QGEN_H

typedef enum { vt_id,vt_case,vt_multi,vt_length } VALUE_TYPE;

typedef struct {
    /* --- the following fields are initialized by the parser */
    VALUE_TYPE type;
    const char *id; /* for value-only and for default tag */
    struct _field *block; /* length */
    struct _tag *tags; /* case or multi */
    /* --- the following fields are initialized in the first phase */
    /* id of default tag */
} VALUE;

typedef struct _field {
    /* --- the following fields are initialized by the parser */
    const char *id;
    int size;
    int var_len;
    int pos; /* modified in the first phase */
    int flush;
    int repetitions;
    VALUE *value;
    int brk; /* may break before this field */
    struct _field *next;
    /* --- the following fields are initialized in the first phase */
    int field; /* field number */
    int jump; /* move by that many bytes before writing that field */
    int group; /* group number, only in first element of group */
    /* --- the following fields are initialized in the second phase */
    int has_required;
    /* --- the following fields are initialized in the third phase */
    int patch;
} FIELD;

typedef struct _id_list {
    /* --- the following fields are initialized by the parser */
    const char *value;
    struct _id_list *next;
    /* --- the following fields are initialized in the third phase */
    int patch;
} VALUE_LIST;

typedef struct _tag {
    /* --- the following fields are initialized by the parser */
    const char *id; /* group id */
    VALUE_LIST *more; /* only for named selectors */
    const char *value;
    FIELD *block;
    struct _tag *next;
    int deflt;
    /* --- the following fields are initialized in the first phase */
    int group;
    int pos;
    /* --- the following fields are initialized in the third phase */
    int patch;
} TAG;


void first(FIELD *def);
void second(FIELD *def);
void third(FIELD *def);

#endif
